package ap;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;

import java.util.Vector;
import java.util.ArrayList;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

//// Frederick    by  Ann Pierce
// In 1701 Frederick William's son, Elector Frederick III, proclaimed himself King Frederick I of Prussia
//
// My bot uses Minimum Risk Movement for movement and it uses a Pattern Matching for a gun
// Parts of the Minimum Risk Movement taken from Voidious' twin duel bot Luminarious.

public class Frederick extends AdvancedRobot
{	
	//have these static as thier set before thier used, thus saving room
	static RoundRectangle2D.Double battlefield;
	static Point2D.Double myLocation;
	static boolean isInMelee;
	static double lastVelocity;
	static long timeOfVChange;

	//Can't be static or will cause problems.
	Vector recentlyVisitedLocations = new Vector();
	static Vector waves = new Vector();
	
	public void run()
	{
		//If the battlefield hasn't been set yet, we set it here, we use a RoundRectangle to aproximate wall smoothing
		if(battlefield == null)
			battlefield = new RoundRectangle2D.Double(20,20,getBattleFieldWidth()-40,getBattleFieldHeight()-40,180,180);

		setColors(Color.black, Color.white, Color.black);

		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		while(true) {
			//Check every turn
			if(getOthers() > 1) isInMelee = true;

			//Turn the radar 360 degrees, so we know we covered everything before resetting
			turnRadarRightRadians(Math.PI*2);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		///////////////////////////////
		//////////// Setup ////////////
		///////////////////////////////
		// Here we set up most of the general data used later.
		double absoluteBearingToEnemy, distanceToEnemy, energyOfEnemy, latVelocity;
		int i, j;
		
		absoluteBearingToEnemy = e.getBearingRadians() + getHeadingRadians();
		distanceToEnemy = e.getDistance();
		energyOfEnemy = e.getEnergy();
		myLocation = new Point2D.Double(getX(), getY());
		Point2D.Double locationOfEnemy = project(myLocation, absoluteBearingToEnemy, distanceToEnemy);
		
		latVelocity = e.getVelocity()*Math.sin(e.getBearingRadians() - absoluteBearingToEnemy);
		int direction = (latVelocity >= 0) ? 1 : -1;

//		drawCircle(myLocation, 20, Color.blue);
//		drawCircle(locationOfEnemy, 20, Color.red);

		//////////////////////////////////
		//////////// Movement ////////////
		//////////////////////////////////
		// For movement Frederick uses Minimum Risk Movement
		// Its kinda like a mixxy mirror movement in one on one
		double bestAngle, testAngle, lowestRisk, testRisk, goAngle, turnAngle;

		//After a little work I came up with this, found later that voidious does the same thing
		if (Math.random() > 0.5) recentlyVisitedLocations.add(0, myLocation);
		//recentlyVisitedLocations.add(0, myLocation);
		
		Point2D.Double testLocation, testLocation2;

		bestAngle = 0;
		testAngle = 0;
		lowestRisk = Double.POSITIVE_INFINITY;
		testRisk = 0;
		
		//This is the main loop, the (2D / ?D) determines the number of points to make at ?
		for(double a = 0; a < 2; a += (2D / 50D)) {
			testAngle = a * Math.PI;
			
			//The point to test
			testLocation = project(myLocation, testAngle, 50 + Math.random() * 300);
			
			//If the battlefield doesn't contain the point, don't fret, we just won't move there
			//we use the full location as i'm to lazy to make two branches of the same code.
			if(battlefield.contains(testLocation)) {
				//Got this from Voidious' twin duel bot
				testRisk = limit(0.5, (energyOfEnemy / getEnergy()), 2)
							/ testLocation.distanceSq(locationOfEnemy)
							* (.5 + Math.pow(Math.abs(Math.cos(absoluteBearingToEnemy - testAngle)),2));
				
				//Since thier added at the beginning we subtract so we don't like, forever avoid that location
				for(i=0; i < 6 && i<recentlyVisitedLocations.size(); i++)
					testRisk *= ((1 + 1500D - (200D * i)) / testLocation.distanceSq((Point2D.Double)recentlyVisitedLocations.get(i)));

				//This is orbit code!
				if(Utils.normalRelativeAngle(getHeadingRadians() - testAngle) < (Math.PI / 4)) testRisk *= 4;
			}
			else
				testRisk = Double.POSITIVE_INFINITY;

			if(testRisk < lowestRisk) {
				lowestRisk = testRisk;
				bestAngle = testAngle;
			}
			
			testRisk = 0;
		}

        goAngle = Utils.normalRelativeAngle(bestAngle - getHeadingRadians());
		turnAngle = Math.atan(Math.tan(goAngle));
		setMaxVelocity(Math.random() * 2 + 6);
		setTurnRightRadians(turnAngle);
		setAhead((goAngle == turnAngle) ? 100 : -100);

		/////////////////////////////
		//////////// Gun ////////////
		/////////////////////////////
		// The gun is unfinished, but will be pattern matching
		// First we need to log the current move
		double firePower = 1.9;
		if(e.getDistance() < 200) firePower = 3;
		if(e.getEnergy() < 20) firePower = e.getEnergy() / 10;
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearingToEnemy-getGunHeadingRadians()));
		
		//////////// Radar ////////////
		// Here we turn the radar back to face the enemy, but this will only happen if we are in a duel
		// Resetting it in a duel will not effect the 360 resetting fo the movement
		// We multiply the normal relative angle by two so it will slide past the enemy to twice
		// what it would normally, so that way we can keep a good lock without slipping.
		if(!isInMelee)
			setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearingToEnemy - getRadarHeadingRadians()) * 2);
	}
	
	//A very sad way of flattening. Makes it a little better in one on one
	public void onHitByBullet(HitByBulletEvent event) {
		recentlyVisitedLocations.add(0, myLocation);
	}

	//This is my best friend, it allows you to project onto the x and y grid based on a
	//base location, the absolute angle to the new location and the distance to the new location
	public static double limit(double min, double value, double max) { return Math.max(min, Math.min(value, max)); }
	public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length)
	{ return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length); }
}
