package ph.melee;

import ph.*;
import ph.intelligence.*;
import ph.movement.*;
import ph.targeting.*;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

public class ArcherME extends ModularRobot {
    
    public void run() {
        super.run();
        setColors(Color.green.darker(), Color.green, Color.white);
        addModule(new RadarModule(this));
        addModule(new AntiGravityMovementModule(this));
        addModule(new TargetingModule_GFonly(this));
        addCustomEvent(new RadarTurnCompleteCondition(this));
        addCustomEvent(new MoveCompleteCondition(this));
        while (true) {
            executeAllModules();
            execute();
        }
    }
    
    public void onCustomEvent(CustomEvent evt) {
        if(evt.getCondition() instanceof RadarTurnCompleteCondition) {
            executeModuleAt(0);
        } else if(evt.getCondition() instanceof MoveCompleteCondition) {
            executeModuleAt(1);
        }
    }
    
}
