package blir.micro.blixi; 
  
import robocode.*;

import java.awt.Color;

import static robocode.util.Utils.*; 
  
/** 
 * Blixi - a robot by Travis Bruce 
 */
public class Blixi extends AdvancedRobot { 

	private static final double OptD = 125D;
	private static final double DodgeD = 90D;
    //bullets shot and hit with normal firing mode 
    private static int bhit1, bshot1; 
    //current firing mode 
    private static boolean mode; 

    //the direction we're moving 
    private int dir = 1; 
    //are we close to a wall? : are we close to a robot?
    private boolean wall = false, rbt = false; 
    //enemy's energy 
    private double en = 100D; 
	//shots fired by enemy
	private int shotsFired;
	//cumulative power used by the enemy; used to calculate average fire power
	private double powerSum;

    /** 
     * run: Blixi's default behavior 
     */
    public void run() { 
        setColors(Color.black, Color.green, Color.green, Color.green, null); 
        setAdjustRadarForRobotTurn(true); 
        setAdjustGunForRobotTurn(true); 
        setAdjustRadarForGunTurn(true); 
		//if (bshot1 != 0) out.println("Main Gun Accuracy: " + (double) bhit1 / bshot1);
        for (;;) { 
            if (getRadarTurnRemaining() == 0) { 
                //should only happen if we lose track of them, which should never happen 
                setTurnRadarRight(Double.POSITIVE_INFINITY); 
            } 
            //check if we're too close to the wall (50 pixels) 
            wall = cw(50, true); 
            execute(); 
        } 
    } 
  
    /** 
     * onScannedRobot: What to do when you see another robot 
     */
    public void onScannedRobot(ScannedRobotEvent e) { 
  
        //check if we're too close to the other robot (150 pixels) 
        rbt = d(e.getDistance()); 
  
		//absolute bearing
        double absBear = getHeadingRadians() + e.getBearingRadians(); 
  
        //track them with our radar 
        double radarTurn = normalRelativeAngle(absBear - getRadarHeadingRadians()); 
        radarTurn += (radarTurn < 0 ? -1 : 1) * Math.atan(36.0 / e.getDistance()); 
        setTurnRadarRightRadians(radarTurn); 
  
        //fire power the enemy used
        double enemyPower = en - e.getEnergy();
		
		//average power used by the enemy
		double avgPower = powerSum / shotsFired;
		
		//distance from the enemy to be in the sweet spot
		double optimalDistance = Rules.getBulletSpeed(avgPower) * OptD / Rules.MAX_VELOCITY;
		
		//are we in the sweet spot?
		boolean sweet = isOptimal(e.getDistance(), optimalDistance);
		
		//out.printf("Sweet:%b\n", sweet);
			
        if (enemyPower <= 3 && enemyPower > 0) { 
            //they seem to have fired
			if (shotsFired > 10) {
				//only keep record of up to last 10 shots fired
				shotsFired = 0;
				powerSum = 0;
			}
			shotsFired++;
			powerSum += enemyPower;
			// enemy's current gun heat
			double heat = 1D + enemyPower / 5D;
			boolean dodge = DodgeD / Rules.MAX_VELOCITY < heat / 0.1;
			//out.printf("Dodge:%b&&%b\n", dodge, sweet);
            if (!cw(75, false) && sweet && dodge) {
				// in the sweet spot, not near a wall, and have time to dodge
                cd(); 
            } 
        } 
		
        //record new energy 
        en = e.getEnergy(); 
  
        //circle around them if we're close enough, move away if we're too close
        setTurnRightRadians(normalRelativeAngle(e.getBearingRadians() + Math.PI / 2.0 + dir * (e.getDistance() - optimalDistance > 0 ? - Math.PI / 16.0 : Math.PI / 16.0))); 

		//double optimalVelocity = Math.min(Rules.getBulletSpeed(Rules.MAX_BULLET_POWER), e.getDistance() * e.getVelocity() / D + 10);
		
		double pow = Math.min(shotsFired == 0 ? 2D : (sweet ? avgPower / 2.0 : 1.5 * avgPower), Rules.MAX_BULLET_POWER);
		//double pow = Math.min(sweet ? avgPower / 2.0 : 1.5 * avgPower, Rules.MAX_BULLET_POWER);
		
		//aim the gun based on our firing mode
        setTurnGunRightRadians(normalRelativeAngle(absBear - getGunHeadingRadians() - (!mode ?  
                Math.asin(e.getVelocity() * Math.sin(Math.PI - absBear + e.getHeadingRadians()) / Rules.getBulletSpeed(getEnergy() > pow ? pow : getEnergy()))  
                : 0))); 
  
		if (getGunHeat() == 0 && !mode) {
			bshot1++;
			if (bshot1 > 10) {
				mode = (double) bhit1 / bshot1 < .10;
				//if (mode) out.println("Switching firing modes!");
			}
		} 

		//out.printf("Pow:%.1f\n", pow);
        //fire! 
        setFire(pow); 
  
        //all power ahead! 
        setAhead(dir * 32);
    } 
  
    public void onHitWall(HitWallEvent e) { 
        //out.println("Ahh! A wall!"); 
        cd(); 
    }  
  
    private boolean d(double d) { 
        if (d < 150) { 
            //we're close to the robot (within 150 pixels) 
            if (!rbt) { 
                //we're not already escaping the robot, so let's change direction 
                cd(); 
            } 
            return true; 
        } 
        return false; 
    } 
  
    private boolean cw(int d, boolean cw) { 
        if (getX() < d || getY() < d || getBattleFieldWidth() - getX() < d || getBattleFieldHeight() - getY() < d) { 
            //we're close to the wall 
            if (!wall && cw) { 
                //we're not already escaping the wall, so let's change direction 
                cd(); 
            } 
            return true; 
        } 
        return false; 
    } 
  
    private void cd() { 
        dir = -dir; 
    } 
  
    public void onBulletHit(BulletHitEvent e) { 
        if (!mode) { 
            bhit1++; 
        } 
    } 
	
	public boolean isOptimal(double dist, double opt) {
		return Math.abs(dist - opt) < (dist > opt ? 100 : 20);
	}
}
