package sam;
import robocode.*;
import java.awt.Color;

/**
 * Samspin - a robot by Sam
 */
public class Samspin extends AdvancedRobot
{
	/**
	 * run: Samspin's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		setColors(Color.red,Color.yellow,Color.blue);
		setAdjustGunForRobotTurn(true);
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			turnGunRight(360);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		setTurnRight(1000);
		setAhead(1000);
		// Calculate exact location of the robot
		double absoluteBearing = getHeading() + e.getBearing();
		double bearingFromGun //superuncopify
		= normalRelativeAngle(absoluteBearing - getGunHeading());
		// If it's close enough, fire!
		if (Math.abs(bearingFromGun)//uncopify
			 <= 3) {
			turnGunRight(bearingFromGun);
			// We check gun heat here, because calling fire() 
			// uses a turn, which could cause us to lose track
			// of the other robot.
			if (getGunHeat()//uncopyfi
			== 0)
				fire(3);
		}
		// otherwise just set the gun to turn.
		// Note:  This will have no effect until we call scan()
		else {
			turnGunRight(bearingFromGun);
		}
		// Generates another scan event if we see a robot.
		// We only need to call this if the gun (and therefore radar)
		// are not turning.  Otherwise, scan is called automatically.
		if (bearingFromGun == 0)
			scan();
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		setBack(50);
		setTurnRight(90);
		setAhead(50);
		turnGunRight(e.getBearing());
	}
		// Helper function
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	
}
}
