package ags.rougedc.waves;

import ags.rougedc.robots.*;
import ags.utils.points.*;

/**
 * @author Alexander Schultz
 */
public class SelfWave extends Wave {
    private final EnemyRobot target;
    private final EnemyRobot statictarget;
    public double targetedGF;
    
    public SelfWave(AbsolutePoint origin, EnemyRobot target, double power) {
        super(origin, power);
        
        this.target = target;
        this.statictarget = target.clone();
    }

    public SelfWave(SelfWave source) {
        super(source);
        this.target = source.target;
        this.statictarget = source.statictarget;
    }
    
    public EnemyRobot getTarget() {
        return target;
    }
    
    @Override
    public EnemyRobot getStaticTarget() {
        return statictarget;
    }
}
