package simonton.nano;

import robocode.*;
import robocode.util.*;

/*
 * This is a pattern matcher that locks on to a target & inches in for the kill.
 * 
 * Version 1.0: + codesize: 249.
 */
public class WeekendObsession_Melee extends AdvancedRobot {
	static final int maxMatchLen = 30;
	static final int targetDistance = 200;
	static final int moveLength = 200;//targetDistance / 14 * 8;
	static final int firePower = 2;
	static final int fireSpeed = 20 - firePower * 3;
	static final double ATTACK = 36 * Math.PI / 180;
	
	static int distance;

	public void run() {
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(distance = 1000000);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		int matchLen = maxMatchLen;
		double a;
		int dist;
		int matchPos;
		int i;

		// move.
		if ((a = getVelocity()) == 0) {
			setAhead((Math.random() - .5) * (2 * moveLength));
		}
		
		if ((dist = (int) e.getDistance()) < distance + 32) {
            
			// turn.
			setTurnRightRadians(
				a * (ATTACK / 8)
					* Math.signum(targetDistance - (distance = dist))
				+ Math.cos(a = e.getBearingRadians()));
			a += getHeadingRadians();
				
			// look.
			setTurnRadarRightRadians(Double.POSITIVE_INFINITY 
				* Utils.normalRelativeAngle(a - getRadarHeadingRadians()));
			
			// think.
//////////////////////
// for long challenges
//if (getRoundNum() >= 35) {
//	enemyHistory = enemyHistory.substring(0, enemyHistory.length() - 1);
//}
// for long challenges
//////////////////////
			enemyHistory = 
				String.valueOf((char) Math.rint(
					e.getVelocity() * Math.sin(e.getHeadingRadians() - a)))
				.concat(enemyHistory);
			while(
				(matchPos = 
					enemyHistory.indexOf(
						enemyHistory.substring(0, matchLen--), 
						i = dist / fireSpeed)) 
				< 0);
			
			// aim.
			do {
				a += (double) (short) enemyHistory.charAt(--matchPos) / dist;
			} while (--i > 0);
			setTurnGunRightRadians(
				Utils.normalRelativeAngle(a - getGunHeadingRadians()));
			
			// fire.
			fire(firePower);
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		distance = 1000000;
	}

	static String enemyHistory = ""
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 2
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char)-1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char)-2 + (char)-4 + (char)-6
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-7 + (char)-6 + (char)-5 + (char)-4
		+ (char)-3 + (char)-2 + (char)-1 + (char)0
		+ (char) 2 + (char) 4 + (char) 6 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 7 + (char) 6 + (char) 5 + (char) 4
		+ (char) 3 + (char) 2 + (char) 1 + (char) 0;
}
