package myl.nano;
import robocode.*;
import java.awt.Color;

/**
 * KomoriNinja - a ninja by Martin Y Lepsoy (DrLoco)
 *
 *
 * 07.11.2002 - Version 1.1 - codesize 246
 *
 * New radar management: The radar spins while we are tracking the closest target
 * The wall avoiding thing is gone. Gave him a trianglemovement instead.
 * Added color!
 *
 *
 * 28.10.2002 - Version 1.0 - codesize 249
 *
 * KomoriNinja is supposed to stay close to the walls and avoid them so it won't get hurt.
 * Linear prediction with distance modifier and some randomness
 */

public class KomoriNinja extends AdvancedRobot
{
	static String	target;
	static double	moveDirection;
	static double	targetDistance;
	
	public void run() {
		moveDirection = 170;
		
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		Color c = Color.lightGray;
		setColors( c , c , Color.magenta );
		
		do {
			if ( getVelocity() == 0 ) {
				setAhead( moveDirection = - moveDirection );
				setTurnRight( 72 );
			}
			if ( target == null || getGunHeat() > 1 ) {
				setTurnRadarRightRadians( 100 );
			}
			execute();
		} while( true );
	}
	
	public void onScannedRobot( ScannedRobotEvent e ) {
		//set new target if we have none, or scanned robot is 120 closer than current target
		if ( target == null || e.getDistance() + 120 < targetDistance ) {
			target = e.getName();
		}
		if ( target == e.getName() ) {
			targetDistance = e.getDistance();
			double targetBearing = getHeadingRadians() + e.getBearingRadians();
			//Aimcode from sandboxmicro by Paul Evans
			setTurnGunRightRadians( Math.sin( targetBearing - getGunHeadingRadians() + ( 0.7 - targetDistance / 1200.0 + Math.random() * 0.4 ) * Math.asin( e.getVelocity() / 11.0 * Math.sin( e.getHeadingRadians() - targetBearing ) ) ) );
			if ( setFireBullet( 30 * getEnergy() / targetDistance ) == null );
				setTurnRadarRightRadians( Math.tan( targetBearing - getRadarHeadingRadians() ) * 3 );
		}
	}
	
	public void onRobotDeath( RobotDeathEvent e ) {
		target = null;
	}
}