/* 
	Basilisk - a MiniBot featuring stop and go, random movement, and guessfactor targeting

									By Slugzilla

CREDITS: Basilisk is based off of many ideas and concepts from the RoboWiki. Specifically, I used code/drew inspiration from
RandomMovementBot, GFTargetingBot, Aristocles, RaikoNano, Tityus, Raiko, Cotillion, BlackWidow, HedgehogGF, Vyper, Thorn, and EpeeistMicro.
Special thanks to Dsekercioglu for help identifying bugs and beating bullet shielders =)
 */

package slugzilla;
import robocode.*;
import java.awt.geom.*;
import robocode.util.Utils;
import robocode.util.*;
import java.awt.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
 
public class Basilisk extends AdvancedRobot {
	//movement
	static double enemyBulletVelocity;
	static double hits;
	static double enemyEnergy;
	static double deltaT;
	static double lastDeltaT;
	static double lastReverseTime;
	static double direction = 1;
	static int movementMode;

	//gun
	boolean containsBullet;
	static double enemyDirection;
	private static double lateralDirection;
	private static double lastEnemyVelocity;
	
    public void run() {
        setAdjustRadarForGunTurn(true);
 		setAdjustGunForRobotTurn(true);
		lateralDirection = 1;
		lastEnemyVelocity = 0;
		setBodyColor(new Color(40, 100, 100));
		setGunColor(new Color(34, 50, 50));
		setRadarColor(new Color(0, 255, 0));
		setScanColor(new Color(0, 255, 0));
	 	turnRadarRightRadians(Double.POSITIVE_INFINITY);
        do {
            scan();
        } while (true);
    }
 
    public void onScannedRobot(ScannedRobotEvent e) {
		//radar ↓
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
    	setTurnRadarRightRadians(Utils.normalRelativeAngle(radarTurn));
		//movement ↓
 		double enemyDistance =  e.getDistance();
    	double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double v2; 
		double offset;
		double theta;
		int antiRam;
		offset = 2 - movementMode + (antiRam = ((int)(100/enemyDistance)));
		
		while(!new Rectangle2D.Double(18, 18, 764, 564).
			contains(getX() + 160 * Math.sin(v2 = absoluteBearing + direction * (offset -= .02)), getY() + 160 * Math.cos(v2)));

		setTurnRightRadians(Math.tan(v2 -= getHeadingRadians()));
		deltaT = getTime() - lastReverseTime;
		System.out.println(deltaT);
		if (enemyEnergy > e.getEnergy() && enemyEnergy - 3 <= e.getEnergy()) {
			enemyBulletVelocity = 20 - 3 * (enemyEnergy - e.getEnergy());
		} 		
		if (movementMode * -Math.random() > Math.pow((theta = 0.5952 * enemyBulletVelocity / enemyDistance), theta) + antiRam || offset < Math.PI/4) {	
			if (deltaT >= lastDeltaT + (6/Math.abs(getVelocity())) || deltaT <= lastDeltaT - (6/Math.abs(getVelocity()))) {
				direction = -direction;
				lastDeltaT = deltaT;
				lastReverseTime = getTime();
			}
		}
		double energyDrop = enemyEnergy - e.getEnergy();
		if (antiRam + energyDrop > movementMode) {
			setAhead(((3 + (int)(energyDrop * 1.999999)) << 3 ) * Math.signum(Math.cos(v2)));
		}	
		enemyEnergy = e.getEnergy();
		//gun
		double enemyVelocity = e.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(e.getHeadingRadians() - absoluteBearing));
		}
		GFTWave wave = new GFTWave(this);
		wave.gunLocation = new Point2D.Double(getX(), getY());
		GFTWave.targetLocation = GFTUtils.project(wave.gunLocation, absoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = Math.min(3, Math.min(2, Math.min(getEnergy()/8, e.getEnergy()/4)) + 3 * antiRam);
		wave.maxEscapeAngle = Math.asin(8/(20 - 3 * wave.bulletPower));
		wave.binWidth = wave.maxEscapeAngle / (double)wave.MIDDLE_BIN;
		double localEnemyDirection = (enemyDirection = Math.signum(0.00000000000001 + (e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing)) + (enemyDirection / 100))) * wave.binWidth;
		int i = 2;	
		int forwardWallSegment = 0;
		do {
			forwardWallSegment += fieldContains(absoluteBearing + (localEnemyDirection * ((wave.MIDDLE_BIN / 4) << i)), enemyDistance);
		}
		while (--i > 0);
		int reverseWallSegment = fieldContains(absoluteBearing + (localEnemyDirection * (-(wave.MIDDLE_BIN / 2))), enemyDistance);
		
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity, forwardWallSegment, reverseWallSegment);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = absoluteBearing;
		
		if (getEnergy() > 0.4 && getGunHeat() == 0.0) {
			setFire(wave.bulletPower);	
			wave.containsBullet = true;
			addCustomEvent(wave);
		} else {
			wave.containsBullet = false;
			addCustomEvent(wave);
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + wave.mostVisitedBearingOffset())+ ((Math.random()/500)-0.002));
    }
	//movement ↓
	public void onHitByBullet(HitByBulletEvent e) {	
		enemyEnergy += Rules.getBulletHitBonus(e.getPower());
		if (Math.abs(deltaT) > 30) {
			hits += 5 / enemyBulletVelocity;
		}
		if (hits > getRoundNum() + 1) {
			movementMode = -1;
		}
    }
	public void onBulletHit(BulletHitEvent e) {
		enemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}
	//gun
	private int fieldContains(double heading, double distance) {
		return Integer.signum(new Rectangle2D.Double(18, 18, 764, 564).outcode(getX() + distance * Math.sin(heading), getY() + distance * Math.cos(heading)));
	}
}
//gun
class GFTWave extends Condition {
	static Point2D targetLocation;
 	boolean containsBullet;
	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double lateralDirection;
 
	private static final double MAX_DISTANCE = 1000;
	private static final int BINS = 25;
	static final int MIDDLE_BIN = (BINS - 1) / 2;
	static double maxEscapeAngle;
	static double binWidth;
 	static int ticksSinceVelocityChange;
	private static double[][][][][][][] statBuffers = new double[3][5][4][3][3][2][BINS];
 
	private double[] buffer;
	private AdvancedRobot robot;
	private double distanceTraveled;
 
	GFTWave(AdvancedRobot _robot) {
		this.robot = _robot;
	}
 
	public boolean test() {
		advance();
		if (hasArrived()) {
			for (int i = 0; i < BINS; i++) {
				buffer[i] = 0.998 * buffer[i];
			}
			if (containsBullet) {
				buffer[currentBin()]++;
			} else {
				buffer[currentBin()] += 0.15;
			}
			robot.removeCustomEvent(this);
		}
		return false;
	}
 
	double mostVisitedBearingOffset() {
		return (lateralDirection * binWidth) * (mostVisitedBin() - MIDDLE_BIN);
	}
 
	void setSegmentations(double distance, double velocity, double lastVelocity, int forwardWall, int reverseWall) {
		int deccelIndex;
		if((deccelIndex = Integer.signum((int)(Math.abs(velocity)) - (int)(Math.abs(lastVelocity))) + 1) != 1) {
			ticksSinceVelocityChange = 0;
		}
		ticksSinceVelocityChange++;
		int velocityChangeIndex = (Math.min(60, ticksSinceVelocityChange)) / 15;
		int distanceIndex = ((int)distance / 200);
		int velocityIndex = (int)Math.abs(velocity / 3);
		int forwardWallSegment = forwardWall;
		int reverseWallSegment = reverseWall;
		buffer = statBuffers[deccelIndex][velocityChangeIndex][distanceIndex][velocityIndex][forwardWallSegment][reverseWallSegment];
	}
 
	private void advance() {
		distanceTraveled += GFTUtils.bulletVelocity(bulletPower);
	}
 
	private boolean hasArrived() {
		return distanceTraveled > gunLocation.distance(targetLocation) - 18;
	}
 
	private int currentBin() {
		int bin = (int)Math.round(((Utils.normalRelativeAngle(GFTUtils.absoluteBearing(gunLocation, targetLocation) - bearing)) /
				(lateralDirection * binWidth)) + MIDDLE_BIN);
		return GFTUtils.minMax(bin, 0, BINS - 1);
	}
 
	private int mostVisitedBin() {
		int mostVisited = MIDDLE_BIN;
		for (int i = 0; i < BINS; i++) {
			if (buffer[i] > buffer[mostVisited]) {
				mostVisited = i;
			}
		}
		return mostVisited;
	}	
}
 
class GFTUtils {
	static double bulletVelocity(double power) {
		return 20 - 3 * power;
	}
 
	static Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
 
	static double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
 
	static int sign(double v) {
		return v < 0 ? -1 : 1;
	}
 
	static int minMax(int v, int min, int max) {
		return Math.max(min, Math.min(max, v));
	}
}