package theo;
import robocode.*;
import java.awt.Color;
import java.util.*;
import java.awt.geom.*;
import java.awt.Graphics2D;
import robocode.util.Utils;

/**
 * Hydrogen - a robot by Theo
 */

//Maybe only aim right when we're about to shoot
public class Hydrogen extends AdvancedRobot implements Types
{

	final boolean isTC = false;
	final boolean isMC = false;
 
	Nucleus enemy = new Nucleus();
	Behavior utils = new Behavior(this, enemy);
	Gun gWave = new Gun(this, enemy, utils);
	Movement sWave = new Movement(this, enemy, utils);
	
	final Color purple = Color.getHSBColor(0.8f, 0.9f, 0.8f);
	final Color puce = new Color(190,255,0);
	
	Random duck = new Random();
	
	Rectangle2D.Double playField;
	
	///OUR STATS///
	double x,y,bPower;
	Point2D.Double position;
	double heading, velocity;
	int lastDirection;
	long shotsFired, shotsHit;
	double accuracy;

	public boolean types(Hydrogen H){
		try {
			
			enemy = new Nucleus();
			utils = new Behavior(H, enemy);
			gWave = new Gun(H, enemy, utils);
			sWave = new Movement(H, enemy, utils);
			
			return false;

		}
		catch (Exception e){
			out.println(e.getMessage());
		} return true;
	}

	public void run() {
		// Initialization of the robot should be put here

		setColors(purple,Color.black,puce);
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		playField = new Rectangle2D.Double(18,18,getBattleFieldWidth()-36,getBattleFieldHeight()-36);
		
		//System.out.println(types(this));

		
		while(true) {
			//This: abnormalCode-->movement
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		enemy.energy = e.getEnergy();
		
		updateSelf();
		
		enemy.distance = e.getDistance();
		enemy.heading = e.getHeadingRadians();
		enemy.velocity = e.getVelocity();
		enemy.bearing = e.getBearingRadians();
		enemy.heading = e.getHeadingRadians();
		
		enemy.absBearing = heading + enemy.bearing;
		enemy.absBearing = Utils.normalRelativeAngle(enemy.absBearing);
		
		enemy.position = utils.getEnemyPosition(enemy.distance, enemy.absBearing);
		
		enemy.lateralHeading = Utils.normalRelativeAngle(enemy.heading - enemy.absBearing);
		enemy.lateralVelocity = enemy.velocity * Math.sin(enemy.lateralHeading);
		
		enemy.timeSinceReverse ++;
		
		if(enemy.lateralVelocity!=0){
			enemy.lateralDirection = (int)(utils.sign(enemy.lateralVelocity));
			if(enemy.lateralDirection!=lastDirection){ enemy.timeSinceReverse = 0; }
			lastDirection = new Double(enemy.lateralDirection).intValue();
		}
		else{ enemy.lateralDirection = (int)lastDirection; }
		
		
		
		double radarOffset = Utils.normalRelativeAngle(
				Utils.normalAbsoluteAngle(enemy.absBearing)-
				Utils.normalAbsoluteAngle(getRadarHeadingRadians()));
		setTurnRadarRightRadians(radarOffset*2);
		
		sWave.update();
		gWave.update();
		
		enemy.lastLateralVelocity = enemy.lateralVelocity;
	
	}
	
	public void updateSelf(){
		heading = getHeadingRadians();
		velocity = getVelocity();
		x = getX(); y = getY();
		position = new Point2D.Double(x,y);
		bPower = 2;
		if(isMC) bPower = 3;
		if(enemy.energy<16&!isMC)
			bPower = utils.limit(.1,enemy.energy/5,3);
		
	}
	

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		sWave.onHit(e.getBullet());
	}
	public void onBulletHitBulletEvent(BulletHitBulletEvent e){
		sWave.onHit(e.getBullet());
	}
	public void onBulletHit(BulletHitEvent e){
		shotsHit++;
	}
	public void onDeath(DeathEvent e){
		out.println("ourAccuracy: " + accuracy);
		out.println("theirAccuracy: " + enemy.accuracy);
		out.println("----------");
		out.println("limitFactor" + sWave.flattenFactor);
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		
	}
	
	public void onPaint(Graphics2D g){
		
		gWave.paint(g);
		sWave.paint(g);
		
	}
		
}

class Nucleus{
	
	double x;
	double y;
	Point2D.Double position;
	
	double energy;
	double bearing;
	double heading;
	double distance;
	double velocity;
	double predictedPosition;
	double absBearing;
	double lateralHeading;
	double lateralVelocity;
	double lateralDirection;
	double lastLateralVelocity;
	double timeSinceReverse;
	double shotsFired;
	double shotsHit;
	double accuracy;
	
	double enemyAcceleration;

}

class Behavior{
	
	double PI = Math.PI;
	double gunOffset, deltaX, deltaY;
	
	Nucleus e;
	Hydrogen H;
	
	double predictX, predictY;
	double timeSteps, bulletFlightTime;
	double antDistance; double bulletSpeed;
	double allowedDistance;
	Point2D.Double startPosition, nextPosition;
	
	String alphabet = "abcdefghijklmnopqrstuvwxyz";
	
	//This is a constructor method
	//This method is called when we initialise this class up there ^^
	//Consider it like the main(String[] args) method if this were a
			//standalone class.
	//Check out the two arguments we give this class when we call it from the SketchBall class.
	//We give this class a way to reference both the Sketchball class, and the Nucleus class.
	Behavior(Hydrogen type, Nucleus type2){
		H = type;
		e = type2;
	}
	
	//A constructor method will always have the form
	//ClassName(){ }
	//Nothing else. The Class's name here happens to be 'Behavior', and we fed it some arguments

	public double normaliseBearing(double bearing){
		if(bearing<-PI)
			return (bearing+2*PI);
		if(bearing>PI)
			return (bearing-2*PI);
		return bearing;
	}
	
	public double normaliseAngle(double angle){
		if(angle<0)
			return (angle+PI*2);
		if(angle>2*PI)
			return (angle-2*PI);
		return angle;
	}
	
	public double bSpeed(double power){
		return (20-3*power);
	}
	
	public Point2D.Double project(Point2D.Double source, double distance, double angle){
		return new Point2D.Double(source.x + distance*Math.sin(angle),
			source.y + distance*Math.cos(angle));
	}
	public Point2D.Double project(double x, double y, double distance, double angle){
		return new Point2D.Double(x + distance*Math.sin(angle),
			y + distance*Math.sin(angle));
	}
	
	public Point2D.Double correctPosition(Point2D.Double pos){
		pos.x = limit(18,pos.x,H.getBattleFieldWidth()-18);
		pos.y = limit(18,pos.y,H.getBattleFieldHeight()-18);
		return pos;
	}
	
	public double limit(double low, double med, double high){
		if(low<=high)
			return Math.min(Math.max(low,med),high);
		else
			return Math.max(Math.min(low,med),high);	
	}
	
	public Point2D.Double getEnemyPosition(double dist, double angle){
		return project(H.position, dist, angle);
	}

	public double predictPosition(){
		
		deltaX = e.distance*Math.sin(e.absBearing);
		deltaY = e.distance*Math.cos(e.absBearing);
		
		e.x = deltaX + H.position.x;
		e.y = deltaY + H.position.y;
	
		gunOffset = Math.atan2(deltaX,deltaY);
		gunOffset -= H.getGunHeadingRadians();
		gunOffset = normaliseBearing(gunOffset);
			
		antDistance = e.distance;
		bulletSpeed = bSpeed(H.bPower);
		bulletFlightTime = antDistance/bulletSpeed;
		
		allowedDistance = e.velocity*bulletFlightTime;
		
		startPosition = new Point2D.Double(e.x,e.y);
		
		for(int i = 0; i < 10; i ++){
			nextPosition = project(startPosition, allowedDistance, e.heading);
			antDistance = nextPosition.distance(H.position);
			bulletFlightTime = antDistance/bulletSpeed;
			allowedDistance = e.velocity*bulletFlightTime;
		}
		
		if(!H.playField.contains(nextPosition)){
			nextPosition = correctPosition(nextPosition);
		}
		
		gunOffset = Math.atan2(nextPosition.x-H.position.x,nextPosition.y-H.position.y);
		gunOffset -= H.getGunHeadingRadians();
		gunOffset = normaliseBearing(gunOffset);
		
		return gunOffset;

	}
	
	double width, height;
	
	public double GreatestDistance(){
		width = H.playField.getWidth();
		height = H.playField.getHeight();
		return Math.sqrt(width*width+height*height);
	}
	
/*	public StringBuilder appendState(StringBuilder state){
		Gun current = H.gWave;
		state = state.append(toString(current.dH));
		state = state.append(toString(current.fP));
		state = state.append(toString(current.d));
		state = state.append(toString(current.v));
		state = state.append(toString(current.lH));
		state = state.append(toString(current.bP));
		state = state.append(toString(current.lD));
		state = state.append(toString(current.nW));
		state = state.append(toString(current.lv));
		state = state.append(toString(current.llD));
		state = state.append(toString(current.sV));
		state = state.append(toString(current.lsV));
		return state;
	}
*/
	public String toString(int num){
		char letter = alphabet.charAt(num%26);
		return new Character(letter).toString();
	}
	
	public double maxEscapeAngle(){
		return Math.asin(8/bSpeed(H.bPower));
	}
	public double maxEscapeAngle(double vel){
		return Math.asin(8/vel);
	}
	
	public double getOffset(Point2D.Double pos, Point2D.Double tar, Gun wave){
		return limit(-1,normaliseBearing(absBearing(pos,tar)-wave.absBearing)/wave.maxEscapeAngle,1);
	}
	public double getOffset(Point2D.Double pos, Point2D.Double tar, Movement wave){
		return limit(-1,normaliseBearing(absBearing(pos,tar)-wave.angleFromEnemy)/wave.maxEscapeAngle,1);
	}
	
	public double absAngle(Point2D.Double source, Point2D.Double target){
		return normaliseAngle(Math.atan2(target.x-source.x,target.y-source.y));
	}
	
	public double absBearing(Point2D.Double source, Point2D.Double target){
		return normaliseBearing(Math.atan2(target.x-source.x,target.y-source.y));
	}

	public double sign(double num){
		return(num>=0?1:-1);
	}

}

class Gun{
	
	Hydrogen H; Nucleus enemy; Behavior utils;
	static Gun wave; static double PI;

	Gun(Hydrogen type1, Nucleus type2, Behavior type3){
		H = type1; enemy = type2; utils = type3;
		//stateNameArray = new String[]{"a","b","c","d","e"};
	}
	Gun(){

	}
	
	List<Gun> _gunGroup = new ArrayList<Gun>();
	double[] dataPoint = new double[6];
	List<double[]> _dataGroup = new ArrayList<double[]>();
	HashMap<double[],Double> factorMap = new HashMap<double[],Double>();
	//List<double> factorsAtPoint = new ArrayList<double>();

	StringBuilder stateBuilder;
	String state;
	
	double bSpeed, distance;
	double distTraveled, timeTillHit, doubleOffset;
	double shotTime, currentTime, lastOffset, maxTime;//maxTime = utils.GreatestDistance()/11d;
	double timeSinceShot, absBearing, maxEscapeAngle;
	Point2D.Double shotLocation;

	static{
		//stateMap = new HashMap<String,double[]>();
		//offsetMap = new HashMap<String,List<Double>>();
		PI = Math.PI;
	}
	
	public void paint(Graphics2D g){
		g.setColor(Color.green);
		g.drawOval(new Double(H.getX() - 25).intValue(), new Double(H.getY() - 25).intValue(), 50, 50);
		double radius = 0;

		for(Gun toPaint: _gunGroup){
			radius = toPaint.distTraveled + toPaint.bSpeed;
			
			g.drawOval(new Double(toPaint.shotLocation.getX() - (radius)).intValue(),
				new Double(toPaint.shotLocation.getY() - (radius)).intValue(),
					new Double(radius*2).intValue(), new Double(radius*2).intValue());
		}
	}
	
	public void update(){
		
		if(H.shotsFired>0)
		H.accuracy = (double)H.shotsHit/(double)H.shotsFired;
		else
		H.accuracy = 0d;

		if(!H.isTC){
			setSegmentation();
			
			advanceGunWaves();
			
			checkSpawnGunWave();
			if(H.getEnergy()>0){	
				H.setTurnGunRightRadians(Utils.normalRelativeAngle(getIdealBearing()-
					H.getGunHeadingRadians()));
			}
		}
		
	//	_dataGroup = new ArrayList<double[]>(factorMap.keySet());
	}

	public void setSegmentation(){
	
		maxTime = utils.GreatestDistance()/8d;
		
		double accel = .5d;
		if(enemy.lastLateralVelocity<enemy.lateralVelocity){ accel = 0d; }
		else if(enemy.lastLateralVelocity>enemy.lateralVelocity){ accel = 1d; }
		
		dataPoint = new double[10];
		dataPoint[0] = Math.abs(enemy.lateralVelocity)/8d;
		dataPoint[1] = H.bPower/3d;
		dataPoint[2] = utils.limit(0d,Math.abs(enemy.lateralHeading/(PI/4)),1d);
		dataPoint[3] = enemy.distance/utils.GreatestDistance();
		dataPoint[4] = Math.abs(enemy.lastLateralVelocity)/8d;
		//dataPoint[5] = .5d*enemy.lateralDirection + .5d;
		//dataPoint[5] = accel;
	//	dataPoint[6] = .5d*lastOffset + .5d;
	//	dataPoint[7] = .5d*doubleOffset + .5d;
	//	dataPoint[8] = utils.limit(0,enemy.timeSinceReverse,maxTime)/maxTime;
		//dataPoint[3] = enemy.energy/100;
		
	/*	if(H.getEnergy()>H.bPower){
			_dataGroup.add(dataPoint);
		} 
		if(_dataGroup.size()>5000) _dataGroup.remove(H.duck.nextInt(_dataGroup.size()));*/
	}
	
	List<double[]> getSimilarPoints(double[] toAnalyze, int numNeighbors){
		List<double[]> _similarPoints = new ArrayList<double[]>(numNeighbors);
		boolean cont = false;
		if(numNeighbors>0) cont = true;
		if(cont){
		for(int i = 0; i < numNeighbors; i ++){
			_similarPoints.add(_hitList.get(i));
		}
		double[] nearestDistSq = new double[numNeighbors];
		nearestDistSq[0] = distanceSquared(toAnalyze,_similarPoints.get(0));
		double longestDistSq = nearestDistSq[0];
		//H.out.println("Dist: " + nearestDistSq[0]);
		int longestIndex = 0;
		
		for(int y = 1; y < numNeighbors; y ++){
			nearestDistSq[y] = distanceSquared(toAnalyze,_similarPoints.get(y));
			if(nearestDistSq[y]>longestDistSq){
				longestDistSq = nearestDistSq[y];
				longestIndex = y;
			}
		}
			double distSq, dist = 0, tempDist = 0;
			for(int x = numNeighbors; x < _hitList.size(); x ++){
				distSq = distanceSquared(toAnalyze,_hitList.get(x));
				if(distSq < longestDistSq){
					//_similarPoints.remove(longestIndex);
					_similarPoints.set(longestIndex,_hitList.get(x));
					nearestDistSq[longestIndex] = distSq;
					tempDist = 0;
					for(int i = 0; i < nearestDistSq.length; i ++){
						dist = nearestDistSq[i];
						if(dist>tempDist){
							tempDist = dist;
							longestDistSq = dist;
							longestIndex = i;
						}	
					}
				}
			} 
		//}
		return _similarPoints;
		}
		/*_similarPoints.add(toAnalyze);*/ return _similarPoints;
	}
	
	public double distanceSquared(double[] state1, double[] state2){
		double distance = 0;
		for(int i = 0; i < state1.length; i ++){
			distance += sqr(state1[i]-state2[i]);
		}
		//H.out.println(state1[0] + " " + state2[0]);
		return distance;
	}
	
	public double sqr(double x){
		return (x*x);
	}

	double latDir; boolean fireToDeath = false; long fireTime = 0;
	//Point2D.Double ourNextPos, enemyNextPos;
	
	public void checkSpawnGunWave(){
		if(H.isMC) fireToDeath = true;
		/*if(H.getGunTurnRemainingRadians()==0&&H.getGunHeat()==0&&(H.getEnergy()>H.bPower|fireToDeath)&H.getEnergy()>0){
			fire();
			fireTime = H.getTime() + 1;
		}*/
		if(H.getGunTurnRemainingRadians()==0&&H.getGunHeat()==0&&(H.getEnergy()>H.bPower|fireToDeath)&H.getEnergy()>0){
			Gun gW = new Gun();
			
			Point2D.Double ourNextSpot = H.position;//utils.project(H.position,H.velocity,H.heading);
			Point2D.Double theirNextSpot = enemy.position;//utils.project(enemy.position,enemy.velocity,enemy.heading);

			gW.bSpeed = utils.bSpeed(H.bPower);
			gW.distance = theirNextSpot.distance(ourNextSpot);
			gW.distTraveled = 0;
			gW.timeTillHit = distance/bSpeed;
			gW.shotTime = (double)H.getTime()+1;
			gW.currentTime = shotTime;
			gW.timeSinceShot = 0;
			gW.shotLocation = ourNextSpot;//H.position;
			//gW.state = stateBuilder.toString();
			gW.absBearing = utils.absBearing(H.position,enemy.position);//enemy.absBearing;
			gW.maxEscapeAngle = Utils.normalRelativeAngle(utils.maxEscapeAngle(gW.bSpeed)) * enemy.lateralDirection;
			gW.latDir = enemy.lateralDirection;
			gW.dataPoint = dataPoint;
			
			//_dataGroup.add(gW.dataPoint);
			_gunGroup.add(gW);
			
			shotTimer = H.getTime();
			
			H.shotsFired ++;
			//llD = lD;
			
			fire();
		}
	}
	
	public void fire(){
		H.setFire(H.bPower);
	}

	public void advanceGunWaves(){
		for(int i = 0; i < _gunGroup.size(); i ++){
			
			wave = _gunGroup.get(i);
			
			try{
				wave.timeSinceShot = H.getTime() - wave.shotTime;
				wave.distTraveled = wave.bSpeed * wave.timeSinceShot;
				wave.distance = enemy.position.distance(wave.shotLocation);
				
							
				i = checkWave(wave, i);
			}
			catch(NullPointerException e){}
			
		}
	}
	
	public int checkWave(Gun wave, int index){
		if(wave.distTraveled>wave.distance){
			storeOffset(wave);
			_gunGroup.remove(index);
			index --;
		}
		return index;
	}
	
	static List<double[]> _hitList = new ArrayList<double[]>();
	
	public void storeOffset(Gun wave){
		
		double offset = utils.getOffset(wave.shotLocation, enemy.position, wave);
		//factorsAtPoint = new ArrayList<double>;
		
		//if(factorMap.containsKey(wave.dataPoint)){
		//	factorsAtPoint = factorMap.get(wave.dataPoint);
		//}
	//	factorsAtPoint.add(offset);
		//H.out.println("storing: " + wave.dataPoint[0]);
		factorMap.put(wave.dataPoint, offset);
		doubleOffset = lastOffset;
		lastOffset = offset;
		_hitList.add(wave.dataPoint);
		if(_hitList.size()>5000){
			_hitList.remove(0);
		}
		//_dataGroup.add(wave.dataPoint);
		//_dataGroup = new ArrayList<double[]>(factorMap.keySet());
	}
	
	public double firingOffset(double[] data){
		if(factorMap.containsKey(data))
			return factorMap.get(data);
		//else
		//	H.out.println("No Info for this situation");
		double offset = 0;
		double minimumDist = 100000, tempDist;		

		for(double[] o7:factorMap.keySet()){
			tempDist = distanceSquared(data,o7);
			if(tempDist < minimumDist){
				minimumDist = tempDist;
				offset = factorMap.get(o7);
			}
		}
	//	H.out.println(offset);
		return offset;
	}

	
	long shotTimer = 0;
	double heaviestOffset = 1d, deltaTheta = 0d, botWidth = 0d, density = 0d;
	double maxDensity; static List<double[]> _neighbors = new ArrayList<double[]>();
	
	public double getIdealBearing(){
		
		if(_dataGroup.size()>0){

		_neighbors = getSimilarPoints(dataPoint, Math.min(37,_hitList.size())-1);
	
		density = 0; botWidth = Math.abs(36d/enemy.distance);
		maxDensity = 0;
		double ratio = 0, firingAngleA, firingAngleB, bestAngle = enemy.absBearing;
		double[] dataPointA = new double[10];// double[] dataPointB = new double[10];
		double dist = 1;
		
		for(int i = 0; i < _neighbors.size(); i ++){
			density = 0;
			dataPointA = _neighbors.get(i);
			firingAngleA = getAngleForOffset(firingOffset(dataPointA));
			
		//	for(int x = 0; x < _neighbors.size(); x ++){
			for(double[] dataPointB : _neighbors){
				//dataPointB = _neighbors.get(x);
				dist = distanceSquared(dataPointA,dataPointB);
				if(!dataPointA.equals(dataPointB)){
					firingAngleB = getAngleForOffset(firingOffset(dataPointB));
					ratio = (firingAngleA-firingAngleB)/botWidth;
					
					if(Math.abs(ratio)<=1){
						//density += Math.pow(Math.E,(-.5d*sqr(ratio)));//dist;
						//density += 1d/dist;
						density ++;
					}
				}
			}
			if(density>maxDensity){
				maxDensity = density;
				bestAngle = firingAngleA;
			}
			//}
		}
	//	double bestAngle = getAngleForOffset(firingOffset(dataPoint));
		return bestAngle;
		}
		else return getAngleForOffset(firingOffset(dataPoint));
		/*for(double t=-1+2d/94d; t < 1d; t += 2d/47d){
			for(double o7:_aimFactors){
				newBearing = getAngleForOffset(t);
				deltaTheta = Math.abs(Utils.normalRelativeAngle(
					newBearing-getAngleForOffset(o7)));
				ratio = Math.abs(deltaTheta/botWidth);
				if(ratio<1) density+=Math.pow(Math.E,-2d/47d*ratio*ratio);
			}
			if(density>=maxDensity){
				maxDensity = density;
				heaviestOffset = t;
			}

			density = 0;
		}

		if(offsetFound)
		heaviestOffset = utils.limit(-1,runningAverage/numberMatches,1);*/

	//return Utils.normalAbsoluteAngle(enemy.absBearing
		//	 + utils.maxEscapeAngle()*enemy.lateralDirection*heaviestOffset);

	}
	
	public double getAngleForOffset(double offset){
		return Utils.normalRelativeAngle(enemy.absBearing + utils.maxEscapeAngle()*offset
			*enemy.lateralDirection);
	}

}

class Movement{
	
	Hydrogen H; Nucleus enemy; Behavior utils;
	static final double PI, maxOffset;
	static StringBuilder stateBuilder = new StringBuilder("");
//	static HashMap<String,List<Double>> stateMap = new HashMap<String,List<Double>>();
	static HashMap<double[],Double> factorMap = new HashMap<double[],Double>();
	static List<Movement> _surfGroup = new ArrayList<Movement>();
	static List<Double> _offsetList = new ArrayList<Double>();

	Movement(Hydrogen type1, Nucleus type2, Behavior type3){
		H = type1; enemy = type2; utils = type3;
		lastLatDir = 1; latDir = 1;
	}
	
	Movement(){}
	
	double lastHealth, healthDelta, lastShotPower;
	double deltaHeading, lastHeading;//, botWidth;
	
	public void update(){
		setSegmentation();
		angleFromEnemy = utils.absBearing(enemy.position,H.position);
		enemy.accuracy = enemy.shotsHit/enemy.shotsFired;
		//botWidth = (36/enemy.distance);
		if(H.velocity!=0) {
			latDir = (int)utils.sign(H.velocity)*(int)utils.sign(enemy.bearing); }
		else{ latDir = lastLatDir; }
		if(enemy.accuracy!=0d)
		flattenFactor = H.accuracy/enemy.accuracy;
		if(!H.isMC){
			advanceWaves();
			drive();
		}
		healthDelta = lastHealth-enemy.energy;
		if(healthDelta>0&&healthDelta<=3){
			createWave(healthDelta);
			lastShotPower = healthDelta;
		}
		lastHealth = enemy.energy;
		lastLatDir = latDir;
		deltaHeading = Utils.normalRelativeAngle(H.heading - lastHeading);
		lastHeading = H.heading;
		
		//_dataGroup.add(dataPoint);
	}
	
	double latHeading;

	public void setSegmentation(){
		
		latHeading = Utils.normalRelativeAngle(utils.absAngle(enemy.position,H.position)-H.heading);
		
		dataPoint = new double[6];
		dataPoint[0] = Math.abs(H.velocity)/8;
		dataPoint[1] = lastShotPower/3;
		dataPoint[2] = utils.limit(0d,Math.abs(deltaHeading/(PI/10)),1d);
		dataPoint[3] = utils.limit(0d,Math.abs(latHeading/PI),1d);
		dataPoint[4] = enemy.distance/utils.GreatestDistance();
		
		
		//_dataGroup.add(dataPoint);
		//_dataGroup = new ArrayList<double[]>(factorMap.keySet());
		
	//	if(_dataGroup.size()>10000) _dataGroup.remove(0);
		
	//	H.out.println(getGuessFactorForData(dataPoint));
	}
	
	double angleFromEnemy, offset, shotTime;
	int latDir, lastLatDir; double distTraveled;
	double bPower, bSpeed, maxEscapeAngle;
	Point2D.Double shotLocation; String state;
	double[] dataPoint = new double[5];
	static List<double[]> _dataGroup = new ArrayList<double[]>();
	static List<double[]> _neighborGroup = new ArrayList<double[]>();
	
	public void createWave(double eDrop){
		//5600 score 75 12
		Movement wave = new Movement();
		wave.angleFromEnemy = utils.absAngle(enemy.position,H.position);
		wave.offset = 0;
		wave.shotTime = H.getTime();
		wave.distTraveled = 0;
		wave.bPower = eDrop;
		wave.bSpeed = utils.bSpeed(wave.bPower);
		wave.shotLocation = enemy.position;
		wave.latDir = latDir;
		wave.maxEscapeAngle = Utils.normalRelativeAngle(utils.maxEscapeAngle(wave.bSpeed))*wave.latDir;
		wave.botWidth = botWidth;
		wave.dataPoint = dataPoint;
		
		enemy.shotsFired ++;
		
		_surfGroup.add(wave);
		
		//H.out.println("surfing: " + getGuessFactorForData(wave.dataPoint));
	}
	
	List<double[]> getSimilarPoints(double[] toAnalyze, int numNeighbors){
		boolean cont = false;
		List<double[]> _similarPoints = new ArrayList<double[]>(Math.max(1,numNeighbors));// = new ArrayList<double[]>(factorMap.keySet());
		_similarPoints.add(toAnalyze);
		if(numNeighbors>0) cont = true;
		if(cont){
			//_similarPoints = new ArrayList<double[]>(numNeighbors);
		for(int i = 0; i < numNeighbors; i ++){
			_similarPoints.add(i,_dataGroup.get(i));
		}
		double[] nearestDistSq = new double[numNeighbors];
		nearestDistSq[0] = distanceSquared(toAnalyze,_similarPoints.get(0));
		double longestDistSq = nearestDistSq[0];
		//H.out.println("Dist: " + nearestDistSq[0]);
		int longestIndex = 0;
		
		for(int y = 1; y < numNeighbors; y ++){
			nearestDistSq[y] = distanceSquared(toAnalyze,_similarPoints.get(y));
			//H.out.println("NeighNum: " + y + " dist: " + nearestDistSq[y]);
			if(nearestDistSq[y]>longestDistSq){
				longestDistSq = nearestDistSq[y];
				longestIndex = y;
			} }
			double distSq, dist = 0, tempDist = 0;
			for(int x = numNeighbors; x < _dataGroup.size(); x ++){
				distSq = distanceSquared(toAnalyze,_dataGroup.get(x));
				if(distSq < longestDistSq){
					//_similarPoints.remove(longestIndex);
					_similarPoints.set(longestIndex,_dataGroup.get(x));
					nearestDistSq[longestIndex] = distSq;
					//H.out.println("replacing: " + longestIndex + " dist: " + longestDistSq);
					tempDist = 0;
					for(int i = 0; i < nearestDistSq.length; i ++){
						dist = nearestDistSq[i];
						if(dist>tempDist){
							tempDist = dist;
							longestDistSq = dist;
							longestIndex = i;
						}	
					}
				}
			}
		//}
		return _similarPoints;
		}

		return _similarPoints;
	}
	
	public double distanceSquared(double[] group1, double[] group2){
		double dist = 0;
		for(int i = 0; i < group1.length; i++){
			dist += sqr(group1[i]-group2[i]);
		}
		return dist;
	}
	
	public double sqr(double x){
		return (x*x);
	}

	Movement advWave;
	
	void advanceWaves(){
		for(int i = 0; i < _surfGroup.size(); i ++){
			advWave = _surfGroup.get(i);
			advWave.distTraveled = (H.getTime()-advWave.shotTime)*advWave.bSpeed;
			if(advWave.distTraveled >= H.position.distance(advWave.shotLocation)){
				_surfGroup.remove(i);
				i--;
			}
		}
	}
	
	double desiredAngle, distanceToSpot, lastVelocity;
	List<Point2D.Double> _spotChoices = new ArrayList<Point2D.Double>();
	Point2D.Double desiredSpot = new Point2D.Double();
	double velocity, heading, danger, itterations;
	double timeTillHit, distConsidered; boolean interrupted;
	double turnAmount, predictedHeading, maxTurn; int goDirection;
	int enemySide, predictedDir, lastDir = 1, goDir = 1;
	int vSign = 1, lvSign = 1;
	int[] directions = new int[]{-1,1};
	Point2D.Double emptySurfSpot = new Point2D.Double();
	double velocityFraction = 1d;
	Point2D.Double tempSpot = new Point2D.Double();
	boolean neighborsSet = false; Movement lastWave;
	long timesSet = 0;
	
	void drive(){
		Movement wave = getClosestSurfableWave();
		if(wave.shotLocation!=null){
			if(!wave.equals(lastWave)||!neighborsSet){
				_neighborGroup = new ArrayList<double[]>();
				//_neighborGroup.add(wave.dataPoint);
				timesSet ++;
				_neighborGroup = getSimilarPoints(wave.dataPoint, Math.min(20,_dataGroup.size())-1);
				//H.out.println("setting neighBors: " + timesSet);
				lastWave = wave; neighborsSet = true;
			}
			desiredSpot = getDesiredSpot(wave,H.position);
			turnAmount = utils.absAngle(H.position,desiredSpot)-H.heading;
			turnAmount = Utils.normalRelativeAngle(turnAmount);
			distanceToSpot = desiredSpot.distance(H.position);
			if(turnAmount>PI/2||turnAmount<-PI/2){
				goDir = -1;
				turnAmount *= -1;
			}
			else { goDir = 1; }
			H.setTurnRightRadians(turnAmount*Math.signum(distanceToSpot));
			H.setAhead(distanceToSpot*goDir);
		}
		else{
			desiredAngle = Utils.normalAbsoluteAngle(utils.absAngle(enemy.position,H.position)+PI/2);
			H.setTurnRightRadians(getTurnAmount(H.position,desiredAngle,H.heading,latDir));
			emptySurfSpot = utils.project(H.position,120d*latDir,H.heading);
			if(!H.playField.contains(emptySurfSpot)&
				H.position.distance(enemy.position)>emptySurfSpot.distance(enemy.position)){
					goDir*=-1;
			}
			H.setAhead(100*goDir);
			H.setMaxVelocity(PI/H.getTurnRemainingRadians());
		}
	}
	Point2D.Double getDesiredSpot(Movement wave, Point2D.Double spot){
		if(Math.abs(H.velocity)<=1){//||flatten){
		_spotChoices.add(spot);
		}
		directions = new int[]{-1*wave.latDir,wave.latDir};
		for(int dir:directions){
			spot = H.position;
			predictedHeading = H.heading;
			velocity = H.velocity;
			vSign = vSign(velocity, lvSign);
			lvSign = vSign;
			itterations = 0;
			interrupted = false;
			enemySide = (int)utils.sign(enemy.bearing);
			desiredAngle = Utils.normalAbsoluteAngle(utils.absAngle(wave.shotLocation,spot)+PI/2);
			while(!interrupted){
				velocity += (velocity*dir<0?2*dir:dir);
				velocity = utils.limit(-8,velocity,8);
				/*if(Math.abs(velocity)>=1)
				itterations += Math.abs(velocityFraction/velocity);
				else */itterations ++;
				vSign = vSign(velocity, lvSign);
				enemySide = (int)utils.sign(Utils.normalRelativeAngle(predictedHeading-utils.absAngle(spot,wave.shotLocation)));
				desiredAngle = Utils.normalAbsoluteAngle(utils.absAngle(wave.shotLocation,spot)+PI/2);
				turnAmount = getTurnAmount(spot,desiredAngle,predictedHeading,vSign);
				maxTurn = Math.PI/720d*(40d - 3d*Math.abs(velocity));
				turnAmount = utils.limit(-maxTurn,turnAmount,maxTurn);
				predictedHeading = Utils.normalAbsoluteAngle(predictedHeading+turnAmount);
			/*	for(double i = 0; i <= Math.abs(velocity); i += 1){
 					tempSpot = utils.project(spot,velocityFraction*vSign*i,predictedHeading);
					_spotChoices.add(tempSpot);
				}*/
				spot = utils.project(spot,velocity,predictedHeading);
				_spotChoices.add(spot);
				lvSign = vSign;
				if(wave.shotLocation.distance(spot)<(wave.distTraveled+wave.bSpeed*(itterations+1))){
					interrupted = true;
				}
			}
		}
		double danger = Double.POSITIVE_INFINITY, testDanger;
		for(Point2D.Double testSpot:_spotChoices){
			testDanger = getDanger(testSpot,wave);
			if(testDanger<danger){
				danger = testDanger;
				spot = testSpot;
			}
		}
		//H.out.println("Surfing: " + getDanger(spot,wave));
		_spotChoices.clear();
		return spot;
	}
	int vSign(double v, int s){
		if(v==0) return s;
		return (int)utils.sign(v);
	}
	double getTurnAmount(Point2D.Double startSpot, double angle, double heading, int dir){
		angle-=PI/13d*(double)dir;
		int i = 0; double toTurn = Utils.normalRelativeAngle(angle-heading);
		while(!H.playField.contains(utils.project(startSpot,120*dir,heading+toTurn))&&i<160){
			toTurn+=.01*dir; i++;
		}
		return Utils.normalRelativeAngle(toTurn);
	}

	double angleToPos = 0, deltaTheta = 0, botWidth = 36, density, ratio;
	double dist = 0; boolean flatten = true; double flattenFactor = 1;
	
	double getDanger(Point2D.Double position, Movement wave){
		density = 0;
		resultOffset = utils.getOffset(wave.shotLocation, position, wave);
		//bin = getBinForOffset(resultOffset);
		botWidth = (36d/position.distance(wave.shotLocation));
		angleToPos = getAngleForOffset(resultOffset, wave);
		double limit = Double.POSITIVE_INFINITY;
		//flattenFactor = Math.max(.01,flattenFactor);
		if(flatten){
			limit = 2d*flattenFactor;
		}
		limit = 1;
		limit = utils.limit(1,limit,Double.POSITIVE_INFINITY);
		for(double[] dataPointA:_neighborGroup){
		//	if((dataPointA[0]!=0&&dataPointA[1]!=0&&0!=dataPointA[2]&&0!=dataPoint[3])){
			dist = distanceSquared(dataPointA,wave.dataPoint);
			double firingAngleA = getAngleForOffset(getGuessFactorForData(dataPointA), wave);
		//	if(firingAngleA!=lastAngle){
				ratio = /*Utils.normalRelativeAngle*/(firingAngleA-angleToPos)/botWidth;
			//	H.out.println(density + " density and ratio: " + ratio);
			//	if(dist==0) dist = 1d;
			if(Math.abs(ratio)<=limit){
				density += Math.pow(Math.E,-.5d*sqr(ratio));//dist;// + density/position.distance(H.position);
				//density ++;
				//density /= position.distance(H.position);
				//density += 1d/dist;
				//density ++;
				//lastAngle = firingAngleA;
			}
		} //}
	/*	for(double o7:_offsetList){
			deltaTheta = Utils.normalRelativeAngle(angleToPos-getAngleForOffset(o7, wave));
			ratio = Math.abs(deltaTheta/botWidth);
		//	if(ratio<=1){
				//density += e^(-0.5 * (ux^2))
			density += Math.pow(Math.E,-0.5*ratio*ratio);
			//density ++;
			//}
		}*/
		density /= position.distance(enemy.position);
		//return bins[bin]/position.distance(wave.shotLocation);
		return density;
	}
	double getAngleForOffset(double o, Movement wave){
		return Utils.normalRelativeAngle((o*wave.maxEscapeAngle)+wave.angleFromEnemy);
	}
	
	double getGuessFactorForData(double[] data){
		if(factorMap.containsKey(data))
			return factorMap.get(data);
		//else
		//	H.out.println("No Info for this situation");
		double offset = 0;
		double minimumDist = 10000, tempDist;		

		for(double[] o7:factorMap.keySet()){
			tempDist = distanceSquared(data,o7);
			if(tempDist < minimumDist){
				minimumDist = tempDist;
				offset = factorMap.get(o7);
			}
		}
		//H.out.println("surfing: " + offset);
		return offset;
	}
	
	double resultOffset, distDelta, timeDelta, lastTime, lastDist;
	//int bin; double[] bins = new double[61], storeBins;

	public void onHit(Bullet e){
		Point2D.Double hitPos = new Point2D.Double(e.getX(),e.getY());
		Movement wave = getClosestSurfWave(hitPos);
		neighborsSet = false;
		enemy.shotsHit ++;
		if(wave.shotLocation!=null){
			resultOffset = utils.getOffset(wave.shotLocation, hitPos, wave);
			storeOffset(resultOffset,wave);
			//_dataGroup.add(wave.dataPoint);
		}
		else H.out.println("Sorry Sir, Dropped A Wave");
	}
	Movement getClosestSurfWave(Point2D.Double hitPos){
		Movement closeWave = new Movement();
		lastDist = utils.GreatestDistance();
		for(Movement wave:_surfGroup){
			distDelta = Math.abs(wave.shotLocation.distance(hitPos)-wave.distTraveled);
			if(distDelta<lastDist){
				lastDist = distDelta;
				closeWave = wave;
			}
		}
		return closeWave;
	}
	Movement getClosestSurfableWave(){
		lastDist = utils.GreatestDistance(); lastTime = lastDist/3d;
		Movement closeWave = new Movement();
		for(Movement wave:_surfGroup){
			distDelta = Math.abs(wave.shotLocation.distance(H.position)-wave.distTraveled);
			timeDelta = distDelta/wave.bSpeed;
			if(timeDelta<lastTime&&distDelta>wave.bSpeed){
				lastDist = distDelta; lastTime = timeDelta;
				closeWave = wave;
			}
		}
		return closeWave;
	}
	//StringBuilder toStore; double lastOffset = 0;
	void storeOffset(double o,Movement wave){
		//bin = getBinForOffset(o);
		/*lastOffset = o;
		toStore = new StringBuilder(storeState);
		List<Double> _storeList;
		do{
			_storeList = new ArrayList<Double>();
			if(stateMap.containsKey(toStore.toString())){
				_storeList = stateMap.get(toStore.toString());
			}
			_storeList.add(o);
			/*for(int i = 0; i < bins.length; i ++){
				storeBins[i] += 1/(Math.pow(i-bin,2)+1);
			}*/
			//stateMap.put(toStore.toString(),_storeList);
			factorMap.put(wave.dataPoint,o);
			_dataGroup.add(wave.dataPoint);
			if(_dataGroup.size()>500){
				_dataGroup.remove(0);
			}
			///H.out.println("storing: " + o);
			//System.out.println("stored: " + toStore + " size: " + _storeList.size());
		//	if(toStore.length()==0) break;
		//	toStore.deleteCharAt(toStore.length()-1);
		//}while(toStore.length()>=0);
	}
	
	int getBinForOffset(double o7){
		return (int)Math.round((o7*30+30));
	}
	
	double distSquared(double A, double B){
		return (A-B)*(A-B);
	}
	
	static{
		PI = Math.PI;
		maxOffset = Math.sqrt(2d);
	}
	

	public void paint(Graphics2D g){
		g.setColor(H.purple);
		g.drawOval(new Double(enemy.position.x - 25).intValue(), new Double(enemy.position.y - 25).intValue(), 50, 50);
		double radius = 0;

		for(Movement toPaint: _surfGroup){
			radius = toPaint.distTraveled + toPaint.bSpeed;
			
			g.drawOval(new Double(toPaint.shotLocation.getX() - (radius)).intValue(),
				new Double(toPaint.shotLocation.getY() - (radius)).intValue(),
					new Double(radius*2).intValue(), new Double(radius*2).intValue());
		}
	}

}


interface Types{
	
	
	public boolean types(Hydrogen H);


}