package dam.targetting;

import robocode.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;

import dam.MasterBot;
import dam.BasicTarget;
import dam.util.*;


public abstract class TargettingStrategy implements Serializable
{
	private GridPoint pt;
	protected BasicTarget target;
	protected transient MasterBot bot;
	protected boolean hold = false;
	private double gunOffset = 0;
	
	public TargettingStrategy(){}
	
	public void setBot(MasterBot val){ bot = val; }
	public void setTarget(BasicTarget t){ 
		target = t;
		setPoint(t.x, t.y);
	}
	
	
	/**
	* If you set hold to false, the gun will not fire.
	*/
	public void setHeld(boolean val){ hold = val; }
	public boolean isHeld(){ return hold; }
	
	
	public BasicTarget getTarget(){ return target; }
	
	public TargettingStrategy(MasterBot bot, BasicTarget t)
	{
		setTarget(t);
		setBot(bot);
		setPoint(t.x, t.y);
	}
	
	public abstract void guess(long gameTime);
	
	public double getX(){ return pt.x; }
	public double getY(){ return pt.y; }
	
	public void setPoint(GridPoint val){ pt = val; }
	public void setPoint(double x, double y){ pt = new GridPoint(x, y); }
	
	public GridPoint getPoint(){ return pt; }
	
	
	/**
	 * This won't actually fire the gun - it will just allow you to fire the
	 * gun with the power value returned. If the power value is 0 or less,
	 * then don't fire.
	 * @return the fire power to use.
	 */
	public double aim()
	{
		long time;
		long nextTime;
		double firePower = 600/(target.getDistance());
		if(target.getAccuracy() > 2.2) firePower = 3;
		if(target.getEnergy() < 12){ // only use enough force to kill
			firePower = (target.getEnergy() / 4) + 0.3;
		}
		if(firePower > 3) firePower = 3;
		if(bot.getEnergy() < 3){
			firePower = bot.getEnergy() - 0.1;
		}
		long timeNow = bot.getTime() - 1;
		for(int i = 0; i < 10; i++)
		{
			nextTime = (int) Math.round(bot.getDistance(getX(), getY()) / (20 - (3 * firePower)));
			time = timeNow + nextTime;
			guess(time);
		}
		double intendedGunHeading = BotMath.normaliseHeading(BotMath.absbearing(bot.getX(),bot.getY(), getX(), getY()));
		gunOffset = intendedGunHeading - bot.getGunHeadingRadians();
		gunOffset = BotMath.normaliseBearing(gunOffset);
		if(hold) return -1;
		
		if(fire(gunOffset)){
			return firePower;
		}
		return -1;
	}
	
	private boolean fire(double turnAngle)
	{
		if(target.getName().equals("NONAME")) return false;
		boolean retval = false;
		if(
			(getX() > 0) && (getX() < bot.getBattleFieldWidth()) 
			&& (getY() > 0) && (getY() < bot.getBattleFieldHeight()));
		{
			double threshold = Math.atan(18/target.getDistance());
			if(Math.abs(turnAngle) <= threshold ) retval = true;
		}
		return retval;
	}
	
	public double getGunOffset(){ return gunOffset; }
		

}