package tobe;

import tobe.platform.*;
import tobe.movement.*;
import tobe.guns.*;
import tobe.util.*;
import tobe.statistics.*;
import robocode.*;
import java.awt.Color;
import java.io.*;

/**
 * Fusion - a robot by Torbjrn Gannholm
 * @version 0.9
 */
public class Fusion extends AdvancedRobot  {
  public void run() {
    setColors(new Color(190, 150, 255), Color.black, Color.red);
    setAdjustGunForRobotTurn(true);
    setAdjustRadarForGunTurn(true);
    if ( cc == null ) {//first round
      cc = new CommandCentre(this);
	  loadMovementValues();
	  makeSpace();
    } else
      cc.reset();
    radarTarget = null;
    radarAngle = Math.toRadians(45);
    while ( getTime() < 5 && !cc.allOppsSeen() ) {
      //check things out
      setTurnRight(360);
      setAhead(0);
      setTurnGunRight(360);
      setTurnRadarRight(360);
      execute();
    }
	m = chooseMovement();
	movements[m].init(cc);
    while ( true ) {
      cc.tick();
      double x = getX();
      double y = getY();
      double time = getTime();
      if ( getOthers() == 0 )
        victory.go(cc);
      else {
        //move
        movements[m].go(cc);
        //fire
        TargetStatistics target = cc.getPreferredTarget();
        Aim a = null;
        if ( target != null ) {
		  movementFired[m] += target.firedBullet(getTime());
          g = -1;
          if(target.getEnergy() == 0) {
            a = mercy.aim(cc);
          } else {
            g = chooseGun(target);
            a = guns[g].aim(cc);
          }
          if ( a != null ) {
            double gunTurn = BearingVector.normalizeAngle(a.bearing - getGunHeadingRadians());
            setTurnGunRightRadians(gunTurn);
            if ( Math.abs(gunTurn) < a.tolerance ) {
              double v = 20 - 3 * a.power;
              java.util.Iterator i = cc.getTargetStatisticsIterator();
              while ( i.hasNext() ) {
                TargetStatistics t = (TargetStatistics)i.next();
                if ( t.isSeen() )
                  addCustomEvent(new EvasionCondition(this, t.getName(), t.getDistance(x,y) / v + time - t.getTime(), t.getTime(), t.getHeading(), t.getAverageVelocity(), t.getX(), t.getY()));
              }
              if(g >= 0) guns[g].reset();
              Bullet b = setFireBullet(a.power);
              //out.println("firing "+g);
              if ( b == null )
                fireShot = false;
              else {
                fireShot = true;
                if(g >= 0) {
					addCustomEvent(new GunControlCondition(b, g, target));
					target.gunDisabled[g] += (1.0+a.power/5.0)/getGunCoolingRate();
				}
                if(target.getEnergy() == 0) target.mercyGiven();
              }
            }
            else
              fireShot = false;
          //gun not in tolerance
          }
          else
            fireShot = false;
        //no aim
        }
        else
          fireShot = false;
        //no target
        radarControl(fireShot || getGunHeat() / getGunCoolingRate() > 10 || a == null);
        execute();
	  }
    }
  }

  TargetStatistics radarTarget;

  double radarAngle = Math.toRadians(45);

  private void radarControl(boolean mayUseGun) {
    if ( !(radarTarget != null && radarTarget.isSeen() && radarTarget.getTime() + 1 < getTime()) ) {
      radarTarget = cc.getPreferredScanTarget();
      if ( radarTarget == null || !radarTarget.isSeen() )
        radarAngle = Math.toRadians(45);
      else {
        double preferredBearing = radarTarget.getBearing(getX(), getY());
        radarAngle = BearingVector.normalizeAngle(preferredBearing - getRadarHeadingRadians());
        if ( radarAngle < 0 )
          radarAngle -= Math.toRadians(45);
        else
          radarAngle += Math.toRadians(45);
      }
    }
    setTurnRadarRightRadians(radarAngle);
    if ( mayUseGun ) {
      double radarGunAngle = 0;
      if ( radarAngle < 0 )
        radarGunAngle -= Math.toRadians(20);
      else
        radarGunAngle += Math.toRadians(20);
      setTurnGunRightRadians(radarGunAngle);
    }
  }

  /**
	 * onScannedRobot: What to do when you see another robot
	 */
  public void onScannedRobot(ScannedRobotEvent e) {
    cc.digestScan(e, fireShot);
  }

  public void onCustomEvent(CustomEvent e) {
    Condition c = e.getCondition();
    if ( c.getName().equals("EvasionCondition") ) {
      removeCustomEvent(c);
      cc.addEvasion((EvasionCondition)c);
    }
    else
      if ( c.getName().equals("GunControl") ) {
        removeCustomEvent(c);
        int g = ((GunControlCondition)c).gun;
        Bullet b = ((GunControlCondition)c).bullet;
		TargetStatistics target = ((GunControlCondition)c).target;
        //gunEfficiency[g] -= b.getPower();
        if ( target.getName().equals(b.getVictim()) ) {
          //I hit one! Add damage done and my energy bonus
          target.gunEfficiency[g] += 7 * b.getPower();
          if ( b.getPower() > 1 )
            target.gunEfficiency[g] += 2 * (b.getPower() - 1);
        }
      }
  }

  public void onRobotDeath(RobotDeathEvent e) {
    cc.robotDied(e.getName());
	saveGunValue(cc.getTargetStatistics(e.getName()));
  }

  public void onDeath(DeathEvent e) {
	saveGunValues();
	saveMovementValues();
    //cc.save();
  }

  public void onWin(WinEvent e) {
	//unnecessary saveGunValues();
	saveMovementValues();
    //cc.save();
  }

  public void onSkippedTurn(SkippedTurnEvent e) {
    out.println("Taking too long....");
  }

  public void onHitByBullet(HitByBulletEvent e) {
    movementDamage[m] += 4 * e.getPower();
    if ( e.getPower() > 1 )
      movementDamage[m] += 2 * e.getPower();
    m = chooseMovement();
    movements[m].init(cc);
  //out.println("moving "+m);
  }

  private class GunControlCondition extends Condition  {
    GunControlCondition(Bullet b, int g, TargetStatistics t) {
      super("GunControl");
      bullet = b;
      gun = g;
	  target = t;
    }

    public boolean test() {
      return !bullet.isActive();
    }

    public Bullet bullet;

    public int gun;

	public TargetStatistics target;
  }

  //TODO: all statics should probably be saved in a file, per target and/or situation
  //guns
  static Gun mercy = new MercyShot();

  static Gun time = new TimeLaser();

  static Gun micro = new MicroLaser();

  static Gun sniper = new Sniper();

  static Gun mirror = new HeatMirror();

  //this stuff should be different for each target
  //and for each type of situation
  static Gun[] guns = { sniper, micro, time, mirror };

  //static double[] gunEfficiency = new double[guns.length];
  //static double[] gunDisabled = new double[guns.length];

  int chooseGun(TargetStatistics target) {
	if(target.gunEfficiency == null) loadGunValues(target);
    double total = 0;
    for ( int i = 0; i < guns.length; i++) {
      total += (1+target.gunEfficiency[i])/(1+target.gunDisabled[i]);
    }
    double d = random.nextDouble() * total;
    for ( int i = 0; i < guns.length; i++) {
      d -= (1+target.gunEfficiency[i])/(1+target.gunDisabled[i]);
      if ( d < 0 )
        return i;
    }
    out.println("default gun");
    return 0;
  //just for safety's sake
  //perhaps I should have a null gun to use when firing does not pay?
  //but how do I then start firing again? Do I need to?
  }

  void loadGunValues(TargetStatistics target) {
			target.gunEfficiency = new double[guns.length];
			target.gunDisabled = new double[guns.length];
			try {
				ObjectInputStream is = new ObjectInputStream(new FileInputStream(getDataFile("guncontrol_"+target.getName()+".dat")));
				double[] temp = (double[]) is.readObject();
				for(int i = 0; i < temp.length && i < target.gunEfficiency.length; i++) {
					target.gunEfficiency[i] = temp[i];
					//out.println(temp[i]);
				}
				is.close();
			}
			catch (IOException e) {
				out.println(e);
			}
			catch (ClassNotFoundException e) {
				out.println(e);
			}
  }

  void saveGunValues() {
	java.util.Iterator t = cc.getTargetStatisticsIterator();
	while(t.hasNext()) {
		TargetStatistics target = (TargetStatistics) t.next();
		if(target.isSeen()) {
			saveGunValue(target);
		}
	}
  }

  void saveGunValue(TargetStatistics target) {
	if(target.gunEfficiency == null) return;
				for(int i = 0; i < target.gunEfficiency.length; i++) {
					target.gunEfficiency[i] /= (1+target.gunDisabled[i]/100);
					target.gunDisabled[i] = 0;
					//out.println(target.getName()+" "+target.gunEfficiency[i]);
				}
			try {
				ObjectOutputStream os = new ObjectOutputStream(
					new robocode.RobocodeFileOutputStream(getDataFile("guncontrol_"+target.getName()+".dat")));
				os.writeObject(target.gunEfficiency);
				os.close();
			}
			catch( IOException e ) {
				out.println(e);
			}
  }

  //movements
  static Movement victory = new Victory();

  static Movement antiShrapnel = new AntiShrapnel();

  static Movement fluid = new Fluid();

  static Movement secant = new Secant_w();

  static Movement leaf = new Leaf();

  //this stuff should be different for each target
  //and for each type of situation
  static Movement[] movements = { leaf , fluid, antiShrapnel, secant };

  static double[] movementFired = new double[movements.length];

  static double[] movementDamage = new double[movements.length];

  int chooseMovement() {
    double sum = 0;
    for ( int i = 0; i < movements.length; i++)
      sum += Math.max(0.1,movementDamage[i])/(1+movementFired[i]);
    double total = 0;
    for ( int i = 0; i < movements.length; i++)
      total += sum - Math.max(0.1,movementDamage[i])/(1+movementFired[i]);
    double d = random.nextDouble() * total;
    for ( int i = 0; i < movements.length; i++) {
      d -= sum - Math.max(0.1,movementDamage[i])/(1+movementFired[i]);
      if ( d < 0 )
        return i;
    }
    return 0;
  //just for safety's sake
  }

  void saveMovementValues() {
				for(int i = 0; i < movementDamage.length; i++) {
					movementDamage[i] /= (1+movementFired[i]/100);
					movementFired[i] = 0;
					//out.println(" damage: "+movementDamage[i]);
				}
			try {
				ObjectOutputStream os = new ObjectOutputStream(
					new robocode.RobocodeFileOutputStream(getDataFile("movementcontrol.dat")));
				os.writeObject(movementDamage);
				os.close();
			}
			catch( IOException e ) {
				out.println(e);
			}
  }

  void loadMovementValues() {
			try {
				ObjectInputStream is = new ObjectInputStream(new FileInputStream(getDataFile("movementcontrol.dat")));
				double[] temp = (double[]) is.readObject();
				for(int i = 0; i < temp.length && i < movementDamage.length; i++) {
					movementDamage[i] = temp[i];
				}
				is.close();
			}
			catch (IOException e) {
				out.println(e);
			}
			catch (ClassNotFoundException e) {
				out.println(e);
			}
  }

  void makeSpace() {
	long quota = getDataQuotaAvailable();
	if(quota < 1500) {
						File d = getDataDirectory();
						File[] files = d.listFiles();
						java.util.Arrays.sort(files, new java.util.Comparator() {
							public int compare(Object l, Object r) {
								return (int) (((File) l).lastModified() - ((File) r).lastModified());
							}
						});
						for(int i = 0; i < (1500.0-quota)/100.0; i++)
							files[i].delete();
	}
  }

  static CommandCentre cc;

  int m = 0;
  int g = -1;

  boolean fireShot = false;

  java.util.Random random = new java.util.Random();
}
