package kc.serpent.utils;
import robocode.util.Utils;
import java.awt.geom.*;

public class Wave {
	public Point2D source;
	public Point2D target;
	public long fireTime;
	public int active;
	public int clockDirection;
	public double speed;
	public double radius;
	public double distance;
	public double weight;
	
	public double getGF(Point2D.Double location) {
		double angleOffset = Utils.normalRelativeAngle(KUtils.absoluteBearing(source, location) - KUtils.absoluteBearing(source, target));
		return angleOffset / KUtils.maxEscapeAngle(speed) * clockDirection;
	}
	
	public void setRadius(long gameTime) {
		radius = (gameTime - fireTime) * speed;
	}
}
