package kvk.Utils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import kvk.ExtendedRobot;
import robocode.*;

/**
 *  BattleField : Stocke les infos courantes sur l'arne
 *
 * @author     Ssin.le.Terrible
 * @created    9 janvier 2004
 */
public final class BattleField {

	//{{{ *** Variables de BattleField
	private static  ExtendedRobot            myBot;

	private static  double                   width                    = 0.0;
	private static  double                   height                   = 0.0;
	private static  double                   centreX                  = 0.0;
	private static  double                   centreY                  = 0.0;
	private static  double                   robotSize                = 0.0;
	private static  double                   diagonale                = 0.0;

	private static  double                   minX                     = 0.0;
	private static  double                   minY                     = 0.0;
	private static  double                   maxX                     = 0.0;
	private static  double                   maxY                     = 0.0;

	// Limites de l'arne
	private static  Rectangle2D.Double       battlefield;
	private static  Rectangle2D.Double       smallBattleField;
	private static  RoundRectangle2D.Double  smallRoundedBattleField;

	// Points aux coins de l'arne
	private static  Point[]                  fields;
	private static  int                      posField                 = 0;
	private static  int                      countField               = 0;
	private static  long                     countNoTarget            = 0;

	private static  boolean                  OvO;

	//}}}

	/**
	 *Constructor for the BattleField object
	 *
	 * @param  er  Description of the Parameter
	 */
	public BattleField(ExtendedRobot er) {
		myBot = er;

		robotSize = Math.min((myBot.getWidth() / 2 - 2), (myBot.getHeight() / 2 - 2));
		//robotSize = Math.max((myBot.getWidth() / 2 ), (myBot.getHeight() / 2 ));

		width = myBot.getBattleFieldWidth();
		height = myBot.getBattleFieldHeight();
		diagonale = Point2D.distance(0.0, 0.0, width, height);
		centreX = width / 2;
		centreY = height / 2;

		minX = robotSize;
		minY = robotSize;
		maxX = width - robotSize;
		maxY = height - robotSize;

		// Limites de l'arne
		double  minDistanceToWall  = robotSize + 4d;
		battlefield = new Rectangle2D.Double(0d, 0d, width, height);
		smallBattleField = new Rectangle2D.Double(minDistanceToWall, minDistanceToWall, width - 2 * minDistanceToWall, height - 2 * minDistanceToWall);
		smallRoundedBattleField = new RoundRectangle2D.Double(minDistanceToWall, minDistanceToWall, width - 2 * minDistanceToWall, height - 2 * minDistanceToWall, 100d, 100d);

		countField = 0;
		countNoTarget = 0;
		fields = new Point[4];
		fields[0] = new Point(width / 6, height / 2);
		fields[1] = new Point(width / 2, height / 6 * 5);
		fields[2] = new Point(width / 6 * 5, height / 2);
		fields[3] = new Point(width / 2, height / 6);
		posField = 0;

	}

	// ***************************** METHODES D'ACCES ***************************** //
	public static double getWidth() {
		return width;
	}

	public static double getHeight() {
		return height;
	}

	public static double getDiagonale() {
		return diagonale;
	}

	public static double getCentreX() {
		return centreX;
	}

	public static double getCentreY() {
		return centreY;
	}

	public static double getMinX() {
		return minX;
	}

	public static double getMinY() {
		return minY;
	}

	public static double getMaxX() {
		return maxX;
	}

	public static double getMaxY() {
		return maxY;
	}

	public static double getRobotSize() {
		return robotSize;
	}

	public static Rectangle2D.Double getBattleField() {
		return battlefield;
	}

	public static Rectangle2D.Double getSmallBattleField() {
		return smallBattleField;
	}

	public static RoundRectangle2D.Double getSmallRoundedBattleField() {
		return smallRoundedBattleField;
	}

	// **************************************************************************** //

	/**
	 * Calcul la distance du mur le plus proche
	 *
	 * @param  x        Description of the Parameter
	 * @param  y        Description of the Parameter
	 * @param  heading  Description of the Parameter
	 * @return          Description of the Return Value
	 */
	public static double distanceToWall(double x, double y, double heading) {

		if (heading == 0d || heading == C._2PI) {
			return (maxY - y);
		}
		if (heading == C._PI2) {
			return (maxX - x);
		}
		if (heading == C._PI) {
			return (y - minY);
		}
		if (heading == C._3PI2) {
			return (x - minX);
		}

		x = (heading > 0d && heading < C._PI ? maxX - x : minX - x);
		y = (heading > C._PI2 && heading < C._3PI2 ? minY - y : maxY - y);
		x /= Math.sin(heading);
		y /= Math.cos(heading);
		return Math.min(x, y);
	}

	public static double distanceToWall(Point p, double heading) {
		return distanceToWall(p.getX(), p.getY(), heading);
	}

	public static double distanceToWall(double x, double y) {
		return Math.min(x - minX, Math.min(maxX - x, Math.min(y - minY, maxY - y)));
	}

	public static double distanceToWall(Point p) {
		return distanceToWall(p.getX(), p.getY());
	}
}

