package whind;
import robocode.*;
import java.util.Hashtable;
import robocode.util.Utils.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.Color;
import java.awt.geom.*;
import whind.EBullet;
import whind.WBullet;

/**
 * Dexterity - a robot by Greywhind
 */
public class Wisdom extends AdvancedRobot
{
	double prevVelocity;
	double currVelocity;
	Point2D.Double doublePrevPos;
	Point2D.Double prevPosition;
	Point2D.Double currPosition;
	double prevEnergy;
	double currEnergy;
	Rectangle2D.Double fieldRectangle;
	int timeSinceLastScan = 0;
	double absBearing;
	Vector allBullets = new Vector();
	Random gen = new Random();
	boolean nearwall = false;
	int direction = 1;
	String Tracking = "";
	double lastEnemyHeading;
	static int bulletsFired = 0;
	int roundFired = 0;
	int hits = 0;
	double absoluteBearing;
	double enemyX;
    double enemyY;
	double eGunHeat;
	int gotHit;
	int eRoundFired;
	double coolRate;
    int eDirection = 1;
	static Object[] allHitOffsets = new Object[14];
	Vector myBullets = new Vector();
	/**
	 * run: Dexterity's default behavior
	 */
	public void run() {
		coolRate = getGunCoolingRate();
		setAdjustGunForRobotTurn(true);
		setColors(Color.green,Color.blue,Color.green);
		fieldRectangle = new Rectangle2D.Double(0, 0, getBattleFieldWidth(), getBattleFieldHeight());
		
		for (int i = 0; i < 14; i++) {
			allHitOffsets[i] = new Vector();
		}
			
		while(true) {
			doScanner();
			
			if (eGunHeat > coolRate) {
				eGunHeat -= coolRate;
			} else {
				eGunHeat = 0;
			}
			
			if (eGunHeat < 2*coolRate && eRoundFired > 1 && eGunHeat >= coolRate) {
				//out.println("Cool gun.");
				if (direction == 1) {
					setBack(10);
				} else {
					setAhead(10);
				}
			}
			
			if (getX()<50 || getY()<50 || getX()>getBattleFieldWidth()-50 || getY()>getBattleFieldHeight()-50) {
    			if (nearwall == false) {
        			direction *= -1;
        			nearwall = true;
					//out.println("Near wall");
    			}
    			else {
       				//out.println("Still near wall");
    			}
			}
			else {
			    nearwall=false;
				if (gen.nextInt(10) == 1) {
					direction *= -1;
					//out.println("Changing direction randomly");
				}
			}
			
			if (allBullets.isEmpty() == false) {
				for (int i = 0; i < allBullets.size(); i++) {
					EBullet currBullet = (EBullet)allBullets.elementAt(i);
					double distRemaining = currBullet.update();
					if (Math.abs(distRemaining) < 200) {
						//out.println("Bullet close at " + distRemaining);
						//setTurnLeft(90 - normalRelativeAngle(absoluteBearing(currBullet.getStartCoords(), currBullet.getTargetCoords())));
						if (direction == 1) {
							setAhead(gen.nextInt(50) + 100);
						} else {
							setBack(gen.nextInt(50) + 100);
						}
					}
				}
			}

			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if (Tracking.equals("")) {
			Tracking = e.getName();
			out.println("Tracking " + Tracking);
		}
		if(e.getName().equals(Tracking)) {
			timeSinceLastScan = 0;
			absBearing = getHeadingRadians() + e.getBearingRadians();
			absoluteBearing = getHeadingRadians() + e.getBearingRadians();
			enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
        	enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);

			prevVelocity = currVelocity;
			currVelocity = e.getVelocity();
		
			doublePrevPos = prevPosition;
			prevPosition = currPosition;
			currPosition = new Point2D.Double(enemyX, enemyY);
		
			prevEnergy = currEnergy;
			currEnergy = e.getEnergy();
		
			//out.println("Pos: " + currPosition + " Vel: " + currVelocity + " Energy: " + currEnergy);
			if (doublePrevPos != null) {
				if (prevEnergy - currEnergy <= 3 && prevEnergy - currEnergy > 0) {
					//out.println("Enemy Fired.");
					eRoundFired++;
					eGunHeat = 1 + ((prevEnergy-currEnergy) / 5);
					allBullets.add(new EBullet(doublePrevPos.getX(), doublePrevPos.getY(), getX(), getY(), doublePrevPos.distance(new Point2D.Double(getX(), getY())), prevEnergy - currEnergy));
				}
			}
			setTurnLeft(90 - e.getBearing());
			double iHit = (double)hits/(double)roundFired;

		double power = Math.min(3, Math.max(.1, getEnergy()));
        //don't try to figure out the direction they're moving if they're not moving, just use the direction we had before
        if (e.getVelocity() != 0)
            if (Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity() < 0)
                 eDirection = -1;
            else
                 eDirection = 1;
		
		Vector segmentHitOffsets = (Vector)allHitOffsets[(int)e.getDistance()/100];
		//out.println(segmentHitOffsets.toString());
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		
		LaserBullet newBullet = new LaserBullet(getX(), getY(), headOnBearing, power, getTime(), eDirection, segmentHitOffsets);
		
		myBullets.add(newBullet);
		
		for (int i=0; i<myBullets.size(); i++) {
            LaserBullet currentWave = (LaserBullet)myBullets.get(i);

            if (currentWave.checkHit(enemyX, enemyY, getTime())) {
                myBullets.remove(currentWave);
                i--;
            }
        }

		
			if (e.getEnergy() > 0) {
				if (e.getDistance() > 100) {
					if (segmentHitOffsets.size() > 0) {
						if (getGunHeat() <= getGunCoolingRate()) {
							Double objFireAtOffset = (Double)segmentHitOffsets.get(gen.nextInt(segmentHitOffsets.size()));
							double fireAtOffset = objFireAtOffset.doubleValue();
							fireAtOffset *= eDirection;
							setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+fireAtOffset));
							out.println("Would fire at: " + fireAtOffset);
						}
					} else {
						fireLinear(e, absoluteBearing, enemyX, enemyY);
					}
				} else {
					setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
				}
			} else {
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
			}
			if (getGunHeat() <= getGunCoolingRate()) {
				setFire(power);
			}
		
			//}
		}
	}
	
	public void fireLinear(ScannedRobotEvent e, double absoluteBearing, double enemyX, double enemyY) {
				double bulletPower = Math.min(3.0,getEnergy());
                double myX = getX();
                double myY = getY();
                double enemyHeading = e.getHeadingRadians();
                double enemyVelocity = e.getVelocity();
                
                
                double deltaTime = 0;
                double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
                double predictedX = enemyX, predictedY = enemyY;
                while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){          
                        predictedX += Math.sin(enemyHeading) * enemyVelocity;   
                        predictedY += Math.cos(enemyHeading) * enemyVelocity;
                        if(     predictedX < 18.0 
                                || predictedY < 18.0
                                || predictedX > battleFieldWidth - 18.0
                                || predictedY > battleFieldHeight - 18.0){
                                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);     
                                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                                break;
                        }
                }
                double theta = robocode.util.Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
                setTurnRadarRightRadians(normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
                setTurnGunRightRadians(normalRelativeAngle(theta - getGunHeadingRadians()));
	}

	public void onBulletHit(BulletHitEvent event) {
		hits++;
	}
	
	public void onBulletMissed(BulletMissedEvent event) {
		
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent event) {
		
	}
	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		gotHit++;
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName().equals(Tracking)) {
			Tracking = "";
		}
	}
	
    private void goTo(Point2D point) {
		Point2D location = new Point2D.Double(getX(), getY());
        double distance = location.distance(point);
        double angle = normalRelativeAngle(absoluteBearing(location, point) - getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            if (angle > 0.0) {
                angle -= 180.0;
            }
            else {
                angle += 180.0;
            }
        }
        setTurnRight(angle);
        setAhead(distance);
    }

	private void translateInsideField(Point2D point, double margin) {
        double X = Math.max(margin, Math.min(fieldRectangle.getWidth() - margin, point.getX()));
        double Y = Math.max(margin, Math.min(fieldRectangle.getHeight() - margin, point.getY()));
        point.setLocation(X, Y);
    }

	private double absoluteBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    private double normalRelativeAngle(double angle) {
        double relativeAngle = angle % 360;
        if (relativeAngle <= -180)
            return 180 + (relativeAngle % 180);
        else if (relativeAngle > 180)
            return -180 + (relativeAngle % 180);
        else
            return relativeAngle;
    }

	public void doScanner() {
	    timeSinceLastScan++;
	    double radarOffset = Double.POSITIVE_INFINITY;
	    if(timeSinceLastScan < 3) {
	        radarOffset = robocode.util.Utils.normalRelativeAngle(getRadarHeadingRadians() - absBearing);
	        radarOffset += sign(radarOffset) * 0.02;
	    }
	    setTurnRadarLeftRadians(radarOffset);
	}

	int sign(double v) {
	    return v > 0 ? 1 : -1;
	}
	
	public void onHitWall(HitWallEvent e) {
		direction *= -1;
	}
	
	public void onWin(WinEvent evt) {
		out.println("Shots fired: " + roundFired);
		out.println("Shots hit: " + hits);
		double fireDec = (double)hits/(double)roundFired;
		out.println("Percentage hits: " + (fireDec * 100));
		//out.println("Hits overall - Linear: " + hitLinear + " Head On: " + hitHeadOn + " Circular: " + hitCircular);
		out.println("Enemy fired: " + eRoundFired + " times.");
		out.println("Hit by a bullet: " + gotHit + " times.");
		out.println("Dodged: " + (eRoundFired-gotHit) + " bullets.");
		double hitDec = (double)gotHit/(double)eRoundFired;
		out.println("I was hit " + (hitDec * 100) + " percent of the time.");
	}
	
	public void onDeath() {
		out.println("Shots fired: " + roundFired);
		out.println("Shots hit: " + hits);
		out.println("Percentage hits: " + ((hits/roundFired) * 100));
		//out.println("Hits overall - Linear: " + hitLinear + " Head On: " + hitHeadOn + " Circular: " + hitCircular);
		out.println("Enemy fired: " + eRoundFired + " times.");
		out.println("Hit by a bullet: " + gotHit + " times.");
		out.println("Dodged: " + (eRoundFired-gotHit) + " bullets.");
		out.println("I was hit " + ((gotHit/eRoundFired) * 100) + " percent of the time.");
	}
}