/******************************************************************************
 *  Robot:    TimmiT v0.21
 *  Author:   Liu Yang
 *  Create:   2003.03.30
 *  Tips:     Now. put your hands on your head..oOOo..oOOo.
 *..............................................................................
 *  v0.11 - 2003.01.13 - TimmiT v0.2 Write from v0.11.
 *  v0.20 - 2003.04.07 - Complete the v0.2, random moving and linear prediction.
 *  v0.21 - 2003.04.09 - Fix firepower energy.
 *  v0.22 - 2003.05.19 - Add fixlinear shoot method to match. anything fixed.
 ******************************************************************************/

package timmit;
import robocode.*;
import java.util.*;
import java.awt.Color;

public class TimmiT extends AdvancedRobot{
	private static final int INFO_LEN = 5000;
	private static Hashtable table = new Hashtable();
	private Enemy en = new Enemy(INFO_LEN);
	
	//------------------------------ run method ---------------------//
	public void run(){
		this.setColors(Color.green,Color.green,Color.white);
		this.setAdjustGunForRobotTurn(true);
		this.setAdjustRadarForGunTurn(true);
		this.setAdjustRadarForRobotTurn(true);
		Radar radar = new Radar(this);
		Move move = new Move(this);
		Gun gun = new Gun(this);
		while(true){
			radar.do_radar(en);
			move.do_move(en);
			gun.do_gun(en);
			en.increaseIndex();
			execute();
		}//end while
	}//end run.
	
	//-------------------------- scanned robot event ------------------//
	public void onScannedRobot(ScannedRobotEvent e){
		if(e.getDistance()<en.distance || e.getName().equals(en.name)){		//nearest enemy.
			if(table.containsKey(e.getName())){
				en = (Enemy)table.get(e.getName());
				en.update(e,this);
			}else{
				en = new Enemy(INFO_LEN);
				en.name = e.getName();
				table.put(e.getName(),en);
				en.update(e,this);
			}//end if
		}else{																//farest enemy.
			if(table.containsKey(e.getName())){
				Enemy enemy = (Enemy)table.get(e.getName());
				enemy.update(e,this);
			}else{
				Enemy enemy = new Enemy(INFO_LEN);
				enemy.name = e.getName();
				table.put(e.getName(),enemy);
				enemy.update(e,this);
			}//end if
		}//end
	}//end
		
	public void onBulletHit(BulletHitEvent e){
		if(table.containsKey(e.getName())){
			Enemy enemy = (Enemy)table.get(e.getName());
			double power = e.getBullet().getPower();
			double lostEnergy = power>1 ? power += 2 * (power - 1) : power;
			enemy.score[enemy.match] += lostEnergy;
		}//end
	}//end onbullethit
	
	public void onRobotDeath(RobotDeathEvent e){
		if(table.containsKey(e.getName())){
			Enemy deathEn = (Enemy)table.get(e.getName());
			deathEn.reset();
		}//end
	}//end
	
	//------------------------- win and death event ---------------------//
	public void onWin(WinEvent e){
		this.updateMath();
		Util.out("......Victory! I will use math["+en.match+"]",this);
		//new DataLog(this,table);
	}//end
	
	public void onDeath(DeathEvent e){
		this.updateMath();
		Util.out("......Oh,Shit! I will use math["+en.match+"]",this);
	}//end
	
	private void updateMath(){
		Util.out("Current match["+en.match+"] = "+en.score[en.match],this);
		Enumeration enemys = table.elements();
		if(getRoundNum()<=en.score.length*5){
			while(enemys.hasMoreElements()){
				Enemy enemy = (Enemy)enemys.nextElement();
				enemy.match = ++enemy.match % enemy.score.length;
			}//end while
		}else{
			while(enemys.hasMoreElements()){
				Enemy enemy = (Enemy)enemys.nextElement();
				double tmp = Math.max(enemy.score[0],Math.max(enemy.score[1],enemy.score[2]));
				if(tmp==enemy.score[0]){
					enemy.match = 0;
				}else if(tmp==enemy.score[1]){
					enemy.match = 1;
				}else if(tmp==enemy.score[2]){
					enemy.match = 2;
				}
			}//end while
		}//end if
		//new DataLog(this,table);
	}//end
}//end TimmiT.