package nat;

import java.util.Arrays;

import chase.s2.stat.*;
import chase.s2.stat.BinUpdater.*;

public class GunBuffer {
	public static final int GUN_BIN = 151;

	public static final float[] latvelSlicesRough = {2f, 2f, 4f, 6f };
	public static final float[] distSlicesRough = {0f, 24f, 48f };
	public static final float[] latvelSlices = {2f, .5f, 2.5f, 5.0f, 7.5f };
	public static final float[] distSlices = {0f, 14f, 28f, 42f, 56f };
	
	public static final float[] acclSlices = {4f, -0.4f, 0.4f};

	public static final float[] latvelSlices2 = {2f, .5f, 2.5f, 5.0f, 7.5f };
	public static final float[] fwallSlices = {9f, .2f, .4f, .6f, .8f, .11f };
	public static final float[] bwallSlices = {10f, .5f };
	public static final float[] tsvcSlices = {5f, .05f, .15f, .35f, .45f };
	public static final float[] dl7Slices = { 13f, 46.4282f, 103.5706f };

	public static final float[] latvelSlices2Rough = {2f, .5f, 2.5f, 6.75f };
	public static final float[] fwallSlicesRough = {9f, .25f, .45f, .65f};
	public static final float[] tsvcSlicesRough = {5f, .05f, .35f };
	public static final float[] dl7SlicesRough = { 13f, 93.5f };
	
	
	public static StatBufferSet getGunBuffer() {
		return new StatBufferSet(null) {{
			add(buffer(new float[][] { }, 5f), .0002f);
			add(buffer(new float[][] { }, 10000f), .0002f);
			add(buffer(new float[][] { latvelSlicesRough, distSlicesRough }, 5f), 50f);
			add(buffer(new float[][] { latvelSlices, distSlices }, 5f), 50f);
			add(buffer(new float[][] { latvelSlicesRough, distSlicesRough }, 2500f), 70f);
			add(buffer(new float[][] { latvelSlices, distSlices }, 2500f), 70f);
			add(buffer(new float[][] { latvelSlices2, distSlices, fwallSlices, bwallSlices, tsvcSlices, dl7Slices }, 5f), 100);
			add(buffer(new float[][] { latvelSlices2Rough, distSlicesRough, fwallSlicesRough, tsvcSlicesRough, dl7SlicesRough }, 5f), 100);
			add(buffer(new float[][] { latvelSlices2, distSlices, fwallSlices, bwallSlices, tsvcSlices, dl7Slices }, 10000f), 200);
			add(buffer(new float[][] { latvelSlices2Rough, distSlicesRough, fwallSlicesRough, tsvcSlicesRough, dl7SlicesRough }, 10000f), 200);
		}};
	}
	
	private static StatBuffer buffer(float[][] data, float rollingWeight) {
		SplitSet ss = new SplitSet();
		for (float[] d : data) {
			ss.add(Arrays.copyOfRange(d, 1, d.length), (int)Math.round(d[0]));
		}
		return new StatBuffer(ss, GUN_BIN, new RollingAverageUpdater(new DefaultUpdater(), rollingWeight));
	}
}
