package hamilton;

public class Coordinate 
{
	double x;
	double y;
	
	public Coordinate (double someX, double someY)
	{
		x = someX;
		y = someY;
	}
	
	public double getX()
	{
		return x;
	}
	
	public double getY()
	{
		return y;
	}
	
	public Coordinate add(Coordinate c)
	{
		double dX = x + c.getX();
		double dY = y + c.getY();
		
		if (dX == 0) dX = Double.MIN_VALUE;
		if (dY == 0) dY = Double.MIN_VALUE;
		
		return new Coordinate (dX, dY);		
	}
	
	public Coordinate subtract(Coordinate c)
	{
		double dX = x - c.getX();
		double dY = y - c.getY();
		
		if (dX == 0) dX = Double.MIN_VALUE;
		if (dY == 0) dY = Double.MIN_VALUE;
		
		return new Coordinate (dX, dY);
	}
	
	public Coordinate subtractFrom(Coordinate c)
	{
		double dX = c.getX() - x;
		double dY = c.getY() - y;
		
		if (dX == 0) dX = Double.MIN_VALUE;
		if (dY == 0) dY = Double.MIN_VALUE;
		
		return new Coordinate (dX, dY);			
	}
	
	public double distanceFrom(Coordinate c)
	{
		Coordinate delta = subtract(c);
		double dX = delta.getX();
		double dY = delta.getY();
		
		return Math.sqrt( (dX * dX) + (dY * dY) );
	}
	
	public double absoluteBearingTo(Coordinate c)
	{
		Coordinate delta = subtractFrom(c);
		double bearing = Math.atan(delta.getX() / delta.getY());
		if (delta.getY() < 0) bearing += Math.PI;

		return Calculator.normalizeAngle(bearing);	
	}
	
	public double absoluteBearingFrom(Coordinate c)
	{
		Coordinate delta = subtract(c);
		double bearing = Math.atan(delta.getX() / delta.getY());
		if (delta.getY() < 0) bearing += Math.PI;

		return Calculator.normalizeAngle(bearing);	
	}
	
	public Coordinate getCoordinates(double someAbsoluteBearing, double someDistance)
	{
		double dX = getX() + (Math.sin(someAbsoluteBearing) * someDistance);
		double dY = getY() + (Math.cos(someAbsoluteBearing) * someDistance);
		
		return new Coordinate (dX, dY);
	}
	
	public boolean isOnField(double width, double height)
	{
		return (x > 10 && x < width && y > 10 && y < height);
	}
}

