package tm;

import java.awt.*;
import java.awt.image.*;

/********************************************************************
* EnemyMoveAnalyzer3C.java -- G3C
*                            G̉ߋ̗C݂Ԃ̉ߋ̓ƁC
*                            }b`OD
*                            }b`O
*                            last 7 time, 500time, ͕⊮ŁCAԂ̗
*                            
* Date:		2002/Nov/16
*			2002/Dec/08
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
public class EnemyMoveAnalyzer3C {
	EnemyHistory3B ehis;
	double rotationRad;
	double fW, fH;
	final int TIME_W = 7;
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public EnemyMoveAnalyzer3C(EnemyHistory3B ehis, MyRobot my) {
		this.ehis = ehis;
		this.fW = my.fW;
		this.fH = my.fH;
	}
	
	//------------------------------------------------------------------
	// getPredictedEnemyPoint3() -- ߋ̗ t time ̓GʒuԂ
	//                             ݂̓Gʒu_Cis͏Ƃ
	//
	// F	bulletTIme -- CeB
	//			eneGoHeading -- current enemy go heading, gp
	//			absoluteBearing -- current absolute enemy bearingCgp
	//
	// ߂lF	݂̓Gʒu_ƂƂ́Ct̗\zʒu
	//------------------------------------------------------------------
	Point getPredictedEnemyPoint3(int bulletTime, double eneGoHeading, long currTime, double bulletVelocity, double eneX, double eneY, double myX, double myY) {
		int i, j;
		double dx, dy;
		double dx2, dy2;				//ړ̍W
		int TIME_W = this.TIME_W;
		double distance;
		
		int count = 0;
		Point[] poHis = new Point[TIME_W];			//G̉ߋ7turn̈ʒu
		long lastTime = currTime - TIME_W + 1;
		int idx = (ehis.size + ehis.endIndex - TIME_W + 1) % ehis.size;
		
		if (ehis.startIndex == 0 && ehis.endIndex - ehis.startIndex < TIME_W + bulletTime + 10) return null;			// TIME_W Ԃ񖳂
		
		distance = ehis.distance[ehis.endIndex];
		
//M.print("\n----- Analyze3C start!!");
//M.print("currTime = " + currTime);
//M.print("bulletTime = " + bulletTime);
//M.print("endIndex time[] = " + ehis.endIndex + " " + ehis.time[ehis.endIndex]);
//M.print("Curr distance = " + distance);

		//ߋ TIME_W Ԃ̓GʒupoHis[]Ɋi[
		for (i = 0; i < TIME_W; i++) {
			poHis[i] = new Point();
			poHis[i].x = ehis.po[idx].x;
			poHis[i].y = ehis.po[idx].y;
//M.print("i idx ehis.time[idx] x y = " + i + " " + idx + " " + ehis.time[idx] + " " + (int)poHis[i].x + " " + (int)poHis[i].y);
			idx = (idx + 1) % ehis.size;
		}
		
		
		//}b`O
		Point[] poHis2 = new Point[TIME_W];
//		long lastTime2;
		int startIdx = 0, minIdx = 0;
		double rdiff;
		double minR = 9E10;
		double rotRad = 0;
		boolean matchDone = false;
		int afterTWidx = 0;				//TIME_Widx
		int matchCount = 0;
		
//M.print("ehis dataSize  = " + ehis.dataSize);
//M.print("possible matching count = " + (ehis.dataSize - bulletTime - TIME_W));

		for (i = 0; i < ehis.dataSize - bulletTime - TIME_W - 10; i++) {

			idx = (ehis.startIndex + i) % ehis.size;
			startIdx = idx;

			//
			if (ehis.distance[(idx + TIME_W - 1) % ehis.size] > distance + distance * 0.2 || 
			    ehis.distance[(idx + TIME_W - 1) % ehis.size] < distance - distance * 0.2) {
				//قȂ
				continue;    
			}
			
			
			if (ehis.time[idx] > ehis.time[(idx + TIME_W + bulletTime + 10) % ehis.size]) {
				//Ԃ time=0 L
//				M.print("Fine time=0!! Skip");
				continue;	
			}
			
			//鎞 TIME_W Ԃ̈ʒu poHis2[] Ɋi[
			for (j = 0; j < TIME_W; j++) {
				poHis2[j] = new Point();
				poHis2[j].x = ehis.po[idx].x;
				poHis2[j].y = ehis.po[idx].y;
				idx = (idx + 1) % ehis.size;
//if (i == 0) M.print("j idx ehis.time[idx] lastTime2 x y = " + j + " " + idx + " " + ehis.time[idx] + " " + lastTime2 + " " + (int)poHis2[j].x + " " + (int)poHis2[j].y);
			}
			
			
			// poHis  poHis2 Ń}b`O
			rdiff = matching(poHis, poHis2);
			matchDone = true;
			matchCount++;
			
			if (minR > rdiff && rdiff != -1) {
				minR = rdiff;
				minIdx = startIdx;
				afterTWidx = (ehis.size + idx - 1) % ehis.size;
				rotRad = this.rotationRad;
			}
		}
//M.print("Min rdiff idx degree = " + minR + " " + minIdx + " " + Math.toDegrees(rotRad));
//M.print("Min Time = " + ehis.time[minIdx]);
//M.print("matching count = " + matchCount);

		if (!matchDone) return null;


		//}b`OƂɁCbulletTimëʒu\
		int afterBTidx = (afterTWidx + bulletTime) % ehis.size;
//M.print("afterTWidx time[] = " + afterTWidx + " " + ehis.time[afterTWidx]);
//M.print("afterBTidx time[] = " + afterBTidx + " " + ehis.time[afterBTidx]);

		
		double predX, predY, predX2, predY2;
		
		predX = ehis.po[afterBTidx].x - ehis.po[afterTWidx].x;
		predY = ehis.po[afterBTidx].y - ehis.po[afterTWidx].y;		
		
//M.print("after TW pos = " + ehis.po[afterTWidx].x + " " + ehis.po[afterTWidx].y);
//M.print("after BT pos = " + ehis.po[afterBTidx].x + " " + ehis.po[afterBTidx].y);

		//݂̓Gʒu̗\ʒuɂȂ悤]
		predX2 = Math.cos(rotRad) * predX - Math.sin(rotRad) * predY;
		predY2 = Math.sin(rotRad) * predX + Math.cos(rotRad) * predY;
		
//M.print("pred X Y = " + (int)predX2 + " " + (int)predY2);


		//G\ʒuɊÂ bulletTime ČvZ
		double epX, epY;
		
		for (i = 0; i < 4; i++) {
			epX = eneX + predX2;
			epY = eneY + predY2;

			if (epX < 20)           epX = 20;
			else if (epX > fW - 20) epX = fW - 20;
			if (epY < 20)           epY = 20;
			else if (epY > fH - 20) epY = fH - 20;
	
//M.print("enemy po = " + epX + " " + epY);

			dx = myX - epX;
			dy = myY - epY;
		
			distance = Math.sqrt(dx*dx + dy*dy);
			bulletTime = (int)(distance / bulletVelocity);
//M.print("new bulletTime = " + i + ": " + bulletTime);

//M.print("afterTimeWidthIndex  ehis.time = " + afterTWidx + " " + ehis.time[afterTWidx]);
//M.print("predTime = " + predTime);
//M.print("afterBTidx ehis.time = " + afterBTidx + " " + ehis.time[afterBTidx]);
		
			afterBTidx = (afterTWidx + bulletTime) % ehis.size;

			if (ehis.time[afterBTidx] < ehis.time[afterTWidx]) {
				//Ԃ time=0 
				M.print("There is time=0 after TW -- BT");
				return null;
			}

			predX = ehis.po[afterBTidx].x - ehis.po[afterTWidx].x;
			predY = ehis.po[afterBTidx].y - ehis.po[afterTWidx].y;		
		
//M.print("after TW pos = " + ehis.po[afterTWidx].x + " " + ehis.po[afterTWidx].y);
//M.print("after BT pos = " + ehis.po[afterBTidx].x + " " + ehis.po[afterBTidx].y);

			//݂̓Gʒu̗\ʒuɂȂ悤]
			predX2 = Math.cos(rotRad) * predX - Math.sin(rotRad) * predY;
			predY2 = Math.sin(rotRad) * predX + Math.cos(rotRad) * predY;
		}
		
//M.print("pred X Y = " + (int)predX2 + " " + (int)predY2);
		
		return new Point(predX2, predY2);
	}

	//------------------------------------------------------------------
	// matching() -- ̃p^[}b`O
	//
	// ߂lF ʒu̍̃[g敽
	//			-1 -- }b`OɎgpłʒuȂ
	//			rotationRad -- po2  po1 ւ̉]pCCX^XϐɊi[
	//------------------------------------------------------------------
	double matching(Point[] po1, Point[] po2) {
		int i;

		double dx1, dy1, dx2, dy2;
		dx1 = po1[TIME_W - 1].x - po1[0].x;
		dy1 = po1[TIME_W - 1].y - po1[0].y;		
		dx2 = po2[TIME_W - 1].x - po2[0].x;
		dy2 = po2[TIME_W - 1].y - po2[0].y;
		
		double theta1, theta2, rad;
		theta1 = Math.atan2(dy1, dx1);
		theta2 = Math.atan2(dy2, dx2);
		rad = theta1 - theta2;		//po2  po1 ւ̉]p
		this.rotationRad = rad;
		
//M.print("dx1 dy1 = " + (int)dx1 + " " + (int)dy1);
//M.print("dx2 dy2 = " + (int)dx2 + " " + (int)dy2);

//M.print("D theta = " + Math.toDegrees(rad));

		//ʒu̍̎
		double xx1, yy1, xx2, yy2, txx2, tyy2;
		double diff = 0;
		int count = 0;
		double dx, dy;
		for (i = 0; i < TIME_W; i++) {
			xx1 = po1[i].x - po1[0].x;
			yy1 = po1[i].y - po1[0].y;
			txx2 = po2[i].x - po2[0].x;
			tyy2 = po2[i].y - po2[0].y;
			xx2 = Math.cos(rad) * txx2 - Math.sin(rad) * tyy2;
			yy2 = Math.sin(rad) * txx2 + Math.cos(rad) * tyy2;
//M.print("txx2 tyy2 = " + (int)txx2 + " " + (int)tyy2);
//M.print("i: x1 y1 x2 y2 = " + i + ": " + (int)xx1 + " " + (int)yy1 + "   " + (int)xx2 + " " + (int)yy2);

			dx = xx1 - xx2;
			dy = yy1 - yy2;
			diff += Math.sqrt(dx*dx + dy*dy);
		}

//M.print("diff count = " + diff + " " + count);

		return diff / TIME_W;
	}
}