package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* MoveCornerSquare.java -- R[i[ɐwlp`ړ
*
* Date:		2002/Nov/23
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
class MoveCornerSquare implements Move {
	MyRobot my;
	double fW, fH;
	double dstX, dstY;
	Random rand = new Random(System.currentTimeMillis());
	
	final int NORTH = MyRobot.NORTH;
	final int SOUTH = MyRobot.SOUTH;
	final int WEST = MyRobot.WEST;
	final int EAST = MyRobot.EAST;
	final int NE = MyRobot.NE;
	final int SE = MyRobot.SE;
	final int NW = MyRobot.NW;
	final int SW = MyRobot.SW;	
									
	int nearWall, nearCorner;
	int posIndex = 0;
	double[] xs;
	double[] ys;
	boolean isInitPos = false;
	int lapseTime = 0;
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public MoveCornerSquare(MyRobot my) {
		this.my = my;
		fW = my.fW;
		fH = my.fH;
		
		init();
	}
	
	public void init() {
		my.EPSILON = 10;
		dstX = my.getX();
		dstY = my.getY();
		setNearWall();
		setNearCorner();
		createDestination();
		my.setMaxVelocity(8);
	}
	
	
	public double getDstX() {
		return dstX;
	}
	
	public double getDstY() {
		return dstY;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setNextPoint() {
		lapseTime++;
		
		//ʒuɈړ
		if (!isInitPos) {			
			//ł߂ǂɒi
			switch (nearWall) {
				case NORTH:
					dstY = fH - 100;
					break;
				case EAST:
					dstX = fW - 100;
					break;
				case SOUTH:
					dstY = 100;
					break;
				case WEST:
					dstX = 100;
					break;
				default:
					;
			}
			
			if (my.isArrived(dstX, dstY)) {
				isInitPos = true;
			}
			my.setGoPos(dstX, dstY);
			return;
		}

		double dx = 0, dy = 0;
		
		//ړݒ
		if (my.isArrived(dstX, dstY)) {
			lapseTime = 0;

			dstX = xs[posIndex] + dx;
			dstY = ys[posIndex] + dy;
			posIndex++;
			posIndex = posIndex % xs.length;
			//print("I will go to -- " + dstX + " " + dstY);
		}
		
		//speed
		dx = dstX - my.getX();
		dy = dstY - my.getY();
		double d = Math.sqrt(dx*dx + dy*dy);
		
//		double speed = Math.min((d - 5) / 40.0 * 8.0, 8);
		double speed;
				
		if (lapseTime < 4) speed = 2;
		else speed = Math.min(d / 30.0 * 8.0, 8);

		speed = Math.max(speed, 1);
		
		my.setMaxVelocity(speed);

//M.print("speed = " + speed);

		my.setGoPos(dstX, dstY);
	}

	//------------------------------------------------------------------
	// createDestination()
	//
	//
	//------------------------------------------------------------------
	void createDestination() {
		int dirX, dirY;
		double ox, oy;
		final int MARGIN = 60;
		final int DIFF = 150;
		
		switch (nearCorner) {
			case  NW:
				dirX = 1;
				dirY = -1;
				ox = MARGIN;
				oy = fH - MARGIN;
				break;
			case NE:
				dirX = -1;
				dirY = -1;
				ox = fW - MARGIN;
				oy = fH - MARGIN;				
				break;
			case SE:
				dirX = -1;
				dirY = 1;
				ox = fW - MARGIN;
				oy = MARGIN;
				break;
			case SW:
			default:
				dirX = 1;
				dirY = 1;
				ox = MARGIN;
				oy = MARGIN;
				break;
		}
		
		xs = new double[12];
		ys = new double[12];
		
		xs[0] = ox + DIFF * dirX;
		ys[0] = oy + DIFF * dirY;
		xs[1] = ox + (DIFF + 50) * dirX;
		ys[1] = oy;
		xs[2] = ox;
		ys[2] = oy;	
		xs[3] = ox;
		ys[3] = oy + DIFF * dirY;
		xs[4] = xs[0];
		ys[4] = ys[0];
		xs[5] = ox + DIFF * dirX;
		ys[5] = oy + DIFF * dirY * 2;
		xs[6] = ox;
		ys[6] = oy + (DIFF + 30) * dirY * 2;
		xs[7] = xs[3];
		ys[7] = ys[3];
		xs[8] = xs[0];
		ys[8] = ys[0];
		xs[9] = ox + (DIFF - 30) * dirX;
		ys[9] = ys[1];
		xs[10] = ox + DIFF * dirX * 2;
		ys[10] = oy;
		xs[11] = ox + DIFF * dirX * 2;
		ys[11] = oy + DIFF * dirY;
		
	}


	//------------------------------------------------------------------
	// setNearWall()
	//
	//
	//------------------------------------------------------------------
	void setNearWall() {
		double min = my.getX();
		double myX = my.getX();
		double myY = my.getY();
		
		nearWall = WEST;
		dstX = myX;
		dstY = myY;
		
		//Ƃ߂ǂ̕ṕH
		if (min > fH - myY) {
			nearWall = NORTH;
			min = fH - myY;
		}

		if (min > fW - myX) {
			nearWall = EAST;
			min = fW - myX;
		}
		
		if (min > myY) {
			nearWall = SOUTH;
			min = myY;
		}
	}
		
	//------------------------------------------------------------------
	// setNearCorner()
	//
	//
	//------------------------------------------------------------------
	void setNearCorner() {
		double myX = my.getX();
		double myY = my.getY();
		
		if (nearWall == NORTH) {
			if (myX < fW - myX) nearCorner = NW;
			else                      nearCorner = NE;
		} else if (nearWall == EAST) {
			if (myY < fH - myY) nearCorner = SE;
			else                      nearCorner = NE;				
		} else if (nearWall == SOUTH) {
			if (myX < fW - myX) nearCorner = SW;
			else                      nearCorner = SE;
		} else if (nearWall == WEST) {
			if (myY < fH - myY) nearCorner = SW;
			else                      nearCorner = NW;				
		}
	}

	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setMove() {
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void wallNear() {
		my.setMaxVelocity(2);
		my.execute();
		my.setMaxVelocity(8);
//M.print("wall near!!");
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void hitByBullet(HitByBulletEvent e) {
		my.result.damage();
	}
	
	//--------------------------------------------------------------
	// correctDestination() -- dstX, dstY tB[h̒lɂ
	//
	//------------------------------------------------------------
	private void correctDestination() {
		final double MARGIN = 30;
		
		if (dstX < MARGIN) dstX = MARGIN;
		else if (fW - dstX < MARGIN)  dstX = fW - MARGIN;
		if (dstY < MARGIN) dstY = MARGIN;
		else  if (fH - dstY < MARGIN) dstY = fH - MARGIN;
	}

	//---------------------------------
	//
	//--------------------------------
	private void setSpeed() {
		double dx = dstX - my.getX();
		double dy = dstY - my.getY();
		double d = Math.sqrt(dx * dx + dy * dy);
		double v = Math.min(d * 8.0 / 50.0, 8.0);
		
		my.setMaxVelocity(v);
		M.print("set speed = " + v + " " + d);
	}
	
	
	//------------------------------------------------------------------
	// scannedRobot()
	//
	//
	//------------------------------------------------------------------
	public void scannedRobot(ScannedRobotEvent e) {
		my.map.put(e, my.getHeading(), my.getTime(), my.getX(), my.getY());
	}
}