package sch;

/**
 * Point is an x,y coordinate in the game
 */
public final class Point implements Constants {

    /**
     * The X coordinate of the point
     */
    public double x;
    
    /**
     * The Y coordinate of this point
     */
    public double y;

    /** 
     * Create a new Point equal to another Point
     * @param	p	a Point
     */
    public Point(Point p) {

        x = p.x;
        y = p.y;
    }

    /** 
     * Create an empty Point with given (0,0) coordinates
     */
    public Point() {

        x = 0.0;
        y = 0.0;
    }
	
    /** 
     * Create a new Point with given x,y coordinates
     * @param	newX	x coordinate
     * @param	newY	y coordinate
     */
    public Point(double newX, double newY) {

        x = newX;
        y = newY;
    }
	
	/**
	 * Add to the Point another point specified in x,y coordinate
	 * @param	newX	the X amount to add
	 * @param	newY	the Y amount to add
	 */
    public void add(double newX, double newY) {

        x += newX;
        y += newY;
    }

	/**
	 * Add to the Point another Point
	 * @param	p	the Point to add
	 */
    public void add(Point p) {

        x += p.x;
        y += p.y;
    }

    /**
     * Return a string representation of this class
     * @return		the string representation
     */
    public String toString() {
        return "x=" + BotMath.round2(x) + ", y=" + BotMath.round2(y);
    }
}

