/*
 * Created on 2004-9-26
 */
package tide.util;


import java.awt.geom.Point2D;


/**
 * This class use to record a robot's info for tick
 * 
 * @author iiley(Chen Jing)
 */
public class BotInfo {
	protected Point2D location = new Point2D.Double();
	protected double direction = 1;
	protected double energy;
	protected double absBearing, velocity, distance, heading, leaveVelocity, closeVelocity;
	protected String name;
	protected long time;
	
	public BotInfo() {
		this.name = "";
		this.energy = 0;
		this.distance = 500;
		this.direction = 1;
	}
	
	public BotInfo(String name, double energy) {
		this.name = name;
		this.energy = energy;
		this.distance = 500;
		this.direction = 1;
	}
	
	public void modifyEnergy(double dis){
		energy += dis;
		energy = Math.max(energy, 0d);
	}
	
	/**
	 * @return Returns the time.
	 */
	public long getTime() {
		return time;
	}
	/**
	 * @return Returns the absBearing.
	 */
	public double getAbsBearing() {
		return absBearing;
	}
	/**
	 * @return Returns the direction.
	 */
	public double getDirection() {
		return direction;
	}
	/**
	 * @return Returns the distance.
	 */
	public double getDistance() {
		return distance;
	}
	/**
	 * @return Returns the energy.
	 */
	public double getEnergy() {
		return energy;
	}
	/**
	 * @return Returns the heading.
	 */
	public double getHeading() {
		return heading;
	}
	/**
	 * @return Returns the location.
	 */
	public Point2D getLocation() {
		return location;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @return Returns the velocity.
	 */
	public double getVelocity() {
		return velocity;
	}
	
	/**
	 * @return Returns the leaveVelocity.
	 */
	public double getLeaveVelocity() {
		return leaveVelocity;
	}
	
	
	/**
	 * @return Returns the closeVelocity.
	 */
	public double getCloseVelocity() {
		return closeVelocity;
	}
}
