/*
 * Created on 2004-9-26
 */
package tide.util;

import java.util.HashMap;
import java.util.Map;

import tide.pear.Pear;

/**
 * store the bot info in a list by time
 * this version a list can only store infos in a same round
 * @author iiley(Chen Jing)
 */
public class BotInfoList {
	private Map map;
	
	public BotInfoList(){
		map = new HashMap();
	}
	
	/**
	 * Add a bot info for time
	 * @param time the time of the info
	 * @param info
	 */
	public void addInfo(long time, BotInfo info){
		map.put(new Long(time), info);
	}
	
	/**
	 * get a botinfo in certain time,if there is not,return null
	 * @param time
	 * @return a botinfo in certain time,if there is not,return null
	 */
	public BotInfo getInfo(long time){
		return (BotInfo)map.get(new Long(time));
	}
	
	/**
	 * get a botinfo in certain time,if there is not,return a empty info,not a null
	 * @param time
	 * @return a botinfo in certain time,if there is not,return a empty info,not a null
	 */
	public BotInfo getInfoMustHaveOne(long time){
		BotInfo info = (BotInfo)map.get(new Long(time));
		if(info == null){
			for(long i=time; i>0l; i--){
				info = (BotInfo)map.get(new Long(i));
				if(info != null){
					//set to zero
					//Pear.log("nearest info - "+info.getName()+" : "+time+"->" + i + "  pos: " + info.getLocation());
					//info.modifyEnergy(-info.getEnergy());
					return info;
				}
			}
			//Pear.log("not have info : " + time);
			info = new BotInfo();
		}
		return info;
	}
	
	/**
	 * clear the list
	 */
	public void clear(){
		map.clear();
	}
}
