package geep.mini;
import robocode.*;
import java.awt.Color;
import java.io.*;

/**
 * Ver 1.1
 *
 * Aiming taken from BestAimer / Evolutionary run #61
 * Movement taken from BestAvoider / Evolutionary run #64A
 * Radar taken from BestScanner / Evolutionary run #59
 *
 * All code sections were manually optimized to fit codesize limits. Original commands are:
 *   > TurnGun	 (cos (add (arccos enemy_bearing) (mul (mul (arccos (div (arccos (ot_ifGreater (abs 16.7) (abs enemy_velocity) (div wall_bearing wall_bearing) (div wall_bearing wall_bearing))) (div wall_bearing wall_bearing))) enemy_bearing) (ot_ifGreater (ot_ifGreater (abs energy) (ot_ifGreater (div wall_bearing (abs enemy_velocity)) (abs energy) enemy_bearing (arccos (ot_ifGreater (div wall_bearing wall_bearing) (div wall_bearing wall_bearing) (div wall_bearing wall_bearing) (div wall_bearing wall_bearing)))) (ot_ifGreater (div (arccos enemy_bearing) (ot_ifGreater (abs energy) (abs energy) (div wall_bearing wall_bearing) (div wall_bearing wall_bearing))) (div wall_bearing wall_bearing) wall_bearing (div wall_bearing wall_bearing)) (div wall_bearing wall_bearing)) enemy_bearing enemy_bearing (div (div wall_bearing (abs energy)) wall_bearing)))))
 *   > Move	 (ot_ifGreater (sub (sin wall_bearing) -0.8409037002678847) (add (abs wall_distance) (sin 0.8564102557336999)) (add (ot_ifGreater (sub (ot_ifGreater (sub (sin 0.8564102557336999) (add (ot_ifGreater (abs wall_bearing) -0.8409037002678847 -0.8409037002678847 -0.8409037002678847) 0.6330687407642777)) -0.8409037002678847 (add (sin 0.8564102557336999) (sin 0.8564102557336999)) (ot_ifGreater (ot_ifGreater (mul enemy_energy -0.8409037002678847) -0.8409037002678847 (add enemy_bearing random) (abs wall_bearing)) (mul -0.8409037002678847 -0.8409037002678847) (add (abs wall_distance) (arcsin (sin wall_bearing))) (ot_ifGreater -0.8409037002678847 enemy_energy -0.8409037002678847 (abs enemy_bearing)))) -0.8409037002678847) (add (arcsin (sin wall_bearing)) (sub (add (abs energy) (sin 0.8564102557336999)) -0.8409037002678847)) (add (ot_ifGreater (sub (sin wall_bearing) wall_bearing) (mul (add enemy_bearing random) (arcsin (sin wall_bearing))) (add (abs wall_distance) (sin 0.8564102557336999)) -0.8409037002678847) (sin 0.8564102557336999)) -0.8409037002678847) (ot_ifGreater (sub (abs enemy_energy) -0.8409037002678847) (sin 0.8564102557336999) (add (ot_ifGreater (sub (sin wall_bearing) (add enemy_velocity 0.6330687407642777)) -0.8409037002678847 (add (sin wall_bearing) (sin 0.8564102557336999)) (ot_ifGreater (ot_ifGreater (sin 0.8564102557336999) -0.8409037002678847 (add enemy_bearing random) (abs wall_bearing)) (add enemy_velocity 0.6330687407642777) (add (sin wall_bearing) -0.8409037002678847) (ot_ifGreater (sin 0.8564102557336999) (sub 0.8564102557336999 -0.8409037002678847) -0.8409037002678847 (abs (abs wall_distance))))) (abs wall_bearing)) enemy_velocity)) (ot_ifGreater (ot_ifGreater (sub (add enemy_velocity (abs (abs wall_distance))) -0.8409037002678847) -0.8409037002678847 (add (abs energy) (sin 0.8564102557336999)) (ot_ifGreater (mul enemy_energy -0.8409037002678847) -0.8409037002678847 (add enemy_bearing random) (add (add -0.8409037002678847 (sin 0.8564102557336999)) (sin 0.8564102557336999)))) (add enemy_bearing random) -0.8409037002678847 (add (ot_ifGreater (sin 0.8564102557336999) -0.8409037002678847 enemy_velocity (abs wall_bearing)) 0.6330687407642777)))
 *   > TurnTank (ot_ifGreater (sub (abs wall_distance) -0.8409037002678847) (add (abs wall_distance) (sub 0.8564102557336999 -0.8409037002678847)) (add (ot_ifGreater (sub (sin wall_bearing) (sin (sub -0.8409037002678847 (add (sin wall_bearing) 0.6330687407642777)))) -0.8409037002678847 (add enemy_bearing (arcsin (sin wall_bearing))) (ot_ifGreater (ot_ifGreater (ot_ifGreater (sub (add enemy_velocity (abs wall_distance)) -0.8409037002678847) -0.8409037002678847 (add (abs energy) (ot_ifGreater (sin 0.8564102557336999) -0.8409037002678847 enemy_velocity (abs wall_bearing))) (ot_ifGreater (mul enemy_energy -0.8409037002678847) -0.8409037002678847 (add enemy_bearing random) (sin 0.8564102557336999))) enemy_energy -0.8409037002678847 (add enemy_velocity (sin 0.8564102557336999))) (mul -0.8409037002678847 -0.8409037002678847) wall_bearing (ot_ifGreater (sin 0.8564102557336999) (add enemy_velocity (sub 0.8564102557336999 (sub (sin 0.8564102557336999) -0.8409037002678847))) -0.8409037002678847 (abs (abs wall_distance))))) (ot_ifGreater (abs wall_bearing) (add enemy_bearing random) (sub -0.8409037002678847 (add enemy_velocity 0.6330687407642777)) (abs wall_bearing))) (ot_ifGreater (ot_ifGreater (mul -0.8409037002678847 -0.8409037002678847) -0.8409037002678847 (abs wall_bearing) (ot_ifGreater (add enemy_velocity 0.6330687407642777) (ot_ifGreater (ot_ifGreater (sub (add enemy_velocity (abs wall_distance)) -0.8409037002678847) -0.8409037002678847 (add (abs energy) (ot_ifGreater (sin 0.8564102557336999) -0.8409037002678847 (add enemy_bearing random) (abs wall_bearing))) (abs wall_distance)) (mul (sub 0.8564102557336999 -0.8409037002678847) (arcsin (sin wall_bearing))) -0.8409037002678847 (add enemy_velocity (sub -0.8409037002678847 (add enemy_velocity 0.6330687407642777)))) (sub -0.8409037002678847 (add enemy_velocity 0.6330687407642777)) (abs wall_bearing))) -0.8409037002678847 -0.8409037002678847 (abs wall_bearing)))
 *
 * [[geep 30/8/2004]]
 */
public class GPBotB extends AdvancedRobot
{

	public static final double MOVE_MULTIPLIER = 300.0;
	public static final double TURN_MULTIPLIER = 180.0;
	public static final double ENERGY_MULTIPLIER = 100.0;

	public static final int TANK = 0;
	public static final int GUN = 1;
	public static final int RADAR = 2;

	private static double enemyDistance;
	private static double enemyBearing;
	private static double enemyVelocity;
	private static double enemyHeading;
	private static double enemyEnergy;

	public void run() {
		setColors(Color.RED, Color.RED, Color.WHITE);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do {
	    	turnRadarRightRadians(Double.POSITIVE_INFINITY);
		} while (true);

	}

	public void onScannedRobot(ScannedRobotEvent e) {
		enemyDistance = e.getDistance()/MOVE_MULTIPLIER;
		enemyBearing = e.getBearing()/TURN_MULTIPLIER;
		enemyHeading = (e.getHeading()-getHeading())/TURN_MULTIPLIER;
		enemyVelocity = e.getVelocity()/MOVE_MULTIPLIER;
		enemyEnergy = e.getEnergy()/ENERGY_MULTIPLIER;

        move((Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1])  + 0.8409037002678847 > nearestWall()[0]  + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) ? ((Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) + 0.8409037002678847 + 0.6330687407642777 > -0.8409037002678847 ? Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) : ((enemyEnergy * -0.8409037002678847 > -0.8409037002678847 ? enemyBearing + (Math.random()*2.0-1.0) : Math.abs(nearestWall()[1]) ) > -0.8409037002678847 * -0.8409037002678847 ? nearestWall()[0]  + (Math.asin(Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1]))*(180.0/Math.PI)/TURN_MULTIPLIER) : Math.abs(enemyBearing) )) + 0.8409037002678847 > (Math.asin(Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1]))*(180.0/Math.PI)/TURN_MULTIPLIER) + (getEnergy() / ENERGY_MULTIPLIER)  + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) + 0.8409037002678847 ? (Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1]) - nearestWall()[1] > enemyBearing + (Math.random()*2.0-1.0) * (Math.asin(Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1]))*(180.0/Math.PI)/TURN_MULTIPLIER) ? nearestWall()[0]  + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) : -0.8409037002678847) + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) : -0.8409037002678847) + (enemyEnergy  + 0.8409037002678847 > Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) ? (Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1]) - enemyVelocity + 0.6330687407642777 > -0.8409037002678847 ? Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1]) + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) : ((Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) > -0.8409037002678847 ? enemyBearing + (Math.random()*2.0-1.0) : Math.abs(nearestWall()[1]) ) > enemyVelocity + 0.6330687407642777 ? Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *nearestWall()[1])  - 0.8409037002678847 : (nearestWall()[0] ))) + Math.abs(nearestWall()[1])  : enemyVelocity) : (((enemyEnergy * -0.8409037002678847 > -0.8409037002678847 ? enemyBearing + (Math.random()*2.0-1.0) : -0.8409037002678847 + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) + Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999))) > enemyBearing + (Math.random()*2.0-1.0) ? -0.8409037002678847 : (Math.sin(TURN_MULTIPLIER * (Math.PI/180.0) *0.8564102557336999) > -0.8409037002678847 ? enemyVelocity : Math.abs(nearestWall()[1]) ) + 0.6330687407642777)));
		turn(TANK,  -0.8409037002678847 );
		turn(GUN, Math.cos(TURN_MULTIPLIER * (Math.PI/180.0) *(Math.acos(enemyBearing)*(180.0/Math.PI)/TURN_MULTIPLIER) + (Math.acos(((nearestWall()[1] == 0 ? 0 : 1) == 0 ? 0 : (Math.acos(( (nearestWall()[1] == 0 ? 0 : 1)))*(180.0/Math.PI)/TURN_MULTIPLIER) / (nearestWall()[1] == 0 ? 0 : 1)))*(180.0/Math.PI)/TURN_MULTIPLIER) * enemyBearing * (((getEnergy() / ENERGY_MULTIPLIER)  > ((Math.abs(enemyVelocity)  == 0 ? 0 : nearestWall()[1] / enemyVelocity ) > (getEnergy() / ENERGY_MULTIPLIER)  ? enemyBearing : (Math.acos(((nearestWall()[1] == 0 ? 0 : 1) > (nearestWall()[1] == 0 ? 0 : 1) ? (nearestWall()[1] == 0 ? 0 : 1) : (nearestWall()[1] == 0 ? 0 : 1)))*(180.0/Math.PI)/TURN_MULTIPLIER)) ? ((( (nearestWall()[1] == 0 ? 0 : 1)) == 0 ? 0 : (Math.acos(enemyBearing)*(180.0/Math.PI)/TURN_MULTIPLIER) / (  (nearestWall()[1] == 0 ? 0 : 1))) > (nearestWall()[1] == 0 ? 0 : 1) ? nearestWall()[1] : (nearestWall()[1] == 0 ? 0 : 1)) : (nearestWall()[1] == 0 ? 0 : 1)) > enemyBearing ? enemyBearing : (nearestWall()[1] == 0 ? 0 : (Math.abs((getEnergy() / ENERGY_MULTIPLIER))  == 0 ? 0 : nearestWall()[1] / Math.abs((getEnergy() / ENERGY_MULTIPLIER)) ) / nearestWall()[1]))));
		turn(RADAR, enemyBearing);
		setFire(Math.random()*3.0);


	}

	public void onHitRobot(HitRobotEvent e) {
		enemyDistance = 0;
		enemyBearing = e.getBearing()/TURN_MULTIPLIER;
		enemyEnergy = e.getEnergy()/ENERGY_MULTIPLIER;
	}

	private double []nearestWall() {
		double []res = new double[]{getBattleFieldHeight()-getY(), 0.0};
		if (res[0] > getBattleFieldWidth()-getX()) {
			res = new double[]{getBattleFieldWidth()-getX(), 90.0};
		}
		if (res[0] > getY()) {
			res = new double[]{getY(), 180.0};
		}
		if (res[0] > getX()) {
			res = new double[]{getX(), 270.0};
		}


		res[1] -= getHeading(); //adjust to robot's heading
		res[0] /= MOVE_MULTIPLIER; //adjust to movement multiplier
		res[1] /= TURN_MULTIPLIER; //adjust to turning multiplier

		return res;
	}

	public double move(double amount) {
		setAhead(MOVE_MULTIPLIER*amount);
		return amount;
	}

	private double turn(int what, double x) {

		switch (what) {
			case TANK : 	setTurnRight(normalizeAngle(TURN_MULTIPLIER*x));
			break;
			case GUN : 	    double z = x + (getHeading() - getGunHeading())/TURN_MULTIPLIER;
			setTurnGunRight(normalizeAngle(TURN_MULTIPLIER*z));
			break;
			case RADAR : 	double zz = x + (getHeading() - getRadarHeading())/TURN_MULTIPLIER;
			setTurnRadarRight(normalizeAngle(TURN_MULTIPLIER*zz));
			break;
		}
		return x;
	}

	private static double normalizeAngle(double angle) {
		while (angle>180) angle -= 360;
		while (angle<-180) angle += 360;
		return angle;
	}
}
