package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/**
 * MagnetMovement - a movement strategy to chase and ram an opponent.  Doesn't really dodge.
 */
public class MagnetMovement extends MovementStrategy implements java.io.Serializable
{
	private transient boolean back;
	
	public MagnetMovement(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot, targetter);
	}
	
	public void onEvent(Event e)
	{
	}
	
	public void setAction()
	{
		EnemyState closest = getTarget();
		if (closest == null)
			return;
		double distance = closest.getDistance(robot.getX(), robot.getY());
		double absoluteangle = closest.getAbsoluteBearing(robot.getX(), robot.getY());
		turn(absoluteangle-robot.getHeadingRadians());
		if (back)
			robot.setBack(distance);
		else
			robot.setAhead(distance);
		back = false;
	}
	
	public void turn(double angle)
	{
		while (angle < -Math.PI)
			angle += Math.PI*2;
		while (angle > Math.PI)
			angle -= Math.PI*2;
		if (angle < -Math.PI/2)
		{
			back = true;
			angle += Math.PI;
		}
		else if (angle > Math.PI/2)
		{
			back = true;
			angle -= Math.PI;
		}
		if (angle > 0)
			robot.setTurnRightRadians(angle);
		else
			robot.setTurnLeftRadians(-angle);
	}
}
