package kawigi.spare.util;
import kawigi.spare.SpareParts;
import java.util.Vector;

public class GravityManager
{
	private Vector gravpoints;
	private Vector bullets;
	private EnemyManager manager;
	WallGravity walls;
	
	public GravityManager(EnemyManager manager)
	{
		this.manager = manager;
		gravpoints = new Vector();
		bullets = new Vector();
		walls = new WallGravity(SpareParts.fieldx, SpareParts.fieldy);
	}
	
	public DefensiveVirtualBullet[] getActiveBullets(long time)
	{
		updateBullets(time);
		DefensiveVirtualBullet[] bulletarray = new DefensiveVirtualBullet[bullets.size()];
		bullets.toArray(bulletarray);
		return bulletarray;
	}
	
	public void update(long time)
	{
		gravpoints.removeAllElements();
		gravpoints.addElement(walls);
		for (int i=0; i<manager.countEnemies(); i++)
		{
			EnemyState enemy = manager.getEnemyAt(i);
			if (enemy == null)
				break;
			if (!enemy.isDead() && enemy.getTimeElapsed(time) < 20 && enemy.getTimeElapsed(time) >= 0)
				gravpoints.add(new GravityVector(enemy.getX(), enemy.getY(), enemy.getEnergy()));
		}
		updateBullets(time);
		System.out.println(bullets.size() + " bullets");
	}
	
	private void updateBullets(long time)
	{
		DefensiveVirtualBullet[] newbullets = manager.getNewBullets();
		for (int i=0; i< newbullets.length; i++)
			bullets.addElement(newbullets[i]);
		for (int i=0; i<bullets.size(); i++)
		{
			if (((DefensiveVirtualBullet)bullets.elementAt(i)).isInactive(time))
			{
				bullets.removeElementAt(i);
				i--;
			}
			else
			{
				double x = ((DefensiveVirtualBullet)bullets.elementAt(i)).getX(time);
				double y = ((DefensiveVirtualBullet)bullets.elementAt(i)).getY(time);
			}
		}
	}
	
	public double getTotalForce(double x, double y)
	{
		double force = 0;
		for (int i=0; i<gravpoints.size(); i++)
			force += ((GravityVector)gravpoints.elementAt(i)).force(x, y);
		return force;
	}
	
	public double getNegativeForceDirection(double x, double y)
	{
		double xdir = 0;
		double ydir = 0;
		for (int i=1; i<gravpoints.size(); i++)
		{
			if (gravpoints.elementAt(i) instanceof WallGravity)
				continue;
			GravityVector point = (GravityVector)gravpoints.elementAt(i);
			double f = point.force(x, y);
			double direction = point.absoluteAngle(x, y);
			xdir += f*Math.sin(direction);
			ydir += f*Math.cos(direction);
		}
		return Math.atan2(xdir, ydir);
	}
	
	public double getForceDirection(double x, double y)
	{
		double xdir = 0;
		double ydir = 0;
		for (int i=0; i<gravpoints.size(); i++)
		{
			GravityVector point = (GravityVector)gravpoints.elementAt(i);
			double f = point.force(x, y);
			double direction = point.absoluteAngle(x, y);
			xdir += f*Math.sin(direction);
			ydir += f*Math.cos(direction);
		}
		return Math.atan2(-xdir, -ydir);
	}
}
