package jf;
import robocode.*;
import java.awt.Color;


// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Dodger - a robot by (your name here)
 */
public class Dodger extends AdvancedRobot
{
  double startingEnergy = 100;
  int movementDirection = 1;
  int gunDirection = 1;

LearningGun gun = new LearningGun(this);  

  public void run() {
	setAdjustRadarForGunTurn(true);
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForRobotTurn(true);
	
	setColors(Color.black, Color.black, Color.black, Color.black, Color.black);
    setTurnRadarRight(Double.POSITIVE_INFINITY);

	startingEnergy = 100;
	
	while(true){
	scan();	
	}  
}


  public void onScannedRobot(ScannedRobotEvent e) {
		
		
    // Learning Gun starts here
	gun.onScannedRobot(e);
	

	// Movement code starts here
 
 	// Stay at right angles to the opponent
    setTurnRight( quickAngle( e.getBearing()+ 90 - 30*movementDirection ) );
         
   
    double changeInEnergy = startingEnergy-e.getEnergy();

    if (changeInEnergy > 0 && changeInEnergy <= 3) {
         // Dodge!
         movementDirection = -movementDirection;
         setAhead((e.getDistance() / 4+25)*movementDirection);
     }
   
    gunDirection = -gunDirection;
    setTurnRadarRight(99999*gunDirection);
    
    
  // shootAtEnemy(e);
    
    
    startingEnergy = e.getEnergy();
  }
public void shootAtEnemy(ScannedRobotEvent e) {
		
		double firepower = 2.0;
		double fireangle = getGunHeading() - getHeading() - e.getBearing() + Math.toDegrees(Math.asin((e.getVelocity() / (20 - 3* firepower)) * Math.sin(Math.toRadians(180 - getHeading() - e.getBearing() + e.getHeading()))));
		
		fireangle = fixAngle(fireangle);
		setTurnGunLeft(fireangle);
		fire(firepower);
		
	}
public double fixAngle (double angle){
		angle = angle % 360;
	
		if( angle > 180){
			return angle - 360;
		}
	else if(angle <  -180){
		return angle +360;
	}
	return angle;

}	
public double quickAngle(double angle){
		angle = fixAngle(angle);
		
		if( angle > 90){
			return angle - 180;	
		}
		else if (angle < -90){
		return angle +180;
		}
		return angle;
		}
	
		
}


