/**
 * 
 */
package banshee;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Holder for detractors.
 * @author banshee
 *
 */
public class Detractors {

	private Map<String, Detractor> detractors = new HashMap<String, Detractor>();
	
	public void update(String id, double x, double y, double power) {
		Detractor detr = detractors.get(id);
		if (detr == null) {
			detr = new Detractor(id, x, y, power);
			detractors.put(id, detr);
		}
		detr.setX(x);
		detr.setY(y);
		detr.setPower(power);
	}
	
	public void remove(String id) {
		detractors.remove(id);
	}
	
	
	public Collection<Detractor> getDetractors() {
		return detractors.values();
	}

//	@Override
//	public String toString() {
//		return detractors.values().toString();
//	}
	
}
