/**
 * 
 */
package banshee;

import java.util.HashMap;
import java.util.Map;

/**
 * @author banshee
 *
 */
public class Enemies {
	
	private Map<String, Enemy> enemies = new HashMap<String, Enemy>();
	
	private String currTarget;
	
	/**
	 * @param name
	 * @param x
	 * @param y
	 * @param absAngle 0 to 2 * PI, from our position at the moment of observation, starting from north as 0
	 */
	public void update(String id, double x, double y, double absAngle, double velocity, double bearing, double heading) {
		Enemy enemy = enemies.get(id);
		if (enemy == null) {
			enemy = new Enemy(id, x, y, absAngle);
			enemies.put(id, enemy);
		}
		enemy.setX(x);
		enemy.setY(y);
		enemy.setAbsAngle(absAngle);
		enemy.setVelocity(velocity);
		enemy.setBearing(bearing);
		enemy.setHeading(heading);
	}

	public void setCurrentTarget(String name) {
		this.currTarget = name;
	}
	
	public Enemy getCurrentTarget() {
		return enemies.get(currTarget);
	}

	public void remove(String name) {
		enemies.remove(name);
	}

}
