package dsekercioglu.mega.wfMove.move;

import dsekercioglu.mega.megaCore.KNNPredictor;
import dsekercioglu.mega.wfMove.Lightning;
import dsekercioglu.mega.wfMove.move.formulas.Formula;
import dsekercioglu.mega.wfMove.move.formulas.FormulaFlattener;
import dsekercioglu.mega.wfMove.move.thresholds.Threshold;
import java.util.Arrays;

public class KNNView extends View {

    public final int BINS;
    KNNPredictor predictor;

    private final int K;

    final Formula FORMULA;

    boolean log = false;

    final Threshold THRESHOLD;
    final boolean ALWAYS_LOG;
    final boolean VISITS;

    public KNNView(int bins, Formula formula, int k, int divisor, Threshold threshold, boolean alwaysLog, boolean visits) {
        BINS = bins;
        FORMULA = formula;
        K = k;
        ALWAYS_LOG = alwaysLog;
        VISITS = visits;
        THRESHOLD = threshold;
        predictor = new KNNPredictor();
        predictor.setup(formula.getWeights(), K, BINS, predictor.divisionK(K, divisor));
        predictor.addData(new double[formula.getWeights().length], BINS / 2, 0.001);
    }

    public double[] predict(Lightning.BattleInfo data, double hitRate) {
        if (hitRate >= THRESHOLD.getOpenThreshold(0, data.enemyHit)) {
            log = true;
        } else if (hitRate < THRESHOLD.getCloseThreshold(0, data.enemyHit)) {
            log = false;
        }
        if (log) {
            double[] bins = predictor.predictBins(FORMULA.getDataPoint(data));
            return bins;
        } else {
            return new double[BINS];
        }
    }

    public void wavePassed(Lightning.BattleInfo data, int bin, boolean real) {
        if ((log || ALWAYS_LOG) && (real ^ VISITS)) {
            predictor.addData(FORMULA.getDataPoint(data), bin, 1);
        }
    }

}
