package dsekercioglu.mega.wfMove.move.formulas;

import dsekercioglu.mega.wfMove.Lightning;
import java.util.Arrays;

public class FormulaNormal extends Formula {

    private final double[] WEIGHTS = {10, 4, 2, 4, 3, 2.5};

    @Override
    public double[] getDataPoint(Lightning.BattleInfo data) {
        double[] dataPoint = {Math.abs(data.lateralVelocity) / 8,
            (data.advancingVelocity + 8) / 16,
            (data.distance / 1000),
            Math.min(data.getMEA(1) / Math.PI * 2, 1),
            Math.min(data.getMEA(-1) / Math.PI * 2, 1),
            1 / (1.0 + data.timeSinceDeceleration * 0.1)};
        return dataPoint;
    }

    @Override
    public double[] getWeights() {
        return WEIGHTS;
    }

    @Override
    public Formula setDecay(double d) {
        WEIGHTS[WEIGHTS.length - 1] = d;
        return this;
    }

}
