package tornyil.bottomup;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class BottomUp extends AdvancedRobot
{

   private static final double ROLLINGDEPTH = 30.0;
   private static final int LATVELSEGS = 6;
   private static final int DISTANCESEGS = 4;
   private static final int BINS = 49;
   private static final int BINS_MINUS1 = 48;
   private static final int BINS_MIDDLE = 24;

   private static final double WALL_STICK = 160.0;
   private static final double HALF_PI_PLUS_SOME = 1.4*Math.PI/2;

   private static java.awt.geom.Rectangle2D.Double gFieldRect = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);

   private static Point2D.Double gEnemyNow;

   private static int gMeClockwise;
   private static int gCollisions;

   private static double[][][] gGuessFactors = new double[LATVELSEGS][DISTANCESEGS][BINS];

   public void run() {
      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);
      gMeClockwise = 1;
      while(true) {
         turnRadarRightRadians(1);
      }
   }

   public void onHitRobot(HitRobotEvent event) {
      gCollisions++;
   }

   public void onScannedRobot(ScannedRobotEvent e) {
      Wave w;
      double enemyAbsBearing = ((w = new Wave()).enemyAbsBearing = e.getBearingRadians()+getHeadingRadians());
      Point2D.Double meNow = w.center = new Point2D.Double(getX(),getY());
      gEnemyNow = project(meNow,enemyAbsBearing,e.getDistance());
      //radar:
      setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsBearing - getRadarHeadingRadians())*2);

      //gun:
      //start a new wave
      double latVel;
      w.enemyClockwise = ( (latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsBearing)) >=0?1:-1);
      //determine firepower
      double firepower;
      w.bulletVelocity = 20.0-3.0*(firepower=(getEnergy()>25 ? 2.0 : 1.0));
      addCustomEvent(w);

      //segmentation
      //int latVelIndex = (int)(Math.abs(latVel)/1.34);
      //int distanceIndex = (int)(e.getDistance()/250.0);
      w.waveGF = gGuessFactors[(int)(Math.abs(latVel)/1.34)][(int)(e.getDistance()/250.0)];

      //determine gun heading
      int bestGF = BINS_MIDDLE;
      //if disabled, then HOT is best:-)
      for (int i = BINS_MINUS1; i >= 0 && e.getEnergy()>0; i--)
         if (w.waveGF[i] > w.waveGF[bestGF])
               bestGF = i;

      //aim the gun
      setTurnGunRightRadians(Utils.normalRelativeAngle( (enemyAbsBearing + (w.enemyClockwise*(w.maxEscapeAngle()/BINS_MIDDLE))*(bestGF-BINS_MIDDLE)) - getGunHeadingRadians() ));

      //fire if can
      if (getGunTurnRemaining()<3 && setFireBullet(firepower+(gCollisions/(5*getRoundNum()+1))) !=null) {
         w.weight = 3.0;
      }

      //movement:
      //Randomly changing turn direction:
      if (Math.random() < 0.08) {
         gMeClockwise *= -1;
      }
      double angle;
      double turnAngle;
      setTurnRightRadians(turnAngle= Math.atan(Math.tan(angle = Utils.normalRelativeAngle(wallSmoothing(meNow,enemyAbsBearing-HALF_PI_PLUS_SOME*gMeClockwise,gMeClockwise) - getHeadingRadians())
                                                       )
                                              )
                         );
      //int direction = angle == turnAngle ? 1 : -1;
      setAhead(Double.POSITIVE_INFINITY * (angle == turnAngle ? 1 : -1));
   }

   //Binsmoothing:don't just register a hit in the perfect bin; let its neighbours get some score too.
   //http://robowiki.net/cgi-bin/robowiki?BinSmoothing
   public void logHit(Wave w) {
      //int binIndex = getFactorIndex(w);
      for (int x = BINS_MINUS1; x >= 0; x--) {
         //w.waveGF[x] = rollingAvg(w.waveGF[x],1/(Math.pow(x - getFactorIndex(w), 2) + 1), w.weight);
         w.waveGF[x]=(w.waveGF[x] * ROLLINGDEPTH + (1/(Math.pow(x - getFactorIndex(w), 2) + 1)) * w.weight)/(ROLLINGDEPTH + w.weight);
      }
   }

   //http://robowiki.net/cgi-bin/robowiki?RollingAverage
   /*
   static double rollingAvg(double value, double newEntry, double weighting ) {
      return (value * ROLLINGDEPTH + newEntry * weighting)/(ROLLINGDEPTH + weighting);
   }
   */

   private int getFactorIndex(Wave w) {
      //angleoffset: difference between bearing from original center to enemyNow and original HOT bearing
      //GF: angleoffset/maxescapeangle
      double guessFactor =
                     (Utils.normalRelativeAngle(Math.atan2(gEnemyNow.x-w.center.x,gEnemyNow.y-w.center.y) - w.enemyAbsBearing) * w.enemyClockwise)
                     /
                     w.maxEscapeAngle();
      //now transform the guessFactor (possible values in interval [-1,1]) to indexes (integers in interval [0,BINS-1])
      return (int)Math.max(Math.min(guessFactor * (BINS_MIDDLE) + (BINS_MIDDLE),BINS_MINUS1),0);
   }

   //Turn further until your "blind man's stick" does not touch the wall anymore
   //http://robowiki.net/cgi-bin/robowiki?WallSmoothing
   private static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
      while (!gFieldRect.contains(project(botLocation, angle, WALL_STICK))) {
         angle += orientation*0.05;
      }
      return angle;
   }

   private static Point2D.Double project(Point2D.Double locNow, double heading, double velocity) {
      return new Point2D.Double(locNow.x + velocity*Math.sin(heading),locNow.y + velocity*Math.cos(heading));
   }

   private class Wave extends Condition {
      public Point2D.Double center;
      public double bulletVelocity;
      public double weight;
      public double[] waveGF;
      public double enemyAbsBearing;
      public int enemyClockwise;

      private double distance;

      public Wave() {
         this.weight = 1.0;
      }

      public double maxEscapeAngle() {
         return Math.asin(8.0/bulletVelocity);
      }

      public boolean test() {
         //its magic, but that's how I got waves hitting closest to real bullets
         if ((distance +=bulletVelocity)>=center.distance(gEnemyNow)-1.4*bulletVelocity)  {
            logHit(this);
            removeCustomEvent(this);
         }
         return false;
      }
   }
}