/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit2002;

import fnc.bandit2002.Position;
import fnc.bandit2002.Util;
import java.io.PrintStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Path {
    final int maxpositions = 40;
    Position max_position;
    Position min_position;
    double vx_min;
    double vy_min;
    double vx_max;
    double vy_max;
    double a_max;
    double a_min;
    Position[] history;
    int top;
    int count;
    public boolean jiggles;
    public boolean linear;
    public boolean angular;
    double width;
    double height;
    double velocity;
    double angular_velocity;
    PrintStream output;

    public Position predictPosition(double arg_gsecs_from_now, double arg_curtime) {
        Position predicted_p;
        Position current_p = this.history[this.top];
        if (this.count > 3) {
            int i = this.top - 1;
            if (i < 0) {
                i += 40;
            }
            Position previous_p = this.history[i];
            double travel_time = arg_gsecs_from_now + (arg_curtime - current_p.t);
            predicted_p = new Position(0.0, 0.0, arg_curtime + arg_gsecs_from_now);
            if (this.linear) {
                predicted_p.x = current_p.x + this.velocity * travel_time * Math.sin(current_p.h);
                predicted_p.y = current_p.y + this.velocity * travel_time * Math.cos(current_p.h);
            } else if (this.angular) {
                double current_heading = Util.normalize2(current_p.h - 1.5707963267948966);
                double predicted_heading = current_heading + this.angular_velocity * travel_time;
                double radius = this.velocity / this.angular_velocity;
                predicted_p.x = current_p.x + Math.sin(predicted_heading) * radius - Math.sin(current_heading) * radius;
                predicted_p.y = current_p.y + Math.cos(predicted_heading) * radius - Math.cos(current_heading) * radius;
            } else if (this.jiggles) {
                double l = this.max_position.distance(this.min_position);
                travel_time = arg_gsecs_from_now + (arg_curtime - this.max_position.t);
                double T = this.max_position.t - this.min_position.t;
                int swings = (int)(travel_time / T);
                double dt = travel_time - T * (double)swings;
                double v = l / T;
                Position real_min_position = new Position(this.min_position);
                int steps = swings / 2 + 1;
                real_min_position.x += (double)steps * this.vx_min;
                real_min_position.y += (double)steps * this.vy_min;
                Position real_max_position = new Position(this.max_position);
                steps = (swings + 1) / 2;
                real_max_position.x += (double)steps * this.vx_max;
                real_max_position.y += (double)steps * this.vy_max;
                if ((swings & 1) == 1) {
                    double bearing = real_min_position.bearing(real_max_position);
                    predicted_p.x = real_min_position.x + v * dt * Math.sin(bearing);
                    predicted_p.y = real_min_position.y + v * dt * Math.cos(bearing);
                } else {
                    double bearing = real_max_position.bearing(real_min_position);
                    predicted_p.x = real_max_position.x + v * dt * Math.sin(bearing);
                    predicted_p.y = real_max_position.y + v * dt * Math.cos(bearing);
                }
            } else {
                this.output.println("!! Unkown movement");
            }
            if (this.linear || this.angular) {
                if (predicted_p.x > this.width) {
                    predicted_p.x = this.width;
                } else if (predicted_p.x < 0.0) {
                    predicted_p.x = 0.0;
                }
                if (predicted_p.y > this.height) {
                    predicted_p.y = this.height;
                } else if (predicted_p.y < 0.0) {
                    predicted_p.y = 0.0;
                }
            }
        } else {
            predicted_p = new Position(current_p);
        }
        return predicted_p;
    }

    public boolean getJiggles() {
        return this.jiggles;
    }

    public void analyse() {
        this.analyseLinear();
    }

    public void analyseLinear() {
        if (this.count > 4) {
            Position p3 = this.history[this.top];
            int i = this.top - 1;
            if (i < 0) {
                i += 40;
            }
            Position p2 = this.history[i];
            i = this.top - 2;
            if (i < 0) {
                i += 40;
            }
            Position p1 = this.history[i];
            i = this.top - 3;
            if (i < 0) {
                i += 40;
            }
            Position p0 = this.history[i];
            double dt0 = p1.t - p0.t;
            double dt1 = p2.t - p1.t;
            double dt2 = p3.t - p2.t;
            double av0 = Util.angular_diff(p0.h, p1.h) / dt0;
            double av1 = Util.angular_diff(p1.h, p2.h) / dt1;
            this.angular_velocity = (av0 + av1) / (double)2;
            this.velocity = (p0.distance(p1) / dt0 + p1.distance(p2) / dt1 + p2.distance(p3) / dt2) / (double)3;
            if (Math.abs(this.angular_velocity) > 0.01) {
                this.angular = true;
                this.linear = false;
            } else {
                this.linear = true;
                this.angular = false;
            }
        }
    }

    public void analyseJiggle() {
        this.jiggles = false;
        if (this.count == 40) {
            int i_next;
            boolean b = false;
            int jiggle_count = 0;
            int i = this.top - 38;
            if (i < 0) {
                i += 40;
            }
            if ((i_next = i + 1) == 40) {
                i_next = 0;
            }
            while (i_next != this.top) {
                double dt = this.history[i_next].t - this.history[i].t;
                double da = Util.angular_diff(this.history[i].h, this.history[i_next].h);
                if (Math.abs(da) > 2.5132741228718345 && Math.abs(da) < 3.7699111843077517) {
                    if (b) {
                        this.a_max = da;
                        this.vx_max = this.history[i].x - this.max_position.x;
                        this.vy_max = this.history[i].y - this.max_position.y;
                        this.max_position.set(this.history[i]);
                        b ^= true;
                        ++jiggle_count;
                    } else {
                        this.a_min = da;
                        this.vx_min = this.history[i].x - this.min_position.x;
                        this.vy_min = this.history[i].y - this.min_position.y;
                        this.min_position.set(this.history[i]);
                        b ^= true;
                        ++jiggle_count;
                    }
                }
                i = i_next++;
                if (i_next != 40) continue;
                i_next = 0;
            }
            if (jiggle_count >= 2) {
                if (this.min_position.t > this.max_position.t) {
                    double temp = this.min_position.x;
                    this.min_position.x = this.max_position.x;
                    this.max_position.x = temp;
                    temp = this.min_position.y;
                    this.min_position.y = this.max_position.y;
                    this.max_position.y = temp;
                    temp = this.min_position.t;
                    this.min_position.t = this.max_position.t;
                    this.max_position.t = temp;
                    temp = this.min_position.h;
                    this.min_position.h = this.max_position.h;
                    this.max_position.h = temp;
                    temp = this.vx_max;
                    this.vx_min = this.vx_max = this.vx_min;
                    temp = this.vy_max;
                    this.vy_min = this.vy_max = this.vy_min;
                    temp = this.a_max;
                    this.a_max = this.a_min;
                    this.a_min = temp;
                }
                if (this.history[this.top].distance(this.max_position) < 1.2 * this.max_position.distance(this.min_position)) {
                    this.jiggles = true;
                    this.linear = false;
                    this.angular = false;
                }
            }
        }
    }

    public void add(Position arg_p) {
        if (arg_p.t != this.history[this.top].t) {
            int new_top = this.top + 1;
            if (new_top >= 40) {
                new_top = 0;
            }
            this.history[new_top] = new Position(arg_p);
            if (this.itMoved(this.history[this.top].x, arg_p.x) || this.itMoved(this.history[this.top].y, arg_p.y)) {
                if (Math.abs(this.history[this.top].bearing(arg_p) - arg_p.h) > 1.2566370614359172) {
                    this.history[new_top].h = Util.normalize2(arg_p.h + Math.PI);
                }
            } else {
                this.history[new_top].h = this.history[this.top].h;
            }
            this.top = new_top;
            if (this.count < 40) {
                ++this.count;
            }
        }
    }

    public final boolean itMoved(double x1, double x2) {
        boolean bl = false;
        if (Math.abs(x1 - x2) > 0.01) {
            bl = true;
        }
        return bl;
    }

    public void dumpAnalysis(PrintStream o) {
        if (this.jiggles) {
            o.print("Jiggles");
            o.println(this.min_position + "  " + this.max_position);
            o.println("period " + Util.round(this.max_position.t - this.min_position.t));
            o.println("v_max (" + Util.round(this.vx_max) + ',' + Util.round(this.vy_max) + ')');
            o.println("v_min (" + Util.round(this.vx_min) + ',' + Util.round(this.vy_min) + ')');
            o.println("a_min " + Util.degrees(this.a_min) + "   a_max " + Util.degrees(this.a_max));
        } else if (this.linear) {
            o.println("linear");
            o.println("velocity " + Util.round(this.velocity));
        } else if (this.angular) {
            o.println("angular");
            o.println("velocity " + Util.round(this.velocity));
            o.println("angular_velocity: " + Util.round(this.angular_velocity));
            o.println("radius " + Util.round(this.velocity / this.angular_velocity));
        }
    }

    public void dump(PrintStream o) {
        int size;
        int i;
        if (this.count < 40) {
            i = 0;
            size = this.count;
        } else {
            i = (this.top + 1) % 40;
            size = 40;
        }
        o.println(this.history[i]);
        i = (i + 1) % 40;
        --size;
        while (size > 0) {
            o.println(this.history[i]);
            i = (i + 1) % 40;
            --size;
        }
    }

    private final /* synthetic */ void this() {
        this.maxpositions = 40;
    }

    public Path(Position arg_p, double arg_w, double arg_h, PrintStream arg_output) {
        this.this();
        this.width = arg_w;
        this.height = arg_h;
        this.output = arg_output;
        this.top = 0;
        this.count = 1;
        this.history = new Position[40];
        this.history[this.top] = new Position(arg_p);
        this.max_position = new Position(arg_p);
        this.min_position = new Position(arg_p);
        this.jiggles = false;
        this.angular = false;
        this.linear = true;
        this.velocity = 0.0;
        this.angular_velocity = 0.0;
    }
}

