/*
 * Decompiled with CFR 0.152.
 */
package pulsar.movement;

import java.util.List;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.movement.AbstractMovement;
import pulsar.util.RobotData;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;

public class RamMovement
extends AbstractMovement {
    private static final String NAME = "Ram Movement";
    private AdvancedRobot robot;
    private static boolean hitWhileRamming = false;
    private static boolean isRamming = false;
    private RobotData lastTarget;

    public String getName() {
        return NAME;
    }

    public double getScore(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        this.robot = robot;
        List waves = (List)wavesMap.get(target.name);
        if (RamMovement.isFinalRammable(robot, target, hitWhileRamming) && waves.size() == 0) {
            isRamming = true;
            return 101.0;
        }
        isRamming = false;
        return 0.0;
    }

    public static boolean isFinalRammable(AdvancedRobot robot, RobotData target, boolean hitWhileRamming) {
        RamMovement.hitWhileRamming = hitWhileRamming || RamMovement.hitWhileRamming;
        return target.isAlive && robot.getOthers() == 1 && target.getValue(target.energy) < 0.01 && !(robot.getEnergy() < 0.7);
    }

    public static boolean hitWhileRamming() {
        return hitWhileRamming;
    }

    public void doMovement(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        this.lastTarget = target;
        robot.setMaxVelocity((double)8);
        double goalDirection = PulsarMax.robotStats.getAbsBearingTo(target, 0);
        this.doMovement(robot, goalDirection, target, radar, wavesMap, false);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (isRamming && e.getName().equals(this.lastTarget.name) && this.lastTarget.getValue(this.lastTarget.energy) > 0.0) {
            hitWhileRamming = true;
        }
    }
}

