/*
 * Decompiled with CFR 0.152.
 */
package cuoq;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Utils {
    public static double cartesianToPolar(double x, double y) {
        return Math.atan2(x, y);
    }

    public static double cartesianToPolar(Point2D.Double point) {
        return Math.atan2(point.x, point.y);
    }

    public static double angleBetweenPoints(Point2D.Double source, Point2D.Double dest) {
        return Utils.cartesianToPolar(dest.x - source.x, dest.y - source.y);
    }

    public static double wallSmoothing(Rectangle2D battlefieldArea, Point2D.Double botLocation, double angle, int orientation) {
        return Utils.wallSmoothing(battlefieldArea, botLocation, angle, orientation, 120);
    }

    public static double wallSmoothing(Rectangle2D battlefieldArea, Point2D.Double botLocation, double angle, int orientation, int wallStick) {
        int count = 0;
        while (!battlefieldArea.contains(Utils.project(botLocation, angle, wallStick)) && count++ < 25) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(Math.sin(angle) * length + sourceLocation.x, Math.cos(angle) * length + sourceLocation.y);
    }

    public static double limit(double min, double number, double max) {
        return Math.max(min, Math.min(number, max));
    }

    public static double getMaximumEscapeArea(double bulletVelocity) {
        return Math.asin(8.0 / bulletVelocity);
    }

    public static double binToGF(int numBins, int bin) {
        int middleBin = (numBins - 1) / 2;
        return (bin - middleBin) / middleBin;
    }

    public static int GFToBin(int numBins, double guessFactor) {
        return (int)Utils.limit(0.0, (double)((numBins - 1) / 2) * guessFactor + (double)((numBins - 1) / 2), numBins - 1);
    }

    public static double normalRelativeAngle(double angle) {
        return robocode.util.Utils.normalRelativeAngle((double)angle);
    }

    public static double normalAbsoluteAngle(double atan2) {
        return robocode.util.Utils.normalAbsoluteAngle((double)atan2);
    }
}

