/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.intel.ChessBoard;
import agd.util.Coord;
import agd.util.CoordInt;
import agd.util.FastGoto;
import agd.util.GotoMethod;
import agd.util.Navigation;
import agd.util.RobotInformation;
import agd.util.World;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class DodgeGoto
extends GotoMethod {
    private int diverseThreshold = 6;
    private GotoMethod subGotoMethod = null;

    public DodgeGoto(Coord destination) {
        super((RobotInformation)World.getAdvancedRobot(), destination);
    }

    public void discard() {
    }

    public String toString() {
        return "DodgeGoto " + this.destination;
    }

    public void setDiverseThreshold(int dt) {
        this.diverseThreshold = dt;
    }

    public Navigation navigate() {
        Coord ourPos = this.robot.getPosition();
        ChessBoard board = ChessBoard.getInstance();
        CoordInt currentPos = board.toCoordInt(ourPos);
        if (this.subGotoMethod == null || this.subGotoMethod.isDone()) {
            CoordInt destPos = board.toCoordInt(this.destination);
            Vector possibleSteps = this.getCandidateSquares(board, currentPos, destPos);
            Collections.sort(possibleSteps, new BestStepComparator(board));
            ChessBoard.ChessSquare nextSquare = (ChessBoard.ChessSquare)possibleSteps.get(0);
            this.subGotoMethod = new FastGoto(this.robot, board.toCoord(nextSquare.getIntPosition()));
            System.out.println("Stepping into square " + nextSquare.getIntPosition() + ":\n" + nextSquare);
        }
        return this.subGotoMethod.navigate();
    }

    Vector getCandidateSquares(ChessBoard board, CoordInt curSquare, CoordInt destSquare) {
        Vector candidates = board.getNeighbours(curSquare, 1);
        candidates.add(board.getSquare(curSquare));
        Collections.sort(candidates, new DistanceComparator(destSquare));
        int idx = candidates.size() - 1;
        while (idx > this.diverseThreshold) {
            candidates.remove(idx);
            --idx;
        }
        return candidates;
    }

    static class BestStepComparator
    implements Comparator {
        ChessBoard board;

        public BestStepComparator(ChessBoard board) {
            this.board = board;
        }

        public int compare(Object o1, Object o2) {
            ChessBoard.ChessSquare sq1 = (ChessBoard.ChessSquare)o1;
            ChessBoard.ChessSquare sq2 = (ChessBoard.ChessSquare)o2;
            if (sq1.getThreatFactor() == sq2.getThreatFactor()) {
                return 0;
            }
            return sq1.getThreatFactor() < sq2.getThreatFactor() ? -1 : 1;
        }
    }

    static class DistanceComparator
    implements Comparator {
        private CoordInt destination;

        public DistanceComparator(CoordInt destination) {
            this.destination = destination;
        }

        public int compare(Object o1, Object o2) {
            double reldist2;
            CoordInt c1 = ((ChessBoard.ChessSquare)o1).getIntPosition();
            CoordInt c2 = ((ChessBoard.ChessSquare)o2).getIntPosition();
            double reldist1 = DistanceComparator.reldist(c1, this.destination);
            if (reldist1 == (reldist2 = DistanceComparator.reldist(c2, this.destination))) {
                return 0;
            }
            return reldist1 < reldist2 ? -1 : 1;
        }

        private static double reldist(CoordInt point1, CoordInt point2) {
            int dx = Math.abs(point1.getX() - point2.getX());
            int dy = Math.abs(point1.getY() - point2.getY());
            return dx * dx + dy * dy;
        }
    }
}

