/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.gun.baseGun;
import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import eem.target.InfoBot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class guessFactorGun
extends baseGun {
    protected double guessFactor;

    public guessFactorGun() {
        this.gunName = "guessFactor";
        this.guessFactor = 0.0;
        this.gunColor = new Color(255, 136, 255, 128);
    }

    public guessFactorGun(EvBot evBot) {
        super(evBot);
        this.gunName = "guessFactor";
        this.guessFactor = 0.0;
        this.gunColor = new Color(255, 136, 255, 128);
        this.calcGunSettings();
    }

    @Override
    public Point2D.Double calcTargetFuturePosition(InfoBot infoBot, double d, InfoBot infoBot2) {
        this.firingBot = infoBot;
        return super.calcTargetFuturePosition(infoBot, d, infoBot2);
    }

    @Override
    protected Point2D.Double calcTargetFuturePosition(Point2D.Double double_, double d, InfoBot infoBot) {
        double d2;
        if (this.firingBot == null) {
            logger.dbg("FIXME: firingBot is not set. This should not happen if I make it right");
            this.firingBot = EvBot._tracker;
        }
        if (!this.gunHasTargetPoint) {
            this.targetFuturePosition = (Point2D.Double)infoBot.getPosition().clone();
            this.gunHasTargetPoint = true;
        }
        this.guessFactor = this.chooseGuessFactor(infoBot);
        double d3 = d2 = double_.distance(infoBot.getPosition());
        double d4 = d2;
        double d5 = math.angle2pt(double_, infoBot.getPosition());
        double d6 = d5 + this.guessFactor * math.calculateMEA(physics.bulletSpeed(d));
        this.targetFuturePosition.x = double_.x + d2 * Math.sin(d6 *= Math.PI / 180);
        this.targetFuturePosition.y = double_.y + d2 * Math.cos(d6);
        return this.targetFuturePosition;
    }

    private double pickGFprobabilisticly(InfoBot infoBot) {
        int n;
        int[] nArray = this.firingBot.getGuessFactorBins(infoBot);
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            d += (double)nArray[n];
        }
        if (d == 0.0) {
            return 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = (double)nArray[n] / d;
        }
        double d2 = Math.random();
        double d3 = 0.0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(d2 <= (d3 += dArray[i]))) continue;
            n3 = i;
            break;
        }
        return math.bin2gf(n3, n2);
    }

    private double pickMostProbableGF(InfoBot infoBot) {
        int[] nArray = this.firingBot.getGuessFactorBins(infoBot);
        int n = nArray.length;
        double[] dArray = new double[n];
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
            n2 = i;
        }
        if (d == 0.0) {
            return 0.0;
        }
        return math.bin2gf(n2, n);
    }

    private double chooseGuessFactor(InfoBot infoBot) {
        return this.pickMostProbableGF(infoBot);
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        super.onPaint(graphics2D);
        int[] nArray = this.firingBot.getGuessFactorBins(this.myBot._trgt);
        int n = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!((double)nArray[i] > d)) continue;
            d = nArray[i];
        }
        double d2 = math.angle2pt(this.myBot.myCoord, this.myBot._trgt.getPosition());
        double d3 = this.myBot.myCoord.distance(this.myBot._trgt.getPosition());
        double d4 = physics.bulletSpeed(this.firePoverVsDistance(d3));
        double d5 = math.calculateMEA(d4);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d6 = Math.max(d3 / 3.0, d3 - 3.5 * (double)this.myBot.robotHalfSize);
        for (int i = 0; i < n; ++i) {
            double d7 = d2 + d5 * math.bin2gf(i, n);
            double_.x = this.myBot.myCoord.x + d6 * Math.sin(d7 / 180.0 * Math.PI);
            double_.y = this.myBot.myCoord.y + d6 * Math.cos(d7 / 180.0 * Math.PI);
            double d8 = 1.0 + (double)(4 * nArray[i]) / Math.max(d, 1.0);
            graphics.drawCircle(graphics2D, double_, d8);
        }
    }
}

