/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.movement.buffers;

import de._4geeks.robots.movement.manager.SurferWave;
import de._4geeks.robots.utils.GuessFactorWindow;
import de._4geeks.robots.utils.Pair;
import de._4geeks.robots.utils.SUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurferSeg {
    private static final double HISTORY = 10.0;
    private double[][][][][] stats1;
    private double[][][][] stats2;
    private double[][][][] stats3;
    private double[][][] stats4;
    private double[][][][] stats5;
    private double[] unseg;
    private int bins;
    private double[] LATERAL_SEG = new double[]{-4.5, -1.5, 1.5, 4.5};
    private double[] ADV_SEG = new double[]{-4.5, -1.5, 1.5, 4.5};
    private double[] DIST_SEG = new double[]{100.0, 200.0, 400.0};
    private double[] DCHANGE_SEG = new double[]{5.0, 10.0, 25.0, 50.0};
    private double[] WALL_SEG = new double[]{70.0, 100.0, 200.0};
    private double[] ACC_SEG = new double[]{-0.5, 0.5};
    private double[] VEL_SEG = new double[]{-4.5, -1.5, 1.5, 4.5};
    private double[] TURN_SEG = new double[]{-Math.toRadians(7.5), -Math.toRadians(2.5), Math.toRadians(2.5), Math.toRadians(7.5)};

    public SurferSeg(int bins) {
        this.bins = bins;
        this.stats1 = new double[this.LATERAL_SEG.length + 1][this.ADV_SEG.length + 1][this.DIST_SEG.length + 1][this.DCHANGE_SEG.length + 1][bins];
        this.stats2 = new double[this.LATERAL_SEG.length + 1][this.DIST_SEG.length + 1][this.WALL_SEG.length + 1][bins];
        this.stats3 = new double[this.LATERAL_SEG.length + 1][this.DIST_SEG.length + 1][this.ACC_SEG.length + 1][bins];
        this.stats4 = new double[this.LATERAL_SEG.length + 1][this.DIST_SEG.length + 1][bins];
        this.stats5 = new double[this.DIST_SEG.length + 1][this.VEL_SEG.length + 1][this.TURN_SEG.length + 1][bins];
        this.unseg = new double[bins];
    }

    public void logHit(SurferWave wave, Point2D.Double loc) {
        int lslice = SUtils.indexSlice(this.LATERAL_SEG, wave.scan.lateralVelocity);
        int aslice = SUtils.indexSlice(this.ADV_SEG, wave.scan.advancingVelocity);
        int dslice = SUtils.indexSlice(this.DIST_SEG, wave.scan.distance);
        int cslice = SUtils.indexSlice(this.DCHANGE_SEG, wave.scan.timeSinceDirChange);
        int wslice = SUtils.indexSlice(this.WALL_SEG, wave.scan.wallDistance);
        int accslice = SUtils.indexSlice(this.ACC_SEG, wave.scan.acceleration);
        int velslice = SUtils.indexSlice(this.VEL_SEG, wave.scan.velocity);
        int turnslice = SUtils.indexSlice(this.TURN_SEG, wave.scan.turning);
        int index = this.getFactorIndex(wave, loc);
        double offsetAngle = SUtils.absoluteBearing(wave.fireLocation, loc) - wave.scan.absBearing + Math.PI;
        double gf = Utils.normalRelativeAngle((double)offsetAngle) / SUtils.maxEscapeAngle(wave.bulletVelocity) * (double)wave.scan.direction;
        GuessFactorWindow window = new GuessFactorWindow(gf, wave.fireLocation.distance(loc), SUtils.maxEscapeAngle(wave.bulletVelocity));
        int i = 0;
        while (i < this.bins) {
            double val = 1.0 / (Math.pow(index - i, 2.0) + 1.0);
            this.stats1[lslice][aslice][dslice][cslice][i] = SUtils.rollingAvg(this.stats1[lslice][aslice][dslice][cslice][i], val, 10.0, 1.0);
            this.stats2[lslice][dslice][wslice][i] = SUtils.rollingAvg(this.stats2[lslice][dslice][wslice][i], val, 10.0, 1.0);
            this.stats3[lslice][dslice][accslice][i] = SUtils.rollingAvg(this.stats2[lslice][dslice][accslice][i], val, 10.0, 1.0);
            this.stats4[lslice][dslice][i] = SUtils.rollingAvg(this.stats4[lslice][dslice][i], val, 10.0, 1.0);
            this.stats5[dslice][velslice][turnslice][i] = SUtils.rollingAvg(this.stats5[dslice][velslice][turnslice][i], val, 10.0, 1.0);
            this.unseg[i] = SUtils.rollingAvg(this.unseg[i], val, 10.0, 1.0);
            ++i;
        }
    }

    public double[] getStats(SurferWave wave) {
        double[] out = new double[this.bins];
        int lslice = SUtils.indexSlice(this.LATERAL_SEG, wave.scan.lateralVelocity);
        int aslice = SUtils.indexSlice(this.ADV_SEG, wave.scan.advancingVelocity);
        int dslice = SUtils.indexSlice(this.DIST_SEG, wave.scan.distance);
        int cslice = SUtils.indexSlice(this.DCHANGE_SEG, wave.scan.timeSinceDirChange);
        int wslice = SUtils.indexSlice(this.WALL_SEG, wave.scan.wallDistance);
        int accslice = SUtils.indexSlice(this.ACC_SEG, wave.scan.acceleration);
        int velslice = SUtils.indexSlice(this.VEL_SEG, wave.scan.velocity);
        int turnslice = SUtils.indexSlice(this.TURN_SEG, wave.scan.turning);
        int i = 0;
        while (i < this.bins) {
            int n = i;
            out[n] = out[n] + this.stats1[lslice][aslice][dslice][cslice][i];
            int n2 = i;
            out[n2] = out[n2] + this.stats2[lslice][dslice][wslice][i];
            int n3 = i;
            out[n3] = out[n3] + this.stats3[lslice][dslice][accslice][i];
            int n4 = i;
            out[n4] = out[n4] + this.stats4[lslice][dslice][i];
            int n5 = i;
            out[n5] = out[n5] + this.stats5[dslice][velslice][turnslice][i];
            int n6 = i;
            out[n6] = out[n6] + this.unseg[i];
            ++i;
        }
        return out;
    }

    public void getDanger(Pair<SurferWave> wave, ArrayList<Point2D.Double> positions, double[] dangerP) {
        int lslice = SUtils.indexSlice(this.LATERAL_SEG, ((SurferWave)wave.item).scan.lateralVelocity);
        int aslice = SUtils.indexSlice(this.ADV_SEG, ((SurferWave)wave.item).scan.advancingVelocity);
        int dslice = SUtils.indexSlice(this.DIST_SEG, ((SurferWave)wave.item).scan.distance);
        int cslice = SUtils.indexSlice(this.DCHANGE_SEG, ((SurferWave)wave.item).scan.timeSinceDirChange);
        int wslice = SUtils.indexSlice(this.WALL_SEG, ((SurferWave)wave.item).scan.wallDistance);
        int accslice = SUtils.indexSlice(this.ACC_SEG, ((SurferWave)wave.item).scan.acceleration);
        int velslice = SUtils.indexSlice(this.VEL_SEG, ((SurferWave)wave.item).scan.velocity);
        int turnslice = SUtils.indexSlice(this.TURN_SEG, ((SurferWave)wave.item).scan.turning);
        double weight = 1.0 / Math.sqrt(wave.val);
        int i = 0;
        while (i < dangerP.length) {
            int index = this.getFactorIndex((SurferWave)wave.item, positions.get(i));
            int n = i;
            dangerP[n] = dangerP[n] + weight * this.stats1[lslice][aslice][dslice][cslice][index];
            int n2 = i;
            dangerP[n2] = dangerP[n2] + weight * this.stats2[lslice][dslice][wslice][index];
            int n3 = i;
            dangerP[n3] = dangerP[n3] + weight * this.stats3[lslice][dslice][accslice][index];
            int n4 = i;
            dangerP[n4] = dangerP[n4] + weight * this.stats4[lslice][dslice][index];
            int n5 = i;
            dangerP[n5] = dangerP[n5] + weight * this.stats5[dslice][velslice][turnslice][index];
            int n6 = i++;
            dangerP[n6] = dangerP[n6] + weight * this.unseg[index];
        }
    }

    public int getFactorIndex(SurferWave ew, Point2D.Double targetLocation) {
        double offsetAngle = SUtils.absoluteBearing(ew.fireLocation, targetLocation) - ew.scan.absBearing + Math.PI;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / SUtils.maxEscapeAngle(ew.bulletVelocity) * (double)ew.scan.direction;
        return (int)SUtils.limit(factor * (double)((this.bins - 1) / 2) + (double)((this.bins - 1) / 2), 0.0, this.bins - 1);
    }
}

