/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.RobotSnapshots;

import java.util.ArrayList;

public class FrequencyValue {
    public double Mean;
    private final int _maxNumValues;
    private long _numTicksSinceLastMark = 0L;
    private ArrayList<RecordedValue> _recordedValues = new ArrayList();

    public FrequencyValue(int maxNumValues) {
        this._maxNumValues = maxNumValues;
    }

    public void Reset() {
        this.Mean = 0.0;
        this._numTicksSinceLastMark = 0L;
        this._recordedValues.clear();
    }

    public void OnTick(boolean mark) {
        ++this._numTicksSinceLastMark;
        if (mark) {
            this._recordedValues.add(new RecordedValue(this._numTicksSinceLastMark));
            this._numTicksSinceLastMark = 0L;
            if (this._recordedValues.size() > this._maxNumValues) {
                this._recordedValues.remove(0);
            }
        }
        this.UpdateFrequency();
    }

    private void UpdateFrequency() {
        long totalTicks = this._numTicksSinceLastMark;
        for (int recordingIndex = 0; recordingIndex < this._recordedValues.size(); ++recordingIndex) {
            RecordedValue recordedValue = this._recordedValues.get(recordingIndex);
            totalTicks += recordedValue.TicksSinceLastMark;
        }
        this.Mean = (double)totalTicks / ((double)this._recordedValues.size() + 1.0);
    }

    private final class RecordedValue {
        public final long TicksSinceLastMark;

        public RecordedValue(long ticksSinceLastMark) {
            this.TicksSinceLastMark = ticksSinceLastMark;
        }
    }
}

