/*
 * Decompiled with CFR 0.152.
 */
package dcs.PM;

import dcs.PM.Stampede_TargetData_Mini;
import java.awt.geom.Point2D;

public class PatternMatchingGun {
    public static final double MAX_TURNRATE = 10.0;
    private String buffer;
    private int maxBufferLength;
    private int maxPatternLength;

    public void update(Stampede_TargetData_Mini newData) {
        this.buffer = this.buffer + this.combineToChar(newData.speed, newData.turnRate());
        if (this.buffer.length() > this.maxBufferLength) {
            this.buffer = this.buffer.substring(1);
        }
    }

    public char combineToChar(double velocity, double headingChange) {
        return (char)((int)(velocity * (double)4 + 32.0) | (int)(headingChange * 3.2 + 32.0) << 8);
    }

    public double[] extractFromChar(char c) {
        return new double[]{(double)(c & 0xFF) / (double)4 - 8.0, (double)(c >> 8) / 3.2 - 10.0};
    }

    public static double bulletPowerToVelocity(double power) {
        return 20.0 - (double)3 * power;
    }

    public static int time(double distance, double velocity) {
        return (int)(distance / velocity);
    }

    public Point2D.Double projectPosition(Stampede_TargetData_Mini target, int startIndex, double bulletPower) {
        Point2D.Double location = new Point2D.Double(target.x, target.y);
        double heading = target.heading;
        int ticks = PatternMatchingGun.time(target.distance, PatternMatchingGun.bulletPowerToVelocity(bulletPower));
        int i = 0;
        while (startIndex + i < this.buffer.length() && i < ticks) {
            double[] data = this.extractFromChar(this.buffer.charAt(startIndex + i));
            heading = Stampede_TargetData_Mini.normalAbsoluteAngle(heading + data[1]);
            location = new Point2D.Double(Stampede_TargetData_Mini.calcX(location.getX(), heading, data[0]), Stampede_TargetData_Mini.calcY(location.getY(), heading, data[0]));
            ++i;
        }
        return location;
    }

    public double computeFiringAngle(Stampede_TargetData_Mini target, double bulletPower, double myX, double myY) {
        int length = Math.min(this.maxPatternLength, Math.min(this.buffer.length() - 1, target.scans));
        int time = (int)(target.distance / PatternMatchingGun.bulletPowerToVelocity(bulletPower));
        if (this.buffer.length() > this.maxPatternLength + time) {
            while (length >= 1) {
                String pattern;
                String searchBuffer = this.buffer.substring(0, this.buffer.length() - length - time);
                int index = searchBuffer.indexOf(pattern = this.buffer.substring(this.buffer.length() - length));
                if (index != -1) {
                    Point2D.Double tempLoc = this.projectPosition(target, index + pattern.length(), bulletPower);
                    return Stampede_TargetData_Mini.absbearing(myX, myY, tempLoc.getX(), tempLoc.getY());
                }
                if (length == 1) break;
                if ((length = (int)((double)length / (double)2)) != 0) continue;
                length = 1;
            }
        }
        return target.bearing;
    }

    public PatternMatchingGun(int maxBuffer, int maxPattern) {
        this.maxBufferLength = maxBuffer;
        this.maxPatternLength = maxPattern;
        this.buffer = new String();
    }
}

