/*
 * Decompiled with CFR 0.152.
 */
package cf.OPs;

import cf.RiO.RiO_GG;
import cf.target;
import cf.util.Calc;
import cf.util.E_Properties;
import cf.util.Operator;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.GunTurnCompleteCondition;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class RiOxM_OP
implements Operator {
    AdvancedRobot bot;
    boolean dodging;
    boolean firing;
    boolean moving;
    double fieldWidth;
    double fieldHeight;
    double border = 40.0;
    Rectangle field;
    E_Properties[] e_p;
    int scanned = 0;
    Point lastMeleePoint;

    public RiOxM_OP(AdvancedRobot bot, boolean dodging, boolean firing, boolean moving) {
        this.bot = bot;
        this.dodging = dodging;
        this.firing = firing;
        this.moving = moving;
        bot.setAdjustRadarForRobotTurn(true);
        bot.setAdjustRadarForGunTurn(true);
        bot.setAdjustGunForRobotTurn(true);
        bot.setColors(new Color(60, 60, 60), Color.yellow, Color.red);
        this.e_p = new E_Properties[bot.getOthers()];
        this.fieldWidth = bot.getBattleFieldWidth();
        this.fieldHeight = bot.getBattleFieldHeight();
        this.field = new Rectangle((int)this.border, (int)this.border, (int)(this.fieldWidth - 2.0 * this.border), (int)(this.fieldHeight - 2.0 * this.border));
    }

    public void work() {
        this.bot.setTurnRadarRight(Double.POSITIVE_INFINITY);
        if (this.bot.getTime() % 5L == 0L || this.bot.getTime() < 10L) {
            this.doMove();
        }
        if (this.bot.getGunHeat() / this.bot.getGunCoolingRate() <= 6.0 && this.bot.getGunTurnRemaining() <= 2.0) {
            this.doFire();
        }
        this.bot.execute();
    }

    public void doMove() {
        if (!this.moving) {
            return;
        }
        Point gt = this.getBestPos();
        if (gt != null) {
            Calc.setGotoRandom(this.bot, gt);
        }
    }

    public void doFire() {
        if (!this.firing) {
            return;
        }
        E_Properties victim = this.getVictim();
        double power = 2.3;
        this.fireAt(RiO_GG.getTarget(victim, (int)this.bot.getTime(), this.bot.getX(), this.bot.getY(), power));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int rno = this.getRobotsNo(e.getName());
        if (rno == -1) {
            rno = this.scanned++;
        }
        double enemyBearing = this.bot.getHeading() + e.getBearing();
        double X = this.bot.getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
        double Y = this.bot.getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));
        this.e_p[rno] = new E_Properties(e.getName(), X, Y, e.getVelocity(), e.getHeading(), e.getEnergy(), (int)this.bot.getTime(), this.e_p[rno]);
    }

    public void end() {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.removeBot(e.getName());
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onWin(WinEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    Point getBestPos() {
        double bestWertung;
        Point me;
        double rx = this.bot.getX();
        double ry = this.bot.getY();
        Point bestPoint = me = new Point((int)rx, (int)ry);
        Point actualPoint = me;
        Point middle = this.getRobotMiddle();
        if (this.lastMeleePoint != null && Calc.distPoints(me, this.lastMeleePoint) > 80.0) {
            bestPoint = this.lastMeleePoint;
            bestWertung = this.getMeleeWertung(this.lastMeleePoint, middle) * 0.95;
        } else {
            bestWertung = 9999999.0;
        }
        int i = 0;
        while (i < 30) {
            while (!this.field.contains(actualPoint = new Point((int)(Math.random() * this.fieldWidth), (int)(Math.random() * this.fieldHeight)))) {
            }
            double wertung = this.getMeleeWertung(actualPoint, middle);
            if (wertung < bestWertung) {
                bestWertung = wertung;
                bestPoint = actualPoint;
            }
            ++i;
        }
        if (bestPoint != me) {
            return bestPoint;
        }
        return null;
    }

    public double getMeleeWertung(Point actualPoint, Point middle) {
        if (actualPoint == null) {
            return 99999.0;
        }
        double distToMiddle = Calc.distPoints(actualPoint, middle);
        double distToNextBot = this.getDistToNextBot(actualPoint);
        double distToWall = Math.min((double)Math.min(actualPoint.x, actualPoint.y), Math.min(this.fieldWidth - (double)actualPoint.x, this.fieldHeight - (double)actualPoint.y));
        double wertung = 10000.0 / (distToMiddle + distToNextBot + distToWall);
        return wertung;
    }

    public double getDistToNextBot(Point me) {
        double returnV = 99999.0;
        int i = 0;
        while (i < this.e_p.length) {
            double d;
            if (this.e_p[i] != null && (d = Calc.distPoints(me, new Point((int)this.e_p[i].getX(), (int)this.e_p[i].getY()))) < returnV) {
                returnV = d;
            }
            ++i;
        }
        return returnV;
    }

    public Point getRobotMiddle() {
        int bts = 0;
        double sumx = 0.0;
        double sumy = 0.0;
        int i = 0;
        while (i < this.e_p.length) {
            if (this.e_p[i] != null) {
                sumx += this.e_p[i].getX();
                sumy += this.e_p[i].getY();
                ++bts;
            }
            ++i;
        }
        return new Point((int)(sumx / (double)bts), (int)(sumy / (double)bts));
    }

    public void removeBot(String name) {
        int i = 0;
        while (i < this.e_p.length) {
            if (this.e_p[i] != null && this.e_p[i].name.equals(name)) {
                this.e_p[i] = null;
            }
            ++i;
        }
    }

    public int getRobotsNo(String name) {
        int i = 0;
        while (i < this.e_p.length) {
            if (this.e_p[i] != null && this.e_p[i].name.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    E_Properties getVictim() {
        E_Properties best = this.e_p[0];
        double nD = 9.9999999E7;
        int i = 0;
        while (i < this.e_p.length) {
            if (this.e_p[i] != null) {
                Point2D.Double double_ = new Point2D.Double(this.bot.getX(), this.bot.getY());
                if (Calc.distPoints(this.e_p[i].pos, double_) < nD) {
                    nD = Calc.distPoints(this.e_p[i].pos, new Point2D.Double(this.bot.getX(), this.bot.getY()));
                    best = this.e_p[i];
                }
            }
            ++i;
        }
        return best;
    }

    void fireAt(target t) {
        double power = t.Diffc;
        if (power > 3.0) {
            power = 3.0;
        }
        if (power < 0.0 || this.bot.getEnergy() - power < 0.2) {
            return;
        }
        double angle = Calc.angle(t.X - this.bot.getX(), t.Y - this.bot.getY());
        this.bot.setTurnGunRight(Calc.normalRelativeAngle(angle - this.bot.getGunHeading()));
        this.bot.waitFor((Condition)new GunTurnCompleteCondition(this.bot));
        this.bot.setFire(power);
    }
}

