/*
 * Decompiled with CFR 0.152.
 */
package ary;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.util.Utils;

public class SMG
extends AdvancedRobot {
    public static int BINS = 47;
    public static final int LAT_VEL_SEGS = 4;
    public static final int DIST_SEGS = 5;
    public static final int TIME_SINCE_DIR_CHANGE_SEGS = 3;
    public static double[][][][] _surfTotal = new double[3][5][4][BINS];
    public static double[][][] _surfReduced = new double[5][4][BINS];
    public static double[][] _surfMoreReduced = new double[4][BINS];
    public static double[] noSegStats = new double[BINS];
    public static double _oppEnergy = 100.0;
    public static int dir = 1;
    public static double goAngle;
    public static Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;
    static final int GF_ZERO = 15;
    static final int GF_ONE = 30;
    static double bearingDirection;
    static double lastLatVel;
    static double lastVelocity;
    static double lastReverseTime;
    static double circleDir;
    static double enemyFirePower;
    static double lastVChangeTime;
    static double enemyLatVel;
    static double enemyVelocity;
    static double enemyFireTime;
    static double numBadHits;
    public static double[][][][][][][] fastFactors;
    public static double[][][][][][][] guessFactors;
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    public ArrayList Distances;
    public ArrayList LatVelocities;

    public void run() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.Distances = new ArrayList();
        this.LatVelocities = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setColors(Color.green.darker().darker().darker(), Color.green.darker().darker(), Color.green.darker(), Color.white, Color.white);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * (double)2);
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        this.Distances.add(0, new Double(e.getDistance()));
        this.LatVelocities.add(0, new Double(lateralVelocity));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = SMG.bulletVelocity(bulletPower);
            ew.distanceTraveled = SMG.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            ew._surfStats = _surfTotal[this.sign((Double)this.LatVelocities.get(3) - (Double)this.LatVelocities.get(2)) + 1][(int)((Double)this.Distances.get(2) * 0.0)][(int)(Math.abs((Double)this.LatVelocities.get(2)) + 1.0) / 3];
            ew._surfReduced = _surfReduced[(int)((Double)this.Distances.get(2) * 0.0)][(int)(Math.abs((Double)this.LatVelocities.get(2)) + 1.0) / 3];
            ew._surfMoreReduced = _surfMoreReduced[(int)(Math.abs((Double)this.LatVelocities.get(2)) + 1.0) / 3];
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = SMG.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        Wave w = new Wave();
        lastLatVel = enemyLatVel;
        lastVelocity = enemyVelocity;
        enemyVelocity = e.getVelocity();
        enemyLatVel = enemyVelocity * Math.sin(e.getHeadingRadians() - absBearing);
        int distanceIndex = (int)e.getDistance() / 140;
        int distanceIndexfast = (int)e.getDistance() / 200;
        bulletPower = Math.min(e.getEnergy() / (double)4, distanceIndex == 0 ? (double)3 : (double)2 - Math.max(0.0, (30.0 - this.getEnergy()) / 16.0));
        this.addCustomEvent(w);
        w.bulletVelocity = 20.0 - (double)3 * bulletPower;
        int accelIndex = (int)Math.round(Math.abs(enemyLatVel) - Math.abs(lastLatVel));
        if (enemyLatVel != 0.0) {
            bearingDirection = enemyLatVel > 0.0 ? 1 : -1;
        }
        w.bearingDirection = bearingDirection * Math.asin(8.0 / w.bulletVelocity) / 15.0;
        double d = lastVChangeTime;
        lastVChangeTime = d + 1.0;
        double moveTime = w.bulletVelocity * d / e.getDistance();
        int n = 1;
        if (!(moveTime < 0.1)) {
            if (moveTime < 0.3) {
                n = 2;
            } else {
                int n2 = 0;
                if (moveTime < 1.0) {
                    n2 = 1;
                }
                n = 4 - n2;
            }
        }
        int bestGF = n;
        int vIndex = (int)Math.abs(enemyLatVel / (double)3);
        int vIndexfast = (int)Math.abs(enemyLatVel / (double)4);
        if (Math.abs(Math.abs(enemyVelocity) - Math.abs(lastVelocity)) > 0.6) {
            lastVChangeTime = 0.0;
            bestGF = 0;
            accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastVelocity));
            vIndex = (int)Math.abs(enemyVelocity / (double)3);
        }
        if (accelIndex != 0) {
            int n3 = 0;
            if (accelIndex > 0) {
                n3 = 1;
            }
            accelIndex = 2 - n3;
        }
        w.firePosition = this._myLocation;
        w.enemyAbsBearing = absBearing;
        double[][][][] dArray = guessFactors[accelIndex][bestGF][vIndex];
        int n4 = 0;
        if (!_fieldRect.contains(SMG.project(this._myLocation, absBearing + w.bearingDirection * 15.0, e.getDistance()))) {
            n4 = 2 - _fieldRect.contains(SMG.project(this._myLocation, absBearing + 0.5 * w.bearingDirection * 15.0, e.getDistance()));
        }
        double[][][] dArray2 = dArray[n4];
        int n5 = 0;
        if (!_fieldRect.contains(SMG.project(this._myLocation, absBearing - w.bearingDirection * 15.0, e.getDistance()))) {
            n5 = 2 - _fieldRect.contains(SMG.project(this._myLocation, absBearing - 0.5 * w.bearingDirection * 15.0, e.getDistance()));
        }
        w.waveGuessFactors = dArray2[n5][distanceIndex];
        w.fastGuessFactors = fastFactors[accelIndex][bestGF][vIndexfast][1 - _fieldRect.contains(SMG.project(this._myLocation, absBearing + w.bearingDirection * 15.0, e.getDistance()))][1 - _fieldRect.contains(SMG.project(this._myLocation, absBearing - w.bearingDirection * 15.0, e.getDistance()))][distanceIndexfast];
        bestGF = 15;
        int gf = 30;
        while (gf >= 0 && e.getEnergy() > 0.0) {
            if (w.fastGuessFactors[gf] / (double)3 + w.waveGuessFactors[gf] > w.fastGuessFactors[bestGF] / (double)3 + w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + w.bearingDirection * (double)(bestGF - 15))));
        if (this.getEnergy() - bulletPower > 0.0 || distanceIndex == 0) {
            this.setFire(bulletPower);
        }
    }

    static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public EnemyWave getSecondWave() {
        EnemyWave nearest = this.getClosestSurfableWave();
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance && ew != nearest) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = SMG.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / SMG.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)SMG.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = SMG.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            SMG.noSegStats[x] = SMG.rollingAvg(noSegStats[x], 1.0 / (1.0 + Math.pow(Math.abs(index - x), 2)), 0.95, 1.0);
            ew._surfStats[x] = SMG.rollingAvg(ew._surfStats[x], 1.0 / (1.0 + Math.pow(Math.abs(index - x), 2)), 0.7, 1.0);
            ew._surfReduced[x] = SMG.rollingAvg(ew._surfReduced[x], 1.0 / (1.0 + Math.pow(Math.abs(index - x), 2)), 0.7, 1.0);
            ew._surfReduced[x] = SMG.rollingAvg(ew._surfStats[x], 1.0 / (1.0 + Math.pow(Math.abs(index - x), 2)), 0.7, 1.0);
            ++x;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        _oppEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onBulletHitBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(SMG.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("Turn Skipped");
    }

    public void onHitByBullet(HitByBulletEvent e) {
        _oppEnergy += e.getBullet().getPower() * (double)3;
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(SMG.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double angle = SMG.absoluteBearing(surfWave.fireLocation, predictedPosition);
            if (direction == 0) {
                angle += this.offset();
            }
            double moveAngle = this.wallSmoothing(predictedPosition, angle + (double)direction * this.offset(), direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - (double)3 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + SMG.limit(-maxTurning, moveAngle, maxTurning)));
            if (direction == 0) {
                if (Math.abs(predictedVelocity += (double)(predictedVelocity < 0.0 ? 2 : -2)) < (double)2) {
                    predictedVelocity = 0.0;
                    intercepted = true;
                }
            } else {
                predictedVelocity += predictedVelocity * moveDir < 0.0 ? (double)2 * moveDir : moveDir;
                predictedVelocity = SMG.limit(-8.0, predictedVelocity, 8.0);
            }
            predictedPosition = SMG.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            int maxx = (int)Math.min(this.getBattleFieldWidth(), predictedPosition.x + 18.0);
            int maxy = (int)Math.min(this.getBattleFieldHeight(), predictedPosition.y + 18.0);
            int minx = (int)Math.max(0.0, predictedPosition.x - 18.0);
            int miny = (int)Math.max(0.0, predictedPosition.y - 18.0);
            int x = minx;
            while (x <= maxx) {
                int y = miny;
                while (y <= maxy) {
                    Point2D.Double temp = new Point2D.Double(x, y);
                    if (temp.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity) {
                        intercepted = true;
                    }
                    ++y;
                }
                ++x;
            }
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, Point2D.Double position) {
        int index = SMG.getFactorIndex(surfWave, position);
        return (surfWave._surfStats[index] * 1.2 + surfWave._surfReduced[index]) / (position.distanceSq(this._enemyLocation) + 1.0);
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            double v2;
            double absBearing = SMG.absoluteBearing(this._myLocation, this._enemyLocation);
            double headingRadians = this.getHeadingRadians();
            double stick = 160.0;
            double offset = 1.3707963267948966;
            while (!_fieldRect.contains(SMG.project(this._myLocation, v2 = absBearing + (double)dir * (offset -= 0.02), stick))) {
            }
            if (offset < 1.0471975511965976 || Math.random() < 0.05 && this._myLocation.distance(this._enemyLocation) > 300.0) {
                dir = -dir;
            }
            this.setAhead(50.0 * Math.cos(v2 - headingRadians));
            this.setTurnRightRadians(Math.tan(v2 - headingRadians));
        } else {
            double dangerLeft = this.checkDanger(surfWave, this.predictPosition(surfWave, -1));
            double dangerRight = this.checkDanger(surfWave, this.predictPosition(surfWave, 1));
            double dangerStop = this._myLocation.distance(this._enemyLocation) < 400.0 ? Double.POSITIVE_INFINITY : this.checkDanger(surfWave, this.predictPosition(surfWave, 0));
            EnemyWave secondWave = this.getSecondWave();
            if (secondWave != null) {
                dangerLeft += this.checkDanger(secondWave, this.predictPosition(surfWave, -1)) / (double)2;
                dangerRight += this.checkDanger(secondWave, this.predictPosition(surfWave, 1)) / (double)2;
            }
            goAngle = SMG.absoluteBearing(surfWave.fireLocation, this._myLocation);
            dir = this.sign(dangerLeft - dangerRight);
            goAngle = this.wallSmoothing(this._myLocation, goAngle + (double)dir * this.offset(), dir);
            if (dangerStop + 0.2 < Math.min(dangerRight, dangerLeft)) {
                this.setMaxVelocity(0.0);
            } else {
                this.setMaxVelocity(8.0);
            }
            goAngle = Utils.normalRelativeAngle((double)(goAngle - this.getHeadingRadians()));
            this.setAhead(Math.cos(goAngle) * Double.POSITIVE_INFINITY);
            this.setTurnRightRadians(Math.tan(goAngle));
        }
    }

    private final int sign(double a) {
        return a < 0.0 ? -1 : 1;
    }

    private final double sqr(double x) {
        return x * x;
    }

    public double offset() {
        return 1.9707963267948965 - 190.0 / this._myLocation.distance(this._enemyLocation);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        if (orientation == 0) {
            orientation = dir;
        }
        while (!_fieldRect.contains(SMG.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - (double)3 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(i);
            Point2D.Double center = ew.fireLocation;
            int radius = (int)ew.distanceTraveled;
            double max = 0.0;
            int x = 0;
            while (x < BINS) {
                if (ew._surfStats[x] > max) {
                    max = ew._surfStats[x];
                }
                ++x;
            }
            double MEA = SMG.maxEscapeAngle(ew.bulletVelocity);
            int j = 0;
            while (j < BINS) {
                double thisDanger = ew._surfStats[j] / max;
                g.setColor(Color.blue);
                if (thisDanger > 0.1) {
                    g.setColor(Color.green);
                }
                if (thisDanger > 0.3) {
                    g.setColor(Color.yellow);
                }
                if (thisDanger > 0.6) {
                    g.setColor(Color.orange);
                }
                if (thisDanger > 0.9) {
                    g.setColor(Color.red);
                }
                double angle = ew.directAngle + (double)(ew.direction * (j - (BINS - 1) / 2)) * MEA / (double)((BINS - 1) / 2);
                Point2D.Double thisPoint = SMG.project(ew.fireLocation, angle, radius);
                g.drawOval((int)(thisPoint.x - 1.0), (int)(thisPoint.y - 1.0), 2, 2);
                if (ew == this.getClosestSurfableWave()) {
                    g.drawOval((int)(thisPoint.x - (double)2), (int)(thisPoint.y - (double)2), 4, 4);
                }
                ++j;
            }
            ++i;
        }
        g.setColor(Color.WHITE);
        g.drawString("Blue: safe", 20, 80);
        g.drawString("Green: slightly dangerous", 20, 65);
        g.drawString("Yellow: quite dangerous", 20, 50);
        g.drawString("Orange: dangerous", 20, 35);
        g.drawString("Red: very dangerous", 20, 20);
        g.setColor(Color.blue);
        g.fillOval(5, 80, 10, 10);
        g.setColor(Color.green);
        g.fillOval(5, 65, 10, 10);
        g.setColor(Color.yellow);
        g.fillOval(5, 50, 10, 10);
        g.setColor(Color.orange);
        g.fillOval(5, 35, 10, 10);
        g.setColor(Color.red);
        g.fillOval(5, 20, 10, 10);
    }

    static {
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        WALL_STICK = 160.0;
        bearingDirection = 1.0;
        circleDir = 1.0;
        fastFactors = new double[3][5][3][3][3][8][31];
        guessFactors = new double[3][5][3][3][3][8][31];
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
        double[] _surfStats;
        double[] _surfReduced;
        double[] _surfMoreReduced;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Wave
    extends Condition {
        Point2D.Double firePosition;
        double[] waveGuessFactors;
        double[] fastGuessFactors;
        double enemyAbsBearing;
        double distance;
        double bearingDirection;
        double bulletVelocity;

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (SMG.this._enemyLocation.distance(this.firePosition) <= d + this.bulletVelocity) {
                try {
                    int index = (int)Math.round(Utils.normalRelativeAngle((double)(SMG.absoluteBearing(this.firePosition, SMG.this._enemyLocation) - this.enemyAbsBearing)) / this.bearingDirection + 15.0);
                    this.waveGuessFactors[index] = SMG.rollingAvg(this.waveGuessFactors[index], 1.0, 0.7, 1.0);
                    this.fastGuessFactors[index] = SMG.rollingAvg(this.fastGuessFactors[index], 1.0, 0.7, 1.0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                SMG.this.removeCustomEvent(this);
            }
            return false;
        }

        Wave() {
        }
    }
}

