/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun.patternrecognition;

import florent.XSeries.Configuration;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.XPoint;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class Scan
implements Serializable {
    private static final long serialVersionUID = 620106532250750982L;
    protected static final double NOVALUE = -10000.0;
    private static final double MAXVEL = 8.0;
    private static double D = 500.0 * Math.sqrt(2.0);
    private static final double D15 = 240.0;
    private static final double D30 = 480.0;
    private static final double D60 = 960.0;
    private static final double D120 = 1920.0;
    private static final double ANGLE = Math.PI;
    private static double DWALL = 500.0;
    private static double DCENTER = 500.0 * Math.sqrt(2.0);
    private static double OTHERS = 9.0;
    private static final double TIMER = 40.0;
    private static double RUN = 320.0;
    private static double WALLINDEX = 2.0;
    private static double GUNHEAT = 1.6;
    private static final double F_ANGLE = 8.0;
    private static final double F_VEL = 16.0;
    private static final double F_D = 16.0;
    private static final double F_D15 = 8.0;
    private static final double F_D30 = 4.0;
    private static final double F_D60 = 2.0;
    private static final double F_D120 = 1.0;
    private static final double F_DWALL = 0.0;
    private static final double F_DCENTER = 0.0;
    private static final double F_OTHERS = 0.0;
    private static final double F_TIMER = 16.0;
    private static final double F_RUN = 8.0;
    private static final double F_WALLINDEX = 4.0;
    private static final double F_WALLINDEXREVERSE = 4.0;
    private static final double F_GUNHEAT = 0.0;
    private static final double F_ANGLE_SURF = 2.0;
    private static final double F_VEL_SURF = 4.0;
    private static final double F_D_SURF = 4.0;
    private static final double F_D15_SURF = 0.0;
    private static final double F_D30_SURF = 0.0;
    private static final double F_D60_SURF = 0.0;
    private static final double F_D120_SURF = 0.0;
    private static final double F_DWALL_SURF = 0.0;
    private static final double F_DCENTER_SURF = 0.0;
    private static final double F_TIMER_SURF = 2.0;
    private static final double F_RUN_SURF = 0.0;
    private static final double F_WALLINDEX_SURF = 4.0;
    private static final double F_WALLINDEXREVERSE_SURF = 2.0;
    private static final double F_GUNHEAT_SURF = 0.0;
    private static final double F_ACCEL_SURF = 4.0;
    private static final double F_LAST_TIMER_SURF = 2.0;
    private static final double F_D4_SURF = 1.0;
    private static final double F_D8_SURF = 1.0;
    private static final double F_D16_SURF = 1.0;
    private static final double F_D32_SURF = 1.0;
    private static final double F_LATVEL_SURF = 0.0;
    private static final double F_ANGLE_MELEE = 32.0;
    private static final double F_VEL_MELEE = 64.0;
    private static final double F_D_MELEE = 0.0;
    private static final double F_D15_MELEE = 1.0;
    private static final double F_D30_MELEE = 1.0;
    private static final double F_D60_MELEE = 1.0;
    private static final double F_D120_MELEE = 1.0;
    private static final double F_DWALL_MELEE = 32.0;
    private static final double F_DCENTER_MELEE = 0.0;
    private static final double F_OTHERS_MELEE = 0.0;
    private static final double F_TIMER_MELEE = 0.0;
    private static final double F_RUN_MELEE = 0.0;
    private static final double F_WALLINDEX_MELEE = 0.0;
    private static final double F_WALLINDEXREVERSE_MELEE = 0.0;
    private static final double F_GUNHEAT_MELEE = 0.0;
    public static double REJECTDIFF = 71.0;
    public double distance15;
    public double distance30;
    public double distance60;
    public double distance120;
    public double distance;
    public double distanceWall;
    public double distanceCenter;
    public double angle;
    public double velocity;
    public double others;
    public Force lastMove;
    public double diffValue;
    public double diffValueGH;
    public double time;
    public double heading;
    public double correctedHeading;
    public double absoluteBearing;
    public int positionIndex;
    public double timeSinceStop;
    public double runDist;
    public double wallIndex;
    public double wallIndexReverse;
    public double gunHeat;
    public Scan prec;
    public Scan next;
    public XPoint point;
    public Point2D.Double projection;
    public double cumul2;
    public double cumul4;
    public double cumul8;
    public double cumul16;
    public double cumul32;
    public double accel;
    public double lateralVelocity;
    public double lastTimer;
    public double normalizedVelocity;
    public double normalizedDistance;

    public static void initClass() {
        DWALL = Math.max(Configuration.battleFieldHeigth / 2.0, Configuration.battleFieldWidth / 2.0);
        D = Math.sqrt(Math.pow(Configuration.battleFieldHeigth, 2.0) + Math.pow(Configuration.battleFieldWidth, 2.0));
        DCENTER = D / 2.0;
        OTHERS = Configuration.others;
        REJECTDIFF = 71.0;
    }

    public double diff(Scan scan, boolean GH) {
        double val = 0.0;
        if (Configuration.others > 1) {
            val += Scan.sqr(this.cumul2 - scan.cumul2) * 4.0;
            val += Scan.sqr(this.cumul4 - scan.cumul4) * 4.0;
            val += Scan.sqr(this.normalizedVelocity - scan.normalizedVelocity) * 16.0;
            val += Scan.sqr(this.wallIndex - scan.wallIndex) * 4.0;
            val += Scan.sqr(this.wallIndexReverse - scan.wallIndexReverse) * 4.0;
            val += Scan.sqr(this.accel - scan.accel);
        } else {
            val += Scan.sqr(this.cumul2 - scan.cumul2);
            val += Scan.sqr(this.cumul4 - scan.cumul4);
            val += Scan.sqr(this.cumul8 - scan.cumul8);
            val += Scan.sqr(this.cumul16 - scan.cumul16);
            val += Scan.sqr(this.cumul32 - scan.cumul32);
            val += Scan.sqr(this.normalizedDistance - scan.normalizedDistance);
            val += Scan.sqr(this.normalizedVelocity - scan.normalizedVelocity);
            val += Scan.sqr(this.angle - scan.angle);
            val += Scan.sqr(this.wallIndex - scan.wallIndex);
            val += Scan.sqr(this.wallIndexReverse - scan.wallIndexReverse);
            val += Scan.sqr(this.accel - scan.accel);
            val += Scan.sqr(this.lastTimer - scan.lastTimer);
            val += Scan.sqr(this.timeSinceStop - scan.timeSinceStop);
            val += Scan.sqr(this.runDist - scan.runDist) * 0.0;
        }
        return val;
    }

    public double diff(Scan scan, double[] factors) {
        double val = 0.0;
        if (Configuration.others > 1) {
            val += Scan.sqr(this.cumul2 - scan.cumul2) * 4.0;
            val += Scan.sqr(this.cumul4 - scan.cumul4) * 4.0;
            val += Scan.sqr(this.normalizedVelocity - scan.normalizedVelocity) * 16.0;
            val += Scan.sqr(this.wallIndex - scan.wallIndex) * 4.0;
            val += Scan.sqr(this.wallIndexReverse - scan.wallIndexReverse) * 4.0;
            val += Scan.sqr(this.accel - scan.accel);
        } else {
            val += Scan.sqr(this.normalizedDistance - scan.normalizedDistance) / (1.0 - factors[0]);
            val += Scan.sqr(this.cumul2 - scan.cumul2) / (1.0 - factors[1]);
            val += Scan.sqr(this.cumul4 - scan.cumul4) / (1.0 - factors[2]);
            val += Scan.sqr(this.cumul8 - scan.cumul8) / (1.0 - factors[3]);
            val += Scan.sqr(this.cumul16 - scan.cumul16) / (1.0 - factors[4]);
            val += Scan.sqr(this.cumul32 - scan.cumul32) / (1.0 - factors[5]);
            val += Scan.sqr(this.accel - scan.accel) / (1.0 - factors[6]);
            val += Scan.sqr(this.normalizedVelocity - scan.normalizedVelocity) / (1.0 - factors[7]);
            val += Scan.sqr(this.angle - scan.angle) / (1.0 - factors[8]);
            val += Scan.sqr(this.wallIndex - scan.wallIndex) / (1.0 - factors[9]);
            val += Scan.sqr(this.wallIndexReverse - scan.wallIndexReverse) / (1.0 - factors[10]);
            val += Scan.sqr(this.lastTimer - scan.lastTimer) / (1.0 - factors[11] + 0.1);
        }
        return val;
    }

    private static final double sqr(double val) {
        return val * val;
    }
}

