/*
 * Decompiled with CFR 0.152.
 */
package sadoner;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import sadoner.Enemigo;

public class killer
extends AdvancedRobot {
    private Enemigo enemigo;
    private int hits = 0;
    private int direccion = 1;
    private double potencia;
    private static final int nEnemy = 15;
    private static final int tInicial = 90;
    private static final double dInicial = 300.0;
    static Point2D.Double[] enemyPoints = new Point2D.Double[15];
    static ArrayList<String> enemyNames = new ArrayList();
    private int enemyCount = 0;

    public void run() {
        Color radarColor;
        Color gunColor;
        Color bodyColor;
        if (Math.random() < 0.5) {
            bodyColor = Color.GREEN;
            gunColor = Color.RED;
            radarColor = Color.MAGENTA;
        } else {
            bodyColor = Color.DARK_GRAY;
            gunColor = Color.WHITE;
            radarColor = Color.RED;
        }
        this.setColors(bodyColor, gunColor, radarColor, Color.YELLOW, Color.LIGHT_GRAY);
        this.enemigo = new Enemigo();
        this.enemigo.distancia = Double.POSITIVE_INFINITY;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.movimiento();
            this.potencia();
            this.escaner();
            this.target();
            this.fuego();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        double posX = this.getX() + e.getDistance() * Math.sin(absBearing);
        double posY = this.getY() + e.getDistance() * Math.cos(absBearing);
        if (!enemyNames.contains(e.getName())) {
            enemyNames.add(this.enemyCount, e.getName());
            killer.enemyPoints[this.enemyCount] = new Point2D.Double(posX, posY);
            if (++this.enemyCount >= this.getOthers()) {
                this.enemyCount = 0;
            }
        } else {
            killer.enemyPoints[killer.enemyNames.indexOf((Object)e.getName())] = new Point2D.Double(posX, posY);
        }
        if (e.getDistance() < this.enemigo.distancia || this.enemigo.nombre == e.getName()) {
            this.enemigo.lastHead = this.enemigo.nombre != e.getName() ? e.getHeadingRadians() : this.enemigo.head;
            this.enemigo.nombre = e.getName();
            this.enemigo.bearing = e.getBearingRadians();
            this.enemigo.head = e.getHeadingRadians();
            this.enemigo.tiempo = this.getTime();
            this.enemigo.velocidad = e.getVelocity();
            this.enemigo.distancia = e.getDistance();
            this.enemigo.energia = e.getEnergy();
            this.enemigo.x = posX;
            this.enemigo.y = posY;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.enemigo.nombre) {
            this.enemigo.distancia = Double.POSITIVE_INFINITY;
            this.enemigo.nombre = "";
            this.turnRadarLeft(360.0);
        }
        if (enemyNames.contains(e.getName())) {
            killer.enemyPoints[killer.enemyNames.indexOf((Object)e.getName())] = new Point2D.Double();
            enemyNames.remove(enemyNames.indexOf(e.getName()));
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.getName() != this.enemigo.nombre) {
            this.enemigo.distancia = Double.POSITIVE_INFINITY;
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++this.hits;
    }

    public void onHitWall(HitWallEvent e) {
        this.direccion *= -1;
    }

    public void onWin(WinEvent e) {
        while (true) {
            this.setTurnRight(1000.0);
            this.setTurnRadarLeft(1000.0);
            this.setTurnGunLeft(1000.0);
            this.setAhead(0.0);
            this.execute();
        }
    }

    private void movimiento() {
        double dirObjetivo;
        double absBearing;
        if (this.enemigo.distancia < 300.0) {
            if (this.getTime() % 20L == 0L && this.hits > 4) {
                if (this.getTime() % 60L == 0L) {
                    this.hits = 0;
                } else {
                    this.direccion *= -1;
                }
            }
            if (Math.random() < 0.5 && this.getTime() % 5L == 0L) {
                this.direccion *= -1;
            }
        } else if (this.getTime() % 30L == 0L) {
            this.direccion *= -1;
        }
        if (this.getTime() > 90L || this.getOthers() == 1) {
            absBearing = this.absBearing(this.getX(), this.getY(), this.enemigo.x, this.enemigo.y);
            dirObjetivo = this.enemigo.distancia < 300.0 ? absBearing - 1.5707963267948966 * (double)this.direccion : absBearing - 0.7853981633974483 * (double)this.direccion;
        } else {
            double xFuerza = 0.0;
            double yFuerza = 0.0;
            int i = 0;
            while (i < this.getOthers() && enemyPoints[i] != null) {
                absBearing = this.absBearing(this.getX(), this.getY(), killer.enemyPoints[i].x, killer.enemyPoints[i].y);
                double distance = enemyPoints[i].distance(this.getX(), this.getY());
                xFuerza -= Math.sin(absBearing) / (distance * distance);
                yFuerza -= Math.cos(absBearing) / (distance * distance);
                ++i;
            }
            dirObjetivo = Math.atan2(xFuerza, yFuerza);
        }
        Rectangle2D.Double campo = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        while (!campo.contains(this.getX() + Math.sin(dirObjetivo) * 150.0, this.getY() + Math.cos(dirObjetivo) * 150.0)) {
            dirObjetivo += (double)this.direccion * 0.1;
        }
        double giroFinal = Utils.normalRelativeAngle((double)(dirObjetivo - this.getHeadingRadians()));
        if (Math.abs(giroFinal) > 1.5707963267948966) {
            giroFinal = Utils.normalRelativeAngle((double)(giroFinal + Math.PI));
            this.setBack(100.0);
        } else {
            this.setAhead(100.0);
        }
        this.setTurnRightRadians(giroFinal);
    }

    private void potencia() {
        this.potencia = this.getTime() < 90L ? (this.enemigo.distancia < 300.0 ? 3.0 : 0.1) : (this.enemigo.energia + 2.0) / 6.0;
        if (this.getEnergy() < 10.0) {
            this.potencia = this.getEnergy() / 10.0;
        }
        if (this.getEnergy() < 0.3) {
            this.potencia = this.enemigo.energia > 0.1 ? 0.0 : 0.1;
        }
        if (this.potencia > 3.0) {
            this.potencia = 3.0;
        }
    }

    private void escaner() {
        double barridoExtra;
        barridoExtra = (double)this.getTime() - this.enemigo.tiempo > 5.0 ? 360.0 : ((barridoExtra = this.getRadarHeadingRadians() - this.absBearing(this.getX(), this.getY(), this.enemigo.x, this.enemigo.y)) < 0.0 ? (barridoExtra -= 0.3141592653589793) : (barridoExtra += 0.3141592653589793));
        this.setTurnRadarLeftRadians(Utils.normalRelativeAngle((double)barridoExtra));
        if (this.getTime() % 70L == 0L && this.getOthers() > 1) {
            this.turnRadarLeft(360.0);
        }
    }

    private void target() {
        Point2D.Double p = new Point2D.Double(this.enemigo.x, this.enemigo.y);
        int i = 0;
        while (i < 10) {
            long nextTime = Math.round(this.distancia(this.getX(), this.getY(), p.x, p.y) / (20.0 - 3.0 * this.potencia));
            long time = this.getTime() + nextTime;
            p = this.prediccion(time);
            ++i;
        }
        double anchura = this.getBattleFieldWidth();
        double altura = this.getBattleFieldHeight();
        if (p.x > anchura - 18.0) {
            p.x = anchura - 18.0;
        }
        if (p.x < 18.0) {
            p.x = 18.0;
        }
        if (p.y > altura - 18.0) {
            p.y = altura - 18.0;
        }
        if (p.y < 18.0) {
            p.y = 18.0;
        }
        double gunOffset = this.getGunHeadingRadians() - this.absBearing(this.getX(), this.getY(), p.x, p.y);
        this.setTurnGunLeftRadians(Utils.normalRelativeAngle((double)gunOffset));
    }

    private void fuego() {
        if (this.enemigo.nombre != "" && this.potencia > 0.0) {
            this.fire(this.potencia);
        }
    }

    private double distancia(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    private double absBearing(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double absBearing = Utils.normalAbsoluteAngle((double)Math.atan2(x, y));
        return absBearing;
    }

    private Point2D.Double prediccion(long tFuturo) {
        double nuevaX;
        double nuevaY;
        double tDiferncia = (double)tFuturo - this.enemigo.tiempo;
        double cambioHead = this.enemigo.head - this.enemigo.lastHead;
        if (Math.abs(cambioHead) > 1.0E-5) {
            double radio = this.enemigo.velocidad / cambioHead;
            double nuevoHead = tDiferncia * cambioHead;
            nuevaY = this.enemigo.y + Math.sin(this.enemigo.head + nuevoHead) * radio - Math.sin(this.enemigo.head) * radio;
            nuevaX = this.enemigo.x + Math.cos(this.enemigo.head) * radio - Math.cos(this.enemigo.head + nuevoHead) * radio;
        } else {
            nuevaY = this.enemigo.y + Math.cos(this.enemigo.head) * this.enemigo.velocidad * tDiferncia;
            nuevaX = this.enemigo.x + Math.sin(this.enemigo.head) * this.enemigo.velocidad * tDiferncia;
            if (this.enemigo.distancia < 200.0) {
                nuevaY = this.enemigo.y;
                nuevaX = this.enemigo.x;
            }
        }
        return new Point2D.Double(nuevaX, nuevaY);
    }
}

