/*
 * Decompiled with CFR 0.152.
 */
package japs;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;

public class Sjonniebot
extends AdvancedRobot {
    boolean backOut;
    boolean backingOut;
    boolean accelerating;
    boolean forward;
    boolean targetInSight;
    double destX;
    double destY;
    double minX;
    double minY;
    double maxX;
    double maxY;
    double fieldWidth;
    double fieldHeight;
    double opponentEnergy;
    double oppX;
    double oppY;
    double oppDistance;
    double oppDeviation;
    double lastOppHeading;
    double lastOppX;
    double lastOppY;
    double lastMyX;
    double lastMyY;
    double curMaxVelocity;

    public void run() {
        this.out.println("Ik ben $id$");
        this.setColors(Color.red, Color.blue, Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.minX = 100.0;
        this.minY = 100.0;
        this.maxX = this.getBattleFieldWidth() - 100.0;
        this.maxY = this.getBattleFieldHeight() - 100.0;
        this.fieldWidth = this.maxX - this.minX;
        this.fieldHeight = this.maxY - this.minY;
        this.oppX = -1.0;
        this.oppY = -1.0;
        this.backOut = false;
        this.backingOut = false;
        this.accelerating = false;
        this.forward = true;
        this.opponentEnergy = -1.0;
        this.lastOppX = -1.0;
        this.lastOppY = -1.0;
        this.oppDeviation = 1.0;
        this.targetInSight = false;
        this.newDestination();
        this.turnRadarRight(360.0);
        while (true) {
            this.moveMe();
            this.turnRadarRight(360.0);
            this.execute();
        }
    }

    public double getNewHeading() {
        double heading = Math.toDegrees(Math.atan2(this.destX - this.getX(), this.destY - this.getY()));
        if (!this.forward) {
            heading = (180.0 - heading + 720.0) % 360.0;
        }
        return heading;
    }

    public void updateForward() {
        double newHeading = this.getNewHeading();
        if (Math.abs(newHeading) > 180.0) {
            this.forward = !this.forward;
        }
    }

    public void newDestination() {
        this.destX = Math.random() * this.fieldWidth + this.minX;
        this.destY = Math.random() * this.fieldHeight + this.minY;
        this.updateForward();
    }

    public void evade(double dangerAngle) {
        double evadeRadians = Math.toRadians(dangerAngle + (Math.random() < 0.5 ? -1.0 : 1.0) * (80.0 + Math.random() * 20.0));
        if (!this.forward) {
            evadeRadians = Math.PI + evadeRadians;
        }
        this.destX = Math.min(Math.max(Math.sin(evadeRadians) * this.fieldWidth + this.minX, this.minX), this.maxX);
        this.destY = Math.min(Math.max(Math.cos(evadeRadians) * this.fieldHeight + this.minY, this.minY), this.maxY);
        this.updateForward();
    }

    public void moveMe() {
        double curX = this.getX();
        double curY = this.getY();
        double curHeading = this.getHeading();
        double curVelocity = this.getVelocity();
        double speedDelta = Math.random() * 2.0;
        if (Math.abs(curX - this.destX) < 50.0 && Math.abs(curY - this.destY) < 50.0) {
            this.newDestination();
        }
        double newHeading = this.getNewHeading();
        this.setTurnAny(newHeading - curHeading);
        if (this.backOut && !this.backingOut) {
            this.backingOut = true;
        } else if (Math.abs(this.getDistanceRemaining()) < 100.0) {
            this.backOut = false;
            this.backingOut = false;
            if (this.forward) {
                this.setAhead(300.0);
            } else {
                this.setBack(300.0);
            }
        }
        this.curMaxVelocity = (this.accelerating ? speedDelta : -speedDelta) + this.curMaxVelocity;
        this.setMaxVelocity(this.curMaxVelocity);
        if (this.curMaxVelocity > 7.0) {
            this.accelerating = false;
        } else if (this.curMaxVelocity < 3.0) {
            this.accelerating = true;
        }
    }

    public void setTurnAny(double angle) {
        if ((angle = (angle + 720.0) % 360.0) > 180.0) {
            this.setTurnLeft(360.0 - angle);
        } else {
            this.setTurnRight(angle);
        }
    }

    public void turnGunAny(double angle) {
        if ((angle = (angle + 720.0) % 360.0) > 180.0) {
            this.turnGunLeft(360.0 - angle);
        } else {
            this.turnGunRight(angle);
        }
        this.addCustomEvent(new GunAimedCondition());
        this.targetInSight = true;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.backingOut) {
            this.backOut = true;
            this.evade(e.getHeading());
        }
        this.curMaxVelocity = 8.0;
        this.setMaxVelocity(this.curMaxVelocity);
        this.accelerating = true;
        this.moveMe();
        this.execute();
    }

    public void onHitWall(HitWallEvent e) {
        this.evade(e.getBearing() + this.getHeading());
        this.moveMe();
    }

    public void aimGun(double oppHeading, double oppVelocity) {
        double newOppHeading;
        double shootDistance = oppVelocity * this.oppDistance / 11.0;
        double nextOppX = this.oppX + Math.sin(Math.toRadians(oppHeading * this.oppDeviation)) * shootDistance * this.oppDeviation;
        double nextOppY = this.oppY + Math.cos(Math.toRadians(oppHeading * this.oppDeviation)) * shootDistance * this.oppDeviation;
        double lastOppHeading = newOppHeading = Math.toDegrees(Math.atan2(nextOppX - this.getX(), nextOppY - this.getY()));
        this.turnGunAny((newOppHeading - this.getGunHeading() + 720.0) % 360.0);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double newOpponentEnergy = e.getEnergy();
        double myHeading = this.getHeading();
        double myX = this.getX();
        double myY = this.getY();
        double oppBearing = e.getBearing();
        this.oppDistance = e.getDistance();
        double oppVelocity = e.getVelocity();
        double oppHeading = e.getHeading();
        this.oppX = myX + Math.sin(Math.toRadians(myHeading + oppBearing)) * this.oppDistance;
        this.oppY = myY + Math.cos(Math.toRadians(myHeading + oppBearing)) * this.oppDistance;
        this.aimGun(oppHeading, oppVelocity);
        if (this.opponentEnergy > newOpponentEnergy && !this.backingOut) {
            this.backOut = true;
            this.evade(e.getHeading());
            this.curMaxVelocity = 8.0;
            this.setMaxVelocity(this.curMaxVelocity);
            this.accelerating = true;
            this.moveMe();
            this.execute();
        }
        this.opponentEnergy = newOpponentEnergy;
        this.moveMe();
    }

    public void smartFire(double robotDistance) {
        this.fire(this.getFirePower(robotDistance));
    }

    public double getFirePower(double robotDistance) {
        if (robotDistance < 400.0) {
            return 3.0;
        }
        return 2.0;
    }

    public void onHitRobot(HitRobotEvent e) {
        if (!e.isMyFault() && !this.backingOut) {
            this.forward = !this.forward;
            this.newDestination();
        }
        double gunTurn = (e.getBearing() + this.getHeading() - this.getGunHeading() + 720.0) % 360.0;
        this.turnGunAny(gunTurn);
        this.moveMe();
        this.execute();
    }

    public void onCustomEvent(CustomEvent e) {
        Condition condition = e.getCondition();
        if (condition instanceof GunAimedCondition) {
            this.removeCustomEvent(condition);
            this.smartFire(this.oppDistance);
            this.targetInSight = false;
        }
    }

    class GunAimedCondition
    extends Condition {
        GunAimedCondition() {
        }

        public boolean test() {
            return Sjonniebot.this.targetInSight && Sjonniebot.this.getGunHeat() == 0.0 && Sjonniebot.this.getGunTurnRemaining() == 0.0;
        }
    }
}

