/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import java.util.HashMap;
import robocode.Bullet;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.EnemyListener;
import syl.fire.FireStrategy;
import syl.fire.VirtualBullet;
import syl.util.Coordinate;

public class JiggleFireStrategy
extends FireStrategy
implements EnemyListener {
    private HashMap oscilliatingTrackers = new HashMap();

    public JiggleFireStrategy(BaseRobot robot) {
        super(robot);
    }

    public boolean isEvasiveFireStrategy() {
        return false;
    }

    public void initialize() {
        this.getRobot().getEnemyMap().addEnemyListener(this);
    }

    public void cleanUp() {
    }

    public Bullet fireBullet(Enemy enemy) {
        JiggleTracker oscilliatingTracker = (JiggleTracker)this.oscilliatingTrackers.get(enemy.getName());
        if (oscilliatingTracker == null) {
            return null;
        }
        return super.fireBullet(enemy);
    }

    public Coordinate getFuturePosition(Enemy enemy, double firePower) {
        Coordinate targetCoordinate = enemy.getCoordinate().getClone();
        JiggleTracker oscilliatingTracker = (JiggleTracker)this.oscilliatingTrackers.get(enemy.getName());
        long averageVelocityReverseTime = oscilliatingTracker.getAverageVelocityReverseTime();
        long nextVelocityReverseTime = oscilliatingTracker.getLastVelocityReverseTime() + averageVelocityReverseTime;
        long now = this.getRobot().getTime();
        int i = 0;
        while (i < 1) {
            double distance = targetCoordinate.getDistance(this.getRobot().getCoordinate());
            long bulletArrivalTime = this.getRobot().getTime() + (long)((int)Math.round(distance / (20.0 - 3.0 * firePower)));
            long enemyReactionTime = bulletArrivalTime - enemy.getScanTime();
            long futureTime = now + enemyReactionTime;
            targetCoordinate = this.getFuturePosition(enemy.getCoordinate(), enemy.getHeading(), enemy.getVelocity(), averageVelocityReverseTime, nextVelocityReverseTime, now, futureTime);
            ++i;
        }
        return targetCoordinate;
    }

    /*
     * Unable to fully structure code
     */
    public Coordinate getFuturePosition(Coordinate currentCoordinate, double heading, double velocity, long averageVelocityChangeTime, long nextVelocityChangetime, long now, long futureTime) {
        currentPatternTime = averageVelocityChangeTime - (nextVelocityChangetime - now);
        numberOfTurns = 0;
        if (averageVelocityChangeTime != 0L) ** GOTO lbl7
        return currentCoordinate;
lbl-1000:
        // 1 sources

        {
            ++numberOfTurns;
            nextVelocityChangetime += averageVelocityChangeTime;
lbl7:
            // 2 sources

            ** while (nextVelocityChangetime < futureTime)
        }
lbl8:
        // 1 sources

        moveTimeSinceLastReverse = averageVelocityChangeTime - (nextVelocityChangetime - futureTime);
        relativePosition = numberOfTurns % 2 == 0 ? moveTimeSinceLastReverse - currentPatternTime : averageVelocityChangeTime - currentPatternTime - moveTimeSinceLastReverse;
        distance = velocity * (double)relativePosition;
        futurePosition = currentCoordinate.getCoordinate(distance, heading);
        return futurePosition;
    }

    public void onEnemyChange(Enemy enemy) {
        JiggleTracker oscilliatingTracker = (JiggleTracker)this.oscilliatingTrackers.get(enemy.getName());
        if (oscilliatingTracker == null) {
            oscilliatingTracker = new JiggleTracker();
            this.oscilliatingTrackers.put(enemy.getName(), oscilliatingTracker);
        }
        if (enemy.getOldVelocity() == 0.0 && enemy.getVelocity() != 0.0) {
            oscilliatingTracker.velocityReverse(this.getRobot().getTime());
        }
        if (enemy.getOldVelocity() * enemy.getVelocity() < 0.0) {
            oscilliatingTracker.velocityReverse(this.getRobot().getTime());
        }
    }

    public void onEnemyDeath(Enemy enemy) {
        this.oscilliatingTrackers.remove(enemy.getName());
    }

    public void bulletMissed(VirtualBullet trackingBullet) {
    }

    public void bulletHit(VirtualBullet trackingBullet) {
    }

    class JiggleTracker {
        private long[] velocityReverseTimes = new long[5];
        private long previousChangeTime;
        private int index;

        public void velocityReverse(long time) {
            long difference = time - this.previousChangeTime;
            this.previousChangeTime = time;
            this.velocityReverseTimes[this.index] = difference;
            ++this.index;
            if (this.index >= this.velocityReverseTimes.length) {
                this.index = 0;
            }
        }

        public long getLastVelocityReverseTime() {
            return this.previousChangeTime;
        }

        public long getAverageVelocityReverseTime() {
            long total = 0L;
            int i = 0;
            while (i < this.velocityReverseTimes.length) {
                total += this.velocityReverseTimes[i];
                ++i;
            }
            return total / (long)this.velocityReverseTimes.length;
        }
    }
}

