/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.util.HashMap;
import java.util.Map;
import xander.core.log.Log;
import xander.core.log.Logger;

public class RunTimeLogger {
    private static final Log log = Logger.getLog(RunTimeLogger.class);
    private static final Map<String, RunTimeLogger> loggers = new HashMap<String, RunTimeLogger>();
    private String loggerFor;
    private double cumulativeTime;
    private int numExecutions;
    private double[] peakTimes = new double[5];
    private long startTime;
    private long stopTime;
    private boolean active = true;

    public static RunTimeLogger getLoggerFor(String loggerFor) {
        RunTimeLogger runTimeLogger = loggers.get(loggerFor);
        if (runTimeLogger == null) {
            runTimeLogger = new RunTimeLogger(loggerFor);
            loggers.put(loggerFor, runTimeLogger);
        }
        return runTimeLogger;
    }

    public static void logAll() {
        for (RunTimeLogger rtLogger : loggers.values()) {
            rtLogger.log();
        }
    }

    private RunTimeLogger(String loggerFor) {
        this.loggerFor = loggerFor;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public void stop() {
        this.stopTime = System.nanoTime();
        if (this.active) {
            double exeTimeMS = (double)(this.stopTime - this.startTime) / 1000000.0;
            ++this.numExecutions;
            this.cumulativeTime += exeTimeMS;
            if (exeTimeMS > this.peakTimes[this.peakTimes.length - 1]) {
                int i = 0;
                while (exeTimeMS < this.peakTimes[i]) {
                    ++i;
                }
                int j = this.peakTimes.length - 1;
                while (j > i) {
                    this.peakTimes[j] = this.peakTimes[j - 1];
                    --j;
                }
                this.peakTimes[i] = exeTimeMS;
            }
        }
    }

    public void log() {
        if (this.active) {
            double avgExeTime = this.cumulativeTime / (double)this.numExecutions;
            StringBuilder sb = new StringBuilder();
            sb.append(this.loggerFor).append(": ").append(Logger.format(avgExeTime, 3)).append(" ms average, ");
            int i = 0;
            while (i < this.peakTimes.length) {
                if (i > 0) {
                    sb.append(';');
                }
                sb.append(Logger.format(this.peakTimes[i], 3));
                ++i;
            }
            sb.append(" ms peaks.");
            log.info(sb.toString());
        }
    }
}

