/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.geo;

import dmh.robocode.geo.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class Wave {
    private Point startPoint;
    private long startTime;
    private double speed;
    private double radius;

    public Wave(Point startPoint, double speed, long startTime) {
        this.startPoint = startPoint;
        this.startTime = startTime;
        this.speed = speed;
        this.radius = 0.0;
    }

    public boolean hasReached(Point target) {
        return this.hasReached(target, 0.0);
    }

    public boolean hasReached(Point target, double tolerance) {
        return this.startPoint.getDistanceFrom(target) <= this.radius + tolerance;
    }

    public void setCurrentTime(long currentTime) {
        this.radius = (double)(currentTime - this.startTime) * this.speed;
    }

    public void paint(Graphics2D g, Color color, int thickness) {
        g.setColor(color);
        g.setStroke(new BasicStroke(thickness));
        g.drawOval((int)Math.round(this.startPoint.getX() - this.radius), (int)Math.round(this.startPoint.getY() - this.radius), this.getDiameterAsInteger(), this.getDiameterAsInteger());
    }

    private int getDiameterAsInteger() {
        return (int)Math.round(this.radius * 2.0);
    }
}

