/*
 * Decompiled with CFR 0.152.
 */
package e32;

import execution.CosmeticListener;
import execution.EventAdaptor;
import execution.GravityListener;
import execution.GunListener;
import execution.INotifiable;
import execution.MessageRouter;
import execution.OneOnOneRadarListener;
import execution.Painter;
import execution.RobotListener;
import execution.Sequencer;
import execution.TeamRouter;
import execution.WaveListener;
import java.io.PrintStream;
import robocode.robotinterfaces.IAdvancedEvents;
import robocode.robotinterfaces.IAdvancedRobot;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IPaintEvents;
import robocode.robotinterfaces.IPaintRobot;
import robocode.robotinterfaces.ITeamEvents;
import robocode.robotinterfaces.ITeamRobot;
import robocode.robotinterfaces.peer.IAdvancedRobotPeer;
import robocode.robotinterfaces.peer.IBasicRobotPeer;
import robocode.robotinterfaces.peer.ITeamRobotPeer;
import sim.Data;

public final class Omni
implements IAdvancedRobot,
IPaintRobot,
ITeamRobot,
Runnable {
    private Sequencer _sequencer = new Sequencer();
    private EventAdaptor _dispatch;
    private Painter _painter;
    private MessageRouter _router = new MessageRouter();
    private TeamRouter _teamListener;

    public Omni() {
        this._dispatch = new EventAdaptor(this._router, this._sequencer);
        this._painter = new Painter(this._router);
        Data.Initialize(this._router);
        this.Register(new RobotListener(this._painter));
        this.Register(new WaveListener(this._painter));
        this.Register(new OneOnOneRadarListener(this._sequencer));
        this.Register(new GravityListener(this._sequencer, this._painter));
        this.Register(new GunListener(this._sequencer, this._painter));
        this.Register(new CosmeticListener(this._sequencer));
        this._teamListener = null;
    }

    private final void Register(INotifiable notifiable) {
        notifiable.Initialize(this._router);
    }

    @Override
    public void run() {
        while (true) {
            this._dispatch.Update();
            this._painter.Draw();
            this._sequencer.Execute();
            this._router.reset();
        }
    }

    public IBasicEvents getBasicEventListener() {
        return this._dispatch;
    }

    public Runnable getRobotRunnable() {
        return this;
    }

    public void setOut(PrintStream arg0) {
    }

    public void setPeer(IBasicRobotPeer arg0) {
        IAdvancedRobotPeer peer = (IAdvancedRobotPeer)arg0;
        this._dispatch.SetPeer(peer);
        this._sequencer.SetPeer(peer);
        if (arg0 instanceof ITeamRobotPeer) {
            this._teamListener = new TeamRouter((ITeamRobotPeer)arg0, this._router);
            this.Register(this._teamListener);
        }
    }

    public IAdvancedEvents getAdvancedEventListener() {
        return this._dispatch;
    }

    public IPaintEvents getPaintEventListener() {
        return this._painter;
    }

    public ITeamEvents getTeamEventListener() {
        return this._teamListener;
    }
}

