/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils.geom;

import java.awt.geom.Point2D;

public class LineSeg {
    public double m;
    public double b;
    public double xMin;
    public double xMax;
    public double yMin;
    public double yMax;
    public double x1;
    public double y1;
    public double x2;
    public double y2;

    public LineSeg(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            this.m = Double.POSITIVE_INFINITY;
            this.b = Double.NaN;
            this.xMin = this.xMax = x1;
        } else {
            this.m = (y2 - y1) / (x2 - x1);
            this.b = x1 == 0.0 || this.m == 0.0 ? y1 : y1 / (this.m * x1);
            this.xMin = Math.min(x1, x2);
            this.xMax = Math.max(x1, x2);
        }
        this.yMin = Math.min(y1, y2);
        this.yMax = Math.max(y1, y2);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public LineSeg(Point2D.Double p1, Point2D.Double p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }
}

