/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.bot;

import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.debug.Debug;
import pedersen.divination.WaveData;
import pedersen.misc.Arena;
import pedersen.physics.Projection;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.bot.BearingOffsetRange;
import pedersen.tactics.bot.BearingOffsetTracker;
import pedersen.tactics.bot.WaveAnalysis;

public abstract class WaveAnalysisBase
implements WaveAnalysis {
    protected static final int seg1 = 5;
    protected static final int seg2 = 5;
    protected static final int seg3 = 5;
    protected static final int seg4 = 5;
    protected final BearingOffsetTracker unsegmentedBearingOffsetTracker;
    protected final BearingOffsetTracker[][][][] bearingOffsetTrackers;

    public WaveAnalysisBase(BearingOffsetTracker newUnsegmentedBearingOffsetTracker) {
        this.unsegmentedBearingOffsetTracker = newUnsegmentedBearingOffsetTracker;
        this.bearingOffsetTrackers = new BearingOffsetTracker[5][5][5][5];
    }

    public static WaveData getWaveData(StaticPosition firingPosition, Snapshot target, double bulletVelocity, BearingOffsetRange rangeOfMotion) {
        double bearingToTarget = firingPosition.getBearing(target);
        double distanceToTarget = firingPosition.getDistance(target);
        StaticPosition projectedTarget = new Projection(target).project().getStaticPosition();
        double tangentalVelocity = WaveAnalysisBase.getTangentalVelocity(firingPosition, target);
        double headonVelocity = distanceToTarget - firingPosition.getDistance(projectedTarget);
        double wallProximityForward = target.getDistance(Arena.getWallIntercept(target, target.getHeading(), target.getVelocity()));
        double wallProximityReverse = target.getDistance(Arena.getWallIntercept(target, target.getHeading(), -target.getVelocity()));
        return new WaveData(tangentalVelocity, headonVelocity, wallProximityForward, wallProximityReverse, bearingToTarget, distanceToTarget, rangeOfMotion);
    }

    private static double getTangentalVelocity(StaticPosition firingPosition, Snapshot target) {
        double bearingToTarget = firingPosition.getBearing(target);
        StaticPosition projectedTarget = new Projection(target).project().getStaticPosition();
        StaticPositionImpl controlPosition = new StaticPositionImpl((StaticPosition)target, new StaticVectorImpl(bearingToTarget + 1.5707963267948966, 8.0));
        double bearingToProjectedTarget = Constraints.getNegativePiToPi(firingPosition.getBearing(projectedTarget) - bearingToTarget);
        double bearingToControlPosition = Constraints.getNegativePiToPi(firingPosition.getBearing(controlPosition) - bearingToTarget);
        double tangentalVelocity = bearingToProjectedTarget / bearingToControlPosition;
        return tangentalVelocity;
    }

    protected static int translateVelocityScalarToIndex(double velocityScalar) {
        int index = velocityScalar > 0.75 ? 4 : (velocityScalar > 0.25 ? 3 : (velocityScalar < -0.75 ? 0 : (velocityScalar < -0.25 ? 1 : 2)));
        return index;
    }

    protected static int translateVelocityToIndex(double velocity) {
        int index = velocity > 6.0 ? 4 : (velocity > 2.0 ? 3 : (velocity < -6.0 ? 0 : (velocity < -2.0 ? 1 : 2)));
        index = 0;
        return index;
    }

    protected static int translateDistanceToIndex(double distance) {
        int index = distance < 80.0 ? 0 : (distance < 160.0 ? 1 : (distance < 240.0 ? 2 : (distance < 320.0 ? 3 : 4)));
        return index;
    }

    public void onFire() {
    }

    public void debug() {
        Debug.debug("Wave Analysis:");
        int i = 0;
        while (i < 5) {
            int ii = 0;
            while (ii < 5) {
                int iii = 0;
                while (iii < 5) {
                    int iv = 0;
                    while (iv < 5) {
                        if (this.bearingOffsetTrackers[i][ii][iii][iv] != null) {
                            Debug.debug("this.bearingOffsetTrackers[ " + i + " ][ " + ii + " ][ " + iii + " ][ " + iv + " ]:");
                            this.bearingOffsetTrackers[i][ii][iii][iv].debug();
                        }
                        ++iv;
                    }
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }
    }
}

